theory question_99_1

imports Main

begin
typedecl entity
typedecl event

consts
  Dog :: "entity ⇒ bool"
  Grass :: "entity ⇒ bool"
  Running :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  Patient :: "event ⇒ entity ⇒ bool"
  On :: "entity ⇒ entity ⇒ bool"

(* Explanation 1: When a dog is running on the grass, it is also on the grass. *)
axiomatization where
  explanation_1: "∀x y e. Dog x ∧ Grass y ∧ Running e ∧ Agent e x ∧ Patient e y ⟶ On x y"

theorem hypothesis:
  (* Premise: A dog running on grass *)
  assumes asm: "Dog x ∧ Grass y ∧ Running e ∧ Agent e x ∧ Patient e y"
  (* Hypothesis: A dog is on the grass. *)
  shows "∃x y. Dog x ∧ Grass y ∧ On x y"
proof -
  from asm have "Dog x ∧ Grass y ∧ Running e ∧ Agent e x ∧ Patient e y" by blast
  then have "Dog x ∧ Grass y ∧ On x y" using explanation_1 by blast
  then show ?thesis using asm by blast
qed

end
