theory question_85_8
imports Main

begin
typedecl entity

consts
  Vendor :: "entity ⇒ bool"
  FlowerCart :: "entity ⇒ bool"
  AssociatedWith :: "entity ⇒ entity ⇒ bool"
  FlowerSeller :: "entity ⇒ bool"
  Sidewalk :: "entity ⇒ bool"
  On :: "entity ⇒ entity ⇒ bool"

(* Explanation 1: A vendor associated with a flower cart is a flower seller. *)
axiomatization where
  explanation_1: "∀x y. Vendor x ∧ FlowerCart y ∧ AssociatedWith x y ⟶ FlowerSeller x"

(* Explanation 2: If a vendor is on the sidewalk, then the flower seller is also on the sidewalk. *)
axiomatization where
  explanation_2: "∀x y. Vendor x ∧ Sidewalk y ∧ On x y ⟶ (∃z. FlowerSeller z ∧ On z y)"

theorem hypothesis:
  (* Premise: Sidewalk flower cart vendor. *)
  assumes asm: "Vendor x ∧ FlowerCart y ∧ Sidewalk z ∧ On x z"
  (* Hypothesis: Flower seller on sidewalk. *)
  shows "∃x y. FlowerSeller x ∧ Sidewalk y ∧ On x y"
proof -
  from asm have "Vendor x ∧ FlowerCart y ∧ On x z" by blast
  then have "FlowerSeller x" using explanation_1 by blast
  from asm have "Vendor x ∧ Sidewalk z ∧ On x z" by blast
  then have "∃z. FlowerSeller z ∧ On z z" using explanation_2 by blast
  then show ?thesis using asm `FlowerSeller x` by blast
qed

end
