theory question_73_0

imports Main

begin
typedecl entity

consts
  GroupOfPeople :: "entity ⇒ bool"
  People :: "entity ⇒ bool"
  Beach :: "entity ⇒ bool"
  On :: "entity ⇒ entity ⇒ bool"
  Camera :: "entity ⇒ bool"
  With :: "entity ⇒ entity ⇒ bool"

(* Explanation 1: Group of people are people. *)
axiomatization where
  explanation_1: "∀x. GroupOfPeople x ⟶ People x"

theorem hypothesis:
  (* Premise: A group of people on the beach with cameras. *)
  assumes asm: "GroupOfPeople x ∧ Beach y ∧ Camera z ∧ On x y ∧ With x z"
  (* Hypothesis: People are on a beach. *)
  shows "∃x y. People x ∧ Beach y ∧ On x y"
proof -
  from asm have "GroupOfPeople x ∧ Beach y ∧ On x y" by blast
  then have "People x ∧ Beach y ∧ On x y" using explanation_1 by blast
  then show ?thesis using asm by blast
qed

end
