theory question_70_2
imports Main

begin
typedecl entity
typedecl event

consts
  Man :: "entity ⇒ bool"
  Woman :: "entity ⇒ bool"
  TwoPeople :: "entity ⇒ entity ⇒ bool"
  Someone :: "entity ⇒ bool"
  Skyline :: "entity ⇒ bool"
  Staring :: "entity ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  LookingOutside :: "event ⇒ bool"
  Stare :: "event ⇒ bool"
  At :: "event ⇒ entity ⇒ bool"
  Looking :: "event ⇒ bool"
  Outside :: "event ⇒ bool"

(* Explanation 1: A man and a woman are two people. *)
axiomatization where
  explanation_1: "∀x y. Man x ∧ Woman y ⟶ TwoPeople x y"

(* Explanation 2: When someone is staring at the skyline, they are looking outside. *)
axiomatization where
  explanation_2: "∀x e. Someone x ∧ Skyline e ∧ Staring x ∧ Agent e x ⟶ LookingOutside e"

theorem hypothesis:
  (* Premise: A man and a woman stare at the skyline. *)
  assumes asm: "Man x ∧ Woman y ∧ Skyline z ∧ Stare e ∧ Agent e x ∧ Agent e y ∧ At e z"
  (* Hypothesis: The two people are looking outside. *)
  shows "∃x e. TwoPeople x ∧ Looking e ∧ Agent e x ∧ Outside e"
proof -
  from asm have "Man x ∧ Woman y" by blast
  then have "TwoPeople x" using explanation_1 by blast
  from asm have "Skyline z ∧ Stare e ∧ Agent e x ∧ Agent e y ∧ At e z" by blast
  then have "LookingOutside e" using explanation_2 by blast
  then show ?thesis using `TwoPeople x` `LookingOutside e` by blast
qed

end
