theory question_61_0
imports Main

begin
typedecl entity
typedecl event
consts
  Seafood :: "entity ⇒ bool"
  Food :: "entity ⇒ bool"
  FormOf :: "entity ⇒ entity ⇒ bool"
  Woman :: "entity ⇒ bool"
  Eating :: "entity ⇒ bool"
  Agent :: "entity ⇒ entity ⇒ bool"
  Sunglasses :: "entity ⇒ bool"
  PoutingFace :: "entity ⇒ bool"

(* Explanation 1: Seafood is a form of food that the woman is eating. *)
axiomatization where
  explanation_1: "∀x y. Seafood x ∧ Food y ∧ FormOf x y ∧ (∃e. Woman e ∧ Eating e ∧ Agent e x)"

theorem hypothesis:
  (* Premise: A woman in sunglasses making a pouting face while eating seafood. *)
  assumes asm: "Woman x ∧ Sunglasses y ∧ PoutingFace z ∧ Seafood z ∧ Eating e ∧ Agent e x"
  (* Hypothesis: A woman is eating. *)
  shows "∃x e. Woman x ∧ Eating e ∧ Agent e x"
proof -
  from asm have "Seafood z ∧ Eating e ∧ Agent e x" by blast
  then have "∃y. Food y ∧ FormOf z y ∧ (∃e. Woman e ∧ Eating e ∧ Agent e z)" using explanation_1 by blast
  then show ?thesis using asm by blast
qed

end
