######################
# Supplementary code
# Paper: Nauman Dawalatabad, Yuan Gong, Sameer Khurana, Rhoda Au, James Glass, "Detecting Dementia from Long Neuropsychological Interviews", Findings of the Association for Computational Linguistics: EMNLP 2021.
######################

list=$1

corpus_directory=/path/to/dataset/
wav_soft_link_dir=/path/to/wav/
tg_dir=/path/to/textgrids/ 
while read -r x;
do
	cp -P $wav_soft_link_dir/$x.wav   $corpus_directory/
	cp $tg_dir/$x.TextGrid  $corpus_directory/
done < $list

dict_path=pretrained_models_downloaded/dictionary/english.dict
acoustic_model_path=pretrained_models_downloaded/acoustic/english.zip
output_path=/path/to/outputs/ 
tmp_dir=/path/to/temp/files/ 

# ADAPT
# Syntax: mfa adapt corpus_directory dictionary_path acoustic_model_path output_path
mfa adapt \
	-o $output_path/adapted_model/fhs_adapted \
	-j 16 \
	-t $tmp_dir \
	--clean \
	--overwrite \
	$corpus_directory \
	$dict_path \
	$acoustic_model_path \
	$output_path
