# Deep Reinforcement Learning for Entity Alignment


## Dependencies

Please first download the dataset from [OpenEA](https://github.com/nju-websoft/OpenEA), and then install gym and required packages of OpenEA:

```bash
conda create -n openea python=3.6
conda activate openea
conda install tensorflow-gpu==1.8
conda install -c conda-forge graph-tool==2.29
conda install -c conda-forge python-igraph
pip install -r requirement.txt
pip install gym
```

## Quick Start

Use the following scripts to run RLEA with RDGCN as basic EEA model on D-Y:

```bash
cd run
python runRLEA.py --model_name rdgcn --dataset D_Y
```

If run with the stored embeddings:

```bash
python runRLEA.py --model_name rdgcn --dataset D_Y --restore_embeddings True
```

For SEA which has projection matrices:

```bash
python runRLEA.py --model_name sea --dataset D_Y --mapping True
```


Currently available EEA models: JAPE, SEA, RSN, RDGCN, AlignE, BootEA. 

The corresponding model names: jape, sea, rsn, rdgcn, aligne, bootea.

Currently available datasets: EN_FR, EN_DE, D_W, D_Y