from plotnine import *
from plotnine.scales import *
from experiments import funcs, estimators
import pandas as pd
import matplotlib.pyplot as plt

estimators = ['MLE', 'HT', 'CS', 'MM', 'J', 'NSB']

data = [
    ['bg', 'ca', 0.006859796866119261, 0.676, 1.7671075571981292, 0.676, 0.006838481575217159, 0.676, 1.7671322339462328, 0.676, 0.006838481575217159, 0.676, 1.7671322339462328, 0.676, -0.007846085486821863, 0.676, 1.818578145433423, 0.676, -0.00881117407062515, 0.637, 1.820921177030848, 0.647, -0.027829565653805233, 0.647, 1.906401914160288, 0.647],
    ['bg', 'es', 0.04377223132514185, 0.048, 1.6828628119838984, 0.048, 0.04321114577887841, 0.048, 1.6838031219343774, 0.048, 0.04321114577887841, 0.048, 1.6838031219343774, 0.048, 0.02906634897220073, 0.044, 1.7343334002191924, 0.048, 0.027885766823043667, 0.043, 1.7371106232837787, 0.044, 0.008280908323909264, 0.048, 1.8242311031220964, 0.048],
    ['bg', 'fr', 0.02840369457545, 0.176, 1.7175158817949971, 0.176, 0.02822020849669471, 0.176, 1.7178039467291115, 0.176, 0.02822020849669471, 0.176, 1.7178039467291115, 0.176, 0.013697812222508432, 0.176, 1.7689864700302915, 0.176, 0.012619994904493392, 0.172, 1.7715569455064386, 0.176, -0.006626773960519028, 0.176, 1.8578887063041458, 0.176],
    ['bg', 'hr', 0.343881373304876, 0.001, 1.4754584012041003, 0.001, 0.2845250078859012, 0.001, 1.5977777129557635, 0.001, 0.27183997873040366, 0.001, 1.6213994800598868, 0.001, 0.31446960859899376, 0.001, 1.5636936953217473, 0.001, 0.29657093835482573, 0.001, 1.6001060135799046, 0.001, 0.2531976383748462, 0.001, 1.71461696197591, 0.001],
    ['bg', 'it', 0.04203056844234787, 0.086, 1.6954674994355559, 0.086, 0.04174909081872591, 0.086, 1.695850043209985, 0.086, 0.04174909081872591, 0.086, 1.695850043209985, 0.086, 0.027324686089406747, 0.086, 1.74693808767085, 0.086, 0.026202854178718704, 0.081, 1.7495949989391226, 0.083, 0.006836383109429134, 0.086, 1.8363185353224176, 0.086],
    ['bg', 'pt', 0.03586150501553087, 0.095, 1.6938839531207788, 0.095, 0.03533777088768186, 0.095, 1.6947843235873392, 0.091, 0.03533777088768186, 0.095, 1.6947843235873392, 0.091, 0.021155622662589746, 0.095, 1.7453545413560727, 0.095, 0.019990486082912984, 0.082, 1.7481023892774297, 0.084, 0.00044196026434706326, 0.092, 1.835081148665867, 0.089],
    ['bg', 'ru', 0.31573948014827946, 0.001, 1.4913573148197519, 0.001, 0.30998027828809327, 0.001, 1.5013969614179845, 0.001, 0.30998027828809327, 0.001, 1.5013969614179845, 0.001, 0.3010335977953382, 0.001, 1.5501808442315164, 0.001, 0.2988866540779458, 0.001, 1.5551335443484053, 0.001, 0.25769057841297505, 0.001, 1.6671188973868127, 0.001],
    ['bg', 'sk', 0.29943496664243185, 0.001, 1.562025939960914, 0.001, 0.2574520019453377, 0.001, 1.6478787400006012, 0.001, 0.2508288379952667, 0.001, 1.6607461688086396, 0.001, 0.2700232019365496, 0.001, 1.650261234078561, 0.001, 0.25823502720815217, 0.001, 1.6744528493052664, 0.001, 0.21222248431399726, 0.001, 1.7950767942141794, 0.001],
    ['bg', 'uk', 0.13503347245759256, 0.002, 1.680103638509201, 0.002, 0.12186282467095433, 0.002, 1.7213492606189067, 0.002, 0.11200959451398806, 0.002, 1.7346645528349578, 0.002, 0.11297464892818088, 0.002, 1.7536330502739066, 0.002, 0.10382183934791578, 0.002, 1.7729256052384896, 0.002, 0.056637863718510095, 0.002, 1.8899024580905692, 0.002],
    ['ca', 'es', 0.2305929079625113, 0.001, 0.91382349223326, 0.001, 0.22897269992924563, 0.001, 0.9173119763592377, 0.001, 0.22897269992924563, 0.001, 0.9173119763592377, 0.001, 0.2232399667860407, 0.001, 0.9432352569391425, 0.001, 0.22228912360051123, 0.001, 0.9453604537007226, 0.001, 0.201895565121902, 0.001, 1.0157448828994005, 0.001],
    ['ca', 'fr', 0.13096635259688838, 0.001, 1.1169925992762213, 0.001, 0.13091281413334444, 0.001, 1.1171145480926543, 0.001, 0.13091281413334444, 0.001, 1.1171145480926543, 0.001, 0.12361341142041771, 0.001, 1.1464043639821035, 0.001, 0.12303827710349635, 0.001, 1.147776925080321, 0.001, 0.10396557964673436, 0.001, 1.2156432362414178, 0.001],
    ['ca', 'hr', 0.007105386508325706, 0.652, 1.7536124083213016, 0.683, 0.00709412610471305, 0.683, 1.753693345752815, 0.683, 0.00709412610471305, 0.683, 1.753693345752815, 0.683, -0.00760049584461564, 0.683, 1.8050829965565958, 0.683, -0.0086030698803512, 0.649, 1.807510574022145, 0.667, -0.04566292520052062, 0.683, 1.8934789067926185, 0.651],
    ['ca', 'it', 0.2048290957994488, 0.001, 0.9744724782454548, 0.001, 0.20456643844886918, 0.001, 0.9750121570895933, 0.001, 0.20456643844886918, 0.001, 0.9750121570895933, 0.001, 0.19747615462297818, 0.001, 1.003884242951337, 0.001, 0.19672714275070025, 0.001, 1.0056029657670384, 0.001, 0.1770987342034016, 0.001, 1.07490560808173, 0.001],
    ['ca', 'pt', 0.2102173783806548, 0.001, 0.9497742399146317, 0.001, 0.20866118877336515, 0.001, 0.9531858971480758, 0.001, 0.20866118877336515, 0.001, 0.9531858971480758, 0.001, 0.20286443720418423, 0.001, 0.9791860046205141, 0.001, 0.20194938982775246, 0.001, 0.9812411257596336, 0.001, 0.1817234451568287, 0.001, 1.0512493638629783, 0.001],
    ['ca', 'ru', 0.015085500018475306, 0.348, 1.6972673086034606, 0.348, 0.014583373372865083, 0.348, 1.6996379887916417, 0.348, 0.014583373372865083, 0.348, 1.6996379887916417, 0.348, 0.0003796176655341821, 0.348, 1.7487378968387548, 0.348, -0.0008904295718733524, 0.333, 1.7517442556199194, 0.318, -0.0392332145582468, 0.348, 1.839884424952952, 0.328],
    ['ca', 'sk', 0.0130615743219199, 0.429, 1.7393747581260381, 0.429, 0.013043887202171423, 0.429, 1.7394775361098824, 0.429, 0.013043887202171423, 0.429, 1.7394775361098824, 0.429, -0.0016443080310212244, 0.429, 1.7908453463613325, 0.429, -0.0026763958027625767, 0.405, 1.7933322392989681, 0.384, -0.039912748624624905, 0.419, 1.879657101412223, 0.406],
    ['ca', 'uk', 0.01669406985945865, 0.362, 1.5213844772295695, 0.362, 0.005154103296875268, 0.508, 1.5644348466904212, 0.606, -0.004699126860090996, 0.929, 1.5783715491402317, 0.929, 0.0019881875065175247, 0.362, 1.5728550654648634, 0.362, -0.005955085331186938, 0.412, 1.5895359985685815, 0.37, -0.04896550165902225, 0.412, 1.680241211637001, 0.359],
    ['es', 'fr', 0.09557267397791136, 0.001, 1.1773600802179893, 0.001, 0.09556523106270443, 0.001, 1.1773726813859193, 0.001, 0.09556523106270443, 0.001, 1.1773726813859193, 0.001, 0.0882197328014408, 0.001, 1.2067718449238718, 0.001, 0.08772313685790811, 0.001, 1.2079905336117585, 0.001, 0.06914830873195599, 0.001, 1.2753267994410704, 0.001],
    ['es', 'hr', 0.007505247151008532, 0.639, 1.7423928107397504, 0.639, 0.007501962624982483, 0.639, 1.742426853995511, 0.639, 0.007501962624982483, 0.639, 1.742426853995511, 0.639, -0.0072006352019325925, 0.632, 1.7938633989750443, 0.632, -0.008212632427829547, 0.639, 1.7963130271573684, 0.637, -0.04536072672255331, 0.639, 1.8821527628977328, 0.639],
    ['es', 'it', 0.2043445172396987, 0.001, 0.9650217590687695, 0.001, 0.20365831496829057, 0.001, 0.9662688813236234, 0.001, 0.20365831496829057, 0.001, 0.9662688813236234, 0.001, 0.19699157606322804, 0.001, 0.9944335237746519, 0.001, 0.19619401712837758, 0.001, 0.9962525450519466, 0.001, 0.1766116543127405, 0.001, 1.066014380048702, 0.001],
    ['es', 'pt', 0.35086364633025013, 0.001, 0.6580618277192555, 0.001, 0.3445254697713268, 0.001, 0.6712146538141062, 0.001, 0.3445254697713268, 0.001, 0.6712146538141062, 0.001, 0.3435107051537795, 0.001, 0.6874735924251378, 0.001, 0.3419146178053127, 0.001, 0.6908939978447795, 0.001, 0.32027240939545015, 0.001, 0.7642180716337086, 0.001],
    ['es', 'ru', 0.02642145161645537, 0.196, 1.664175529111315, 0.196, 0.025917138364578873, 0.2, 1.6666938396564208, 0.179, 0.025917138364578873, 0.2, 1.6666938396564208, 0.179, 0.011715569263514136, 0.203, 1.715646117346609, 0.203, 0.010400686704538975, 0.202, 1.7187453511073585, 0.192, -0.02826014119493525, 0.196, 1.8070572348591212, 0.196],
    ['es', 'sk', 0.006522142626920968, 0.662, 1.7420337452198507, 0.642, 0.006501845542767781, 0.662, 1.7421128460989508, 0.651, 0.006501845542767781, 0.662, 1.7421128460989508, 0.651, -0.008183739726020267, 0.648, 1.7935043334551448, 0.646, -0.009216983019277869, 0.692, 1.7959967417722646, 0.668, -0.04643720535770446, 0.626, 1.882028965314046, 0.651],
    ['es', 'uk', 0.014132239374575195, 0.389, 1.5160882619031508, 0.389, 0.011600936166664355, 0.329, 1.535934146477659, 0.328, 0.011600936166664355, 0.239, 1.535934146477659, 0.269, -0.0005736429783660402, 0.38, 1.567558850138445, 0.389, -0.0031933653984961285, 0.329, 1.5735958867434527, 0.325, -0.049020749546257125, 0.387, 1.6719024487348768, 0.387],
    ['fr', 'hr', 0.021151408472735778, 0.266, 1.7190164844080111, 0.266, 0.021114501289387078, 0.266, 1.7191820325447948, 0.266, 0.021114501289387078, 0.266, 1.7191820325447948, 0.266, 0.006445526119794431, 0.266, 1.7704870726433053, 0.266, 0.005369694276253778, 0.266, 1.7730631521347455, 0.243, -0.03211709544178731, 0.266, 1.8594892436729664, 0.247],
    ['fr', 'it', 0.08568431661196374, 0.003, 1.2062581566359545, 0.003, 0.08567824285017878, 0.003, 1.206268281564384, 0.003, 0.08567824285017878, 0.003, 1.206268281564384, 0.003, 0.07833137543549318, 0.003, 1.2356699213418367, 0.003, 0.07785621832509526, 0.003, 1.2368429210440683, 0.003, 0.05974426233146657, 0.003, 1.303515866352332, 0.003],
    ['fr', 'pt', 0.17791170581361737, 0.001, 1.0078817050642361, 0.001, 0.17772760398297927, 0.001, 1.0083178561755703, 0.001, 0.17772760398297927, 0.001, 1.0083178561755703, 0.001, 0.1705587646371467, 0.001, 1.0372934697701184, 0.001, 0.16985680397892688, 0.001, 1.0389244038831074, 0.001, 0.15012826951133296, 0.001, 1.1084356950068162, 0.001],
    ['fr', 'ru', 0.00973259976351526, 0.508, 1.7014692291289104, 0.523, 0.009630524039487387, 0.524, 1.7023275534561904, 0.524, 0.009630524039487387, 0.524, 1.7023275534561904, 0.524, -0.004973282589425976, 0.524, 1.7529398173642048, 0.524, -0.00615327076553529, 0.517, 1.7557680444330752, 0.523, -0.044255420138261004, 0.524, 1.8432933619252412, 0.524],
    ['fr', 'sk', 0.02197901534670421, 0.264, 1.7150359960919994, 0.264, 0.021945645147685156, 0.264, 1.7151973997170493, 0.264, 0.021945645147685156, 0.264, 1.7151973997170493, 0.264, 0.007273132993762976, 0.264, 1.7665065843272936, 0.264, 0.0061961432922136295, 0.264, 1.7690852675348339, 0.263, -0.031316810479374735, 0.264, 1.8555821581820733, 0.264],
    ['fr', 'uk', 0.0015370413201962752, 0.932, 1.5451946543236237, 0.932, -0.0009695376461404948, 0.882, 1.5643570023826132, 0.806, -0.0009695376461404948, 0.765, 1.5643570023826132, 0.765, -0.013168841032744849, 0.924, 1.5966652425589178, 0.929, -0.015727878447751364, 0.932, 1.6025796912275325, 0.932, -0.061205537945648425, 0.932, 1.7003291246699028, 0.932],
    ['hr', 'it', 0.03138585136375305, 0.13, 1.7037529640003313, 0.13, 0.03110419183848956, 0.13, 1.7041166456144003, 0.13, 0.03110419183848956, 0.13, 1.7041166456144003, 0.13, 0.016679969010811924, 0.13, 1.7552235522356254, 0.13, 0.015561926046022467, 0.128, 1.7578824605763737, 0.13, -0.003740622556356543, 0.13, 1.8446364928540366, 0.13],
    ['hr', 'pt', 0.0095133489778787, 0.543, 1.733576295603669, 0.543, 0.009473211481503263, 0.52, 1.7336243220846903, 0.52, 0.009473211481503263, 0.52, 1.7336243220846903, 0.52, -0.005192533375062647, 0.543, 1.7850468838389635, 0.543, -0.006227015272570746, 0.521, 1.787542997360263, 0.522, -0.025219328581647105, 0.52, 1.873638613174906, 0.52],
    ['hr', 'ru', 0.43001075131576494, 0.001, 1.2498108028923667, 0.001, 0.39411546576705814, 0.001, 1.3259692984847522, 0.001, 0.38237072171062114, 0.001, 1.3452866306976092, 0.001, 0.40795192778635303, 0.001, 1.3233402146570725, 0.001, 0.39704413462329213, 0.001, 1.3458241886295754, 0.001, 0.3520410059959951, 0.001, 1.4643367666179958, 0.001],
    ['hr', 'sk', 0.5419641313474668, 0.001, 1.0639636409584299, 0.001, 0.4786103072095872, 0.001, 1.1897924761979284, 0.001, 0.45724858401550095, 0.001, 1.2269787623391282, 0.001, 0.5199053078180551, 0.001, 1.1374930527231355, 0.001, 0.5023561189792707, 0.001, 1.173216271134888, 0.001, 0.4597823865388262, 0.001, 1.2877771485166325, 0.001],
    ['hr', 'uk', 0.1627497969774483, 0.002, 1.6116670198770753, 0.002, 0.14872006213357025, 0.001, 1.657127096748116, 0.002, 0.138866831976604, 0.002, 1.6745529150615024, 0.002, 0.1406909734480366, 0.002, 1.685196431641781, 0.002, 0.1313598138714911, 0.001, 1.704855261563203, 0.001, 0.08330283811760641, 0.003, 1.8237311952663091, 0.002],
    ['it', 'pt', 0.2784300277645775, 0.001, 0.8120504265366706, 0.001, 0.27404219850835176, 0.001, 0.8214955072627517, 0.001, 0.27404219850835176, 0.001, 0.8214955072627517, 0.001, 0.2710770865881069, 0.001, 0.8414621912425528, 0.001, 0.2697974564111215, 0.001, 0.844246870999864, 0.001, 0.24882941721441737, 0.001, 0.915665037924319, 0.001],
    ['it', 'ru', 0.019517418768090766, 0.268, 1.6871049564941138, 0.268, 0.019014914801828597, 0.275, 1.6895139268581747, 0.288, 0.019014914801828597, 0.275, 1.6895139268581747, 0.288, 0.004811536415149531, 0.275, 1.7385755447294082, 0.275, 0.003528186481378648, 0.273, 1.7416089019203866, 0.267, -0.03491319090097522, 0.275, 1.8295537067026364, 0.275],
    ['it', 'sk', 0.01928218558669348, 0.29, 1.7256350209863753, 0.281, 0.019248850104728987, 0.29, 1.725796885585521, 0.29, 0.019248850104728987, 0.29, 1.725796885585521, 0.29, 0.004576303233752355, 0.276, 1.7771056092216693, 0.27, 0.003511243776325945, 0.29, 1.77965883854776, 0.276, -0.0339090744748799, 0.282, 1.865953262522047, 0.29],
    ['it', 'uk', 0.024806530335846233, 0.182, 1.5038610416666787, 0.182, 0.013261037885531679, 0.216, 1.5471453828975874, 0.271, 0.003407807728565415, 0.355, 1.5607639567613716, 0.355, 0.010100647982905109, 0.182, 1.5553316299019726, 0.182, 0.002121660335678177, 0.214, 1.5720843856418183, 0.21, -0.04111265739400838, 0.199, 1.6631818360892432, 0.182],
    ['pt', 'ru', 0.012960705336941158, 0.403, 1.6862967101880024, 0.404, 0.012858454305476275, 0.403, 1.6871809471602495, 0.412, 0.012858454305476275, 0.403, 1.6871809471602495, 0.412, -0.0017451770160001878, 0.413, 1.7377672984232966, 0.413, -0.0029437559501064303, 0.413, 1.7406354409300506, 0.41, -0.041180495948605844, 0.413, 1.828419031848024, 0.413],
    ['pt', 'sk', 0.015303610266873657, 0.37, 1.719670498457604, 0.358, 0.015281373453953861, 0.352, 1.7197640307795925, 0.352, 0.015281373453953861, 0.352, 1.7197640307795925, 0.352, 0.0005977279139324221, 0.37, 1.7711410866928983, 0.367, -0.00046345256849655847, 0.352, 1.7736908853840903, 0.335, -0.037889199684069896, 0.352, 1.8601116721598152, 0.352],
    ['pt', 'uk', 0.012211104810705753, 0.469, 1.5151302195485483, 0.469, 0.00967980159347559, 0.369, 1.535005897816754, 0.337, 0.00967980159347559, 0.283, 1.535005897816754, 0.272, -0.0024947775422353713, 0.461, 1.5666008077838423, 0.461, -0.005115489876756918, 0.38, 1.572641340213373, 0.383, -0.05094587939854478, 0.387, 1.6709594384103008, 0.393],
    ['ru', 'sk', 0.4187381744423928, 0.001, 1.2700306820710359, 0.001, 0.3717672432937893, 0.001, 1.3598120031555676, 0.001, 0.3657799232253348, 0.001, 1.3775440672804593, 0.001, 0.3966793509129809, 0.001, 1.343560093835742, 0.001, 0.38521217199447255, 0.001, 1.3671631273191802, 0.001, 0.3425523580798313, 0.001, 1.484021763252774, 0.001],
    ['ru', 'uk', 0.26308461416419493, 0.001, 1.3706125128060402, 0.001, 0.22229853922218, 0.001, 1.4645976349495236, 0.001, 0.20486549045099856, 0.001, 1.4941732559298122, 0.001, 0.24102579063478302, 0.001, 1.444141924570746, 0.001, 0.22476421580573502, 0.001, 1.4777054199094148, 0.001, 0.17814796391838017, 0.001, 1.5956492871363532, 0.001],
    ['sk', 'uk', 0.2114920998566182, 0.002, 1.5118571395506604, 0.002, 0.18894739492340962, 0.002, 1.5734063193294077, 0.002, 0.17909416476644335, 0.002, 1.5900258305984467, 0.002, 0.1894332763272064, 0.002, 1.5853865513153662, 0.002, 0.1791595218614217, 0.002, 1.606930859015343, 0.002, 0.1301983294568363, 0.002, 1.728345454262186, 0.002]
]

add = []
for row in data:
    add.append([row[1], row[0]] + row[2:])
data += add
for col in range(3, len(data[0]), 2):
    for i in range(len(data)):
        data[i][col] = data[i][col] < 0.05

res = []
for row in data:
    pos = 0
    for i in range(2, len(data[0]), 4):
        res.append([row[0], row[1], estimators[pos], row[i], row[i + 1], row[i + 2], row[i + 3]])
        pos += 1

# heads = ['Lang1', 'Lang2']
# for x in estimators:
#     heads.extend([f'{x} (MI)', f'{x} (MI, p)', f'{x} (VI)', f'{x} (VI, p)'])
heads = ['Lang1', 'Lang2', 'Estimator', 'MI', 'MI (p)', 'VI', 'VI (p)']
df = pd.DataFrame(res, columns=heads)

order = ['hr', 'sk', 'uk', 'ru', 'bg', 'fr', 'ca', 'it', 'es', 'pt']

graph = (ggplot(df, aes(x='Lang1', y='Lang2', fill='MI'))
    + geom_tile()
    + facet_wrap('~ Estimator', nrow=1)
    + scale_x_discrete(limits=order)
    + scale_y_discrete(limits=order)
    + labs(title='Mutual information of gender partitions')
    + theme(legend_key_width=2, legend_key_height=10, axis_text_x=element_text(rotation=90, hjust=0.5)))
graph.draw()
graph.save('figures/mccarthy.pdf', width=8, height=1.3)
plt.show()
