/*
 * Decompiled with CFR 0.152.
 */
package ter;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.w3c.dom.Document;
import ter.Parameters;
import ter.core.Alignment;
import ter.core.CostFunction;
import ter.core.TerScorer;
import ter.io.SgmlProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TER {
    private static int tot_ins = 0;
    private static int tot_del = 0;
    private static int tot_sub = 0;
    private static int tot_sft = 0;
    private static int tot_wsf = 0;
    private static float tot_err = 0.0f;
    private static float tot_wds = 0.0f;
    private static String refspan_ext = ".ref";
    private static String hypspan_ext = ".hyp";
    private static boolean has_span = false;

    public static void main(String[] args) {
        int in_ref_format;
        Map<String, List<String>> refsegs;
        int in_hyp_format;
        Map<String, List<String>> hypsegs;
        Parameters para = new Parameters();
        HashMap<Parameters.OPTIONS, Object> paras = para.getOpts(args);
        String ref_fn = (String)paras.get((Object)Parameters.OPTIONS.REF);
        String hyp_fn = (String)paras.get((Object)Parameters.OPTIONS.HYP);
        Object val = paras.get((Object)Parameters.OPTIONS.NORMALIZE);
        boolean normalized = (Boolean)val;
        val = paras.get((Object)Parameters.OPTIONS.CASEON);
        boolean caseon = (Boolean)val;
        val = paras.get((Object)Parameters.OPTIONS.NOPUNCTUATION);
        boolean nopunct = (Boolean)val;
        val = paras.get((Object)Parameters.OPTIONS.OUTPFX);
        String out_pfx = val != null ? (String)val : "";
        val = paras.get((Object)Parameters.OPTIONS.FORMATS);
        ArrayList<String> formats = new ArrayList();
        if (val != null) {
            formats = (List)val;
        }
        val = paras.get((Object)Parameters.OPTIONS.BEAMWIDTH);
        int beam_width = (Integer)val;
        val = paras.get((Object)Parameters.OPTIONS.REFLEN);
        String reflen_fn = (String)val;
        val = paras.get((Object)Parameters.OPTIONS.TRANSSPAN);
        String span_pfx = (String)val;
        val = paras.get((Object)Parameters.OPTIONS.SHIFTDIST);
        int shift_dist = (Integer)val;
        CostFunction costfunc = new CostFunction();
        costfunc._delete_cost = (Double)paras.get((Object)Parameters.OPTIONS.DELETE_COST);
        costfunc._insert_cost = (Double)paras.get((Object)Parameters.OPTIONS.INSERT_COST);
        costfunc._shift_cost = (Double)paras.get((Object)Parameters.OPTIONS.SHIFT_COST);
        costfunc._match_cost = (Double)paras.get((Object)Parameters.OPTIONS.MATCH_COST);
        costfunc._substitute_cost = (Double)paras.get((Object)Parameters.OPTIONS.SUBSTITUTE_COST);
        double TOTAL_EDITS = 0.0;
        double TOTAL_WORDS = 0.0;
        Map<String, List<String>> reflensegs = null;
        HashMap<String, List<String>> refsids = null;
        HashMap<String, List<String>> reflenids = null;
        HashMap<String, String> refspans = null;
        HashMap<String, String> hypspans = null;
        SgmlProcessor hypsgm = new SgmlProcessor();
        SgmlProcessor refsgm = new SgmlProcessor();
        SgmlProcessor reflensgm = null;
        Document hypdoc = hypsgm.parse(hyp_fn);
        Document refdoc = refsgm.parse(ref_fn);
        Document reflendoc = null;
        if (hypdoc == null) {
            hypsegs = TER.load_segs(hyp_fn);
            System.out.println("\"" + hyp_fn + "\" was successfully parsed as Trans text");
            in_hyp_format = 1;
        } else {
            hypsegs = new LinkedHashMap<String, List<String>>();
            hypsgm.loadSegs(hypdoc, hypsegs);
            in_hyp_format = 2;
        }
        if (refdoc == null) {
            refsegs = TER.load_segs(ref_fn);
            System.out.println("\"" + ref_fn + "\" was successfully parsed as Trans text");
            in_ref_format = 1;
        } else {
            refsegs = new LinkedHashMap<String, List<String>>();
            refsids = new HashMap<String, List<String>>();
            refsgm.loadSegs(refdoc, refsegs, refsids);
            in_ref_format = 2;
        }
        if (reflen_fn != "") {
            reflensgm = new SgmlProcessor();
            reflendoc = reflensgm.parse(reflen_fn);
            if (reflendoc == null) {
                reflensegs = TER.load_segs(reflen_fn);
                System.out.println("\"" + reflen_fn + "\" was successfully parsed as Trans text");
            } else {
                reflensegs = new LinkedHashMap<String, List<String>>();
                reflenids = new HashMap<String, List<String>>();
                refsgm.loadSegs(reflendoc, reflensegs, reflenids);
            }
        }
        if (span_pfx != "") {
            has_span = true;
            refspans = TER.load_trans_span(span_pfx + refspan_ext);
            hypspans = TER.load_trans_span(span_pfx + hypspan_ext);
        }
        if (!TER.verifyFormats(in_ref_format, in_hyp_format, formats)) {
            System.exit(1);
        }
        TerScorer calc = new TerScorer();
        calc.setNormalize(normalized);
        calc.setCase(caseon);
        calc.setPunct(nopunct);
        calc.setBeamWidth(beam_width);
        calc.setShiftDist(shift_dist);
        BufferedWriter xml_out = TER.openFile(formats, "xml", out_pfx, hyp_fn, ref_fn, reflen_fn, caseon, hypsgm);
        BufferedWriter pra_out = TER.openFile(formats, "pra", out_pfx, hyp_fn, ref_fn, reflen_fn, caseon, hypsgm);
        BufferedWriter prm_out = TER.openFile(formats, "pra_more", out_pfx, hyp_fn, ref_fn, reflen_fn, caseon, hypsgm);
        BufferedWriter ter_out = TER.openFile(formats, "ter", out_pfx, hyp_fn, ref_fn, reflen_fn, caseon, hypsgm);
        BufferedWriter sum_out = TER.openFile(formats, "sum", out_pfx, hyp_fn, ref_fn, reflen_fn, caseon, hypsgm);
        BufferedWriter nbt_out = TER.openFile(formats, "sum_nbest", out_pfx, hyp_fn, ref_fn, reflen_fn, caseon, hypsgm);
        Pattern id_rank = Pattern.compile("^\\s*(.*):([^ ]*)\\s*$", 2);
        Iterator<String> hypids = hypsegs.keySet().iterator();
        while (hypids.hasNext()) {
            Matcher id_rank_m;
            String id_nrank = "";
            String rank = "";
            String id = hypids.next();
            List<String> hyps = hypsegs.get(id);
            String hypspan = "";
            if (has_span) {
                hypspan = (String)hypspans.get(id);
            }
            if ((id_rank_m = id_rank.matcher(id)).matches()) {
                id_nrank = id_rank_m.group(1);
                rank = id_rank_m.group(2);
            } else {
                id_nrank = id;
                id = id + ":1";
            }
            if (refsegs.containsKey(id_nrank)) {
                System.out.println("Processing " + id);
                List refids = refsids != null && refsids.containsKey(id_nrank) ? (List)refsids.get(id_nrank) : new ArrayList(1);
                List<String> reflenseglist = null;
                if (reflensegs != null && (reflenseglist = reflensegs.get(id_nrank)) == null) {
                    System.out.println("Warning: NO reference length can be found for hyp: " + refids);
                }
                String refspan = "";
                if (has_span) {
                    refspan = (String)refspans.get(id_nrank);
                }
                Alignment result = TER.score_all_refs(hyps.get(0), refsegs.get(id_nrank), reflenseglist, refids, refspan, hypspan, costfunc, calc);
                TOTAL_EDITS += result.numEdits;
                TOTAL_WORDS += result.numWords;
                try {
                    if (ter_out != null) {
                        ter_out.write(id + " " + result.numEdits + " " + result.numWords + " " + result.score() + "\n");
                    }
                    if (xml_out != null) {
                        hypsgm.writeXMLAlignment(xml_out, result, id, in_ref_format == 1);
                    }
                    if (pra_out != null) {
                        pra_out.write("Sentence ID: " + id + "\n" + result.toString() + "\n\n");
                    }
                    if (prm_out != null) {
                        prm_out.write("Sentence ID: " + id + "\n" + result.toMoreString() + "\n\n");
                    }
                    if (sum_out != null) {
                        TER.writeSummary(sum_out, result, id);
                    }
                    if (nbt_out == null) continue;
                    TER.writeNbestSum(nbt_out, result, id);
                    continue;
                }
                catch (IOException ioe) {
                    System.out.println(ioe);
                    return;
                }
            }
            System.out.println("***ERROR*** No reference for segment " + id_nrank);
            System.exit(1);
        }
        TER.closeFile(xml_out, "xml", hypsgm);
        TER.closeFile(pra_out, "pra", hypsgm);
        TER.closeFile(prm_out, "pra_more", hypsgm);
        TER.closeFile(ter_out, "ter", hypsgm);
        TER.closeFile(sum_out, "sum", hypsgm);
        TER.closeFile(nbt_out, "sum_nbest", hypsgm);
        System.out.println("Total TER: " + TOTAL_EDITS / TOTAL_WORDS + " (" + TOTAL_EDITS + "/" + TOTAL_WORDS + ")");
        System.out.println("Number of calls to beam search: " + calc.numBeamCalls());
        System.out.println("Number of segments scored: " + calc.numSegsScored());
        System.out.println("Number of shifts tried: " + calc.numShiftsTried());
    }

    public static BufferedWriter openFile(List<String> formats, String type, String out_pfx, String hyp_fn, String ref_fn, String reflen_fn, boolean caseon, SgmlProcessor sgml) {
        BufferedWriter bw = null;
        if (out_pfx != "" && formats != null && formats.contains(type)) {
            try {
                bw = new BufferedWriter(new FileWriter(out_pfx + "." + type));
                if (type.equals("xml")) {
                    sgml.writeXMLHeader(bw, hyp_fn, ref_fn, caseon);
                } else if (type.equals("sum")) {
                    bw.write("Hypothesis File: " + hyp_fn + "\nReference File: " + ref_fn + "\n" + "Ave-Reference File: " + (reflen_fn == "" ? ref_fn : reflen_fn) + "\n");
                    bw.write(String.format("%1$-19s | %2$-4s | %3$-4s | %4$-4s | %5$-4s | %6$-4s | %7$-6s | %8$-8s | %9$-8s\n", "Sent Id", "Ins", "Del", "Sub", "Shft", "WdSh", "NumEr", "NumWd", "TER"));
                    bw.write("-------------------------------------------------------------------------------------\n");
                } else if (type.equals("ter")) {
                    bw.write("Hypothesis File: " + hyp_fn + "\nReference File: " + ref_fn + "\n");
                }
            }
            catch (IOException ioe) {
                System.out.println(ioe);
            }
        }
        return bw;
    }

    public static void closeFile(BufferedWriter bw, String type, SgmlProcessor sgml) {
        if (bw != null) {
            try {
                if (type.equals("xml")) {
                    sgml.writeXMLFooter(bw);
                } else if (type.equals("sum")) {
                    bw.write("-------------------------------------------------------------------------------------\n");
                    bw.write(String.format("%1$-19s | %2$-4d | %3$-4d | %4$-4d | %5$-4d | %6$-4d | %7$-6.1f | %8$-8.3f | %9$-8.3f\n", "TOTAL", tot_ins, tot_del, tot_sub, tot_sft, tot_wsf, Float.valueOf(tot_err), Float.valueOf(tot_wds), (double)tot_err * 100.0 / (double)tot_wds));
                }
                bw.close();
            }
            catch (IOException ioe) {
                System.out.println(ioe);
                return;
            }
        }
    }

    public static void writeSummary(BufferedWriter sum, Alignment result, String id) {
        try {
            result.populateScoreDetails();
            sum.write(String.format("%1$-19s | %2$4d | %3$4d | %4$4d | %5$4d | %6$4d | %7$6.1f | %8$8.3f | %9$8.3f\n", id, result.numIns, result.numDel, result.numSub, result.numSft, result.numWsf, result.numEdits, result.numWords, result.score() * 100.0));
            tot_ins += result.numIns;
            tot_del += result.numDel;
            tot_sub += result.numSub;
            tot_sft += result.numSft;
            tot_wsf += result.numWsf;
            tot_err = (float)((double)tot_err + result.numEdits);
            tot_wds = (float)((double)tot_wds + result.numWords);
        }
        catch (IOException ioe) {
            System.out.println(ioe);
            return;
        }
    }

    public static void writeNbestSum(BufferedWriter nbt, Alignment result, String id) {
        try {
            result.populateScoreDetails();
            nbt.write(String.format("%1$-19s %2$4d %3$4d %4$4d %5$4d %6$4d %7$6.1f %8$8.3f %9$8.3f\n", id, result.numIns, result.numDel, result.numSub, result.numSft, result.numWsf, result.numEdits, result.numWords, result.score() * 100.0));
        }
        catch (IOException ioe) {
            System.out.println(ioe);
            return;
        }
    }

    public static boolean verifyFormats(int in_ref_format, int in_hyp_format, List<String> out_formats) {
        if (in_ref_format != in_hyp_format) {
            System.out.println("** Error: Both hypothesis and reference have to be in the SAME format");
            return false;
        }
        if (in_ref_format == 1 && out_formats.indexOf("xml") > -1) {
            System.out.println("** Warning: XML ouput may not have correct doc id for Trans format inputs");
            return true;
        }
        return true;
    }

    public static Alignment score_all_refs(String hyp, List<String> refs, List<String> reflens, List<String> refids, String refspan, String hypspan, CostFunction costfunc, TerScorer calc) {
        double totwords = 0.0;
        String refid = "";
        String bestref = "";
        String reflen = "";
        Alignment bestresult = null;
        if (has_span && refs.size() > 1) {
            System.out.println("Error, translation spans should only be used with SINGLE reference");
            System.exit(1);
        }
        calc.setRefLen(reflens);
        for (int i = 0; i < refs.size(); ++i) {
            String ref = refs.get(i);
            if (!refids.isEmpty()) {
                refid = refids.get(i);
            }
            if (has_span) {
                calc.setRefSpan(refspan);
                calc.setHypSpan(hypspan);
            }
            Alignment result = calc.TER(hyp, ref, costfunc);
            if (bestresult == null || bestresult.numEdits > result.numEdits) {
                bestresult = result;
                if (!refids.isEmpty()) {
                    bestref = refid;
                }
            }
            totwords += result.numWords;
        }
        bestresult.numWords = totwords / (double)refs.size();
        if (!refids.isEmpty()) {
            bestresult.bestRef = bestref;
        }
        return bestresult;
    }

    public static Map<String, List<String>> load_segs(String fn) {
        BufferedReader stream;
        Pattern p = Pattern.compile("^\\s*(.*?)\\s*\\(([^()]+)\\)\\s*$");
        LinkedHashMap<String, List<String>> segs = new LinkedHashMap<String, List<String>>();
        try {
            stream = new BufferedReader(new FileReader(fn));
        }
        catch (IOException ioe) {
            System.out.println(ioe);
            return null;
        }
        try {
            String line;
            while ((line = stream.readLine()) != null) {
                if (line.matches("^\\s*$")) continue;
                Matcher m = p.matcher(line);
                if (m.matches()) {
                    ArrayList<String> al;
                    String text = m.group(1);
                    String id = m.group(2);
                    ArrayList<String> val = (ArrayList<String>)segs.get(id);
                    if (val == null) {
                        al = new ArrayList<String>(6);
                        segs.put(id, al);
                    } else {
                        al = val;
                    }
                    al.add(text.trim());
                    continue;
                }
                System.out.println("Warning, Invalid line: " + line);
            }
        }
        catch (IOException ioe) {
            System.out.println(ioe);
            return null;
        }
        return segs;
    }

    private static HashMap<String, String> load_trans_span(String fn) {
        Pattern p = Pattern.compile("^\\s*(.*?)\\s*\\(([^()]+)\\)\\s*$");
        HashMap<String, String> spans = new HashMap<String, String>();
        try {
            String line;
            BufferedReader stream = new BufferedReader(new FileReader(fn));
            while ((line = stream.readLine()) != null) {
                if (line.matches("^\\s*$")) continue;
                Matcher m = p.matcher(line);
                if (m.matches()) {
                    String text = m.group(1);
                    String id = m.group(2);
                    String val = spans.get(id);
                    if (val == null) {
                        spans.put(id, text);
                        continue;
                    }
                    System.out.println("Error, translation spans should only be used with SINGLE reference");
                    System.exit(1);
                    continue;
                }
                System.out.println("Warning, Invalid line: " + line);
            }
        }
        catch (IOException ioe) {
            System.out.println(ioe);
            return null;
        }
        return spans;
    }
}

