export SEED=49
export SAVE_STEPS=500
export EVAL_STEPS=200
export BATCH_SIZE=32
export LR=0.0001
export ENCODER_TYPE=BERT

for DATASET in "dial_sentiment" "dial_mention"  'pan_age' 'pan_gender'; do
  for CHECKPOINTS in "checkpoint-5000" "checkpoint-10000"; do
    for MUL in 0.001 0.01 0.1 1 10; do


      for MI in "ADV" "MIReny"; do
        export PATH_MODEL=nclassif_${DATASET}_${FBLOCK}_${MI}_${MUL}_${ENCODER_TYPE}
        export OUTPUT_DIR=results_${DATASET}_${FBLOCK}_${MI}_${MUL}_${ENCODER_TYPE}-${CHECKPOINTS}
        echo $OUTPUT_DIR
        sbatch --job-name=${OUTPUT_DIR} \
          --gres=gpu:1 \
          --no-requeue \
          --cpus-per-task=3 \
          --hint=nomultithread \
          --time=1:00:00 \
          --output=jobinfo/${OUTPUT_DIR}_%j.out \
          --error=jobinfo/${OUTPUT_DIR}_%j.err \
          --qos=qos_gpu-t4 \
          --wrap="module purge; module load pytorch-gpu/py3/1.7.0 ;   python3 test_fair_classif.py  --fairness_only --path=$PATH_MODEL --checkpoints=$CHECKPOINTS --output_dir=$OUTPUT_DIR --batch_size=32 --filter=1 --save_step=$SAVE_STEPS --eval_step=$EVAL_STEPS --max_number_of_steps=25000"

      done

      export FBLOCK="MULTI"
      for MULTIVARIATE_LOSS in "SINKHORN" "ENERGY" "RAO" "ENERGY" "FRECHET" "JS"; do
        export PATH_MODEL=nclassif_${DATASET}_${FBLOCK}_${MULTIVARIATE_LOSS}_${MUL}_${ENCODER_TYPE}_0.000001
        export OUTPUT_DIR=results_${DATASET}_${FBLOCK}_${MULTIVARIATE_LOSS}_${MUL}_${ENCODER_TYPE}_0.000001-${CHECKPOINTS}
        echo $OUTPUT_DIR
        sbatch --job-name=${OUTPUT_DIR} \
          --gres=gpu:1 \
          --no-requeue \
          --cpus-per-task=3 \
          --hint=nomultithread \
          --time=1:00:00 \
          --output=jobinfo/${OUTPUT_DIR}_%j.out \
          --error=jobinfo/${OUTPUT_DIR}_%j.err \
          --qos=qos_gpu-t4 \
          --wrap="module purge; module load pytorch-gpu/py3/1.7.0 ;   python3 test_fair_classif.py  --fairness_only --path=$PATH_MODEL --checkpoints=$CHECKPOINTS --output_dir=$OUTPUT_DIR --batch_size=32 --filter=1 --save_step=$SAVE_STEPS --eval_step=$EVAL_STEPS --max_number_of_steps=25000"

      done

    done

  done

done

export ENCODER_TYPE=BERT
export BATCH_SIZE=200
for DATASET in "dial_sentiment" "dial_mention"  'pan_age' 'pan_gender'; do
  for DATASET in 'dial_sentiment' 'blog_age' 'blog_gender' 'dial_sentiment' 'trust_age' 'trust_gender' 'blog_age' 'blog_gender'; do
    for CHECKPOINTS in "checkpoint-4000" "checkpoint-6000" "checkpoint-8000" "checkpoint-10000" "checkpoint-12000"; do

      for MUL in 0.001 0.01 0.1 1 10; do
               export FBLOCK="MI"
          for MI in "ADV" "MIReny"; do
            export PATH_MODEL=${pretrained_model}${BATCH_SIZE}nclassif_${DATASET}_${FBLOCK}_${MI}_${MUL}_${ENCODER_TYPE}_verynew
            export OUTPUT_DIR=${pretrained_model}${BATCH_SIZE}nclassif_${DATASET}_${FBLOCK}_${MI}_${MUL}_${ENCODER_TYPE}-${CHECKPOINTS}_verynew
            echo $OUTPUT_DIR
            sbatch --job-name=${OUTPUT_DIR} \
              --gres=gpu:1 \
              --no-requeue \
              --cpus-per-task=3 \
              --hint=nomultithread \
              --time=1:00:00 \
              --output=jobinfo/${OUTPUT_DIR}_%j.out \
              --error=jobinfo/${OUTPUT_DIR}_%j.err \
              --qos=qos_gpu-t4 \
              --wrap="module purge; module load pytorch-gpu/py3/1.7.0 ;   python3 test_fair_classif.py  --fairness_only  --model_type=${pretrained_model} --path=$PATH_MODEL --checkpoints=$CHECKPOINTS --output_dir=$OUTPUT_DIR --batch_size=32 --filter=1 --save_step=$SAVE_STEPS --eval_step=$EVAL_STEPS --max_number_of_steps=25000"

          done

          export FBLOCK="MULTI"
          for MULTIVARIATE_LOSS in "SINKHORN" "ENERGY" "RAO" "ENERGY" "FRECHET" "JS"; do
            export PATH_MODEL=nclassif_${DATASET}_${FBLOCK}_${MULTIVARIATE_LOSS}_${MUL}_${ENCODER_TYPE}_0.000001
            export OUTPUT_DIR=results_${DATASET}_${FBLOCK}_${MULTIVARIATE_LOSS}_${MUL}_${ENCODER_TYPE}_0.000001-${CHECKPOINTS}
            echo $OUTPUT_DIR
            sbatch --job-name=${OUTPUT_DIR} \
              --gres=gpu:1 \
              --no-requeue \
              --cpus-per-task=3 \
              --hint=nomultithread \
              --time=1:00:00 \
              --output=jobinfo/${OUTPUT_DIR}_%j.out \
              --error=jobinfo/${OUTPUT_DIR}_%j.err \
              --qos=qos_gpu-t4 \
              --wrap="module purge; module load pytorch-gpu/py3/1.7.0 ;   python3 test_fair_classif.py  --fairness_only --path=$PATH_MODEL --checkpoints=$CHECKPOINTS --output_dir=$OUTPUT_DIR --batch_size=32 --filter=1 --save_step=$SAVE_STEPS --eval_step=$EVAL_STEPS --max_number_of_steps=25000"

          done

        done

      done
    done
  done

done
