# ==================================   INDEP   ================================== #
from ..data_config import SIZE
DROP_OUT = 0.3
######### Grain grain_num > 1 #########
Indep_Template_Prl_Grain = [
    # (+) =======================================
    [ 
        # STRUCTURE:
            'Tensor_Reducer',    
        # Meanings:
            {
                'InputMeaning':    'GrainVec_SeqAS_Token_SeqAS_Sent',
                'OutputMeaning':   'TokenVec_SeqAS_Sent',
                'Reshape_Restore': 'GrainVec_SeqAs_Token',
            },
        # NNName_NNPara
            [
                # NN Name
                'RNN',
                # NN Para
                {'type': 'lstm', 
                 'n_layers': 1,
                 'input_type': 'INPUT-NML', 'direction_type': 'BI-MIX',  'struct_type': 'REDUCER', 
                 'input_size': SIZE,  'output_size': SIZE, 'rnn_dropout': DROP_OUT,
                 'postprecess' :{
                     'dropout' :[True, {'p':DROP_OUT, 'inplace':False}],
                    # 'activiator': [True, 'relu'],
                     'layernorm': [True, {'eps': 1e-05, "elementwise_affine":True}],
                    }
                }
            ]
    ],
    
    # (+) =======================================
    [ 
        # STRUCTURE:
            'Matrix_Extractor',    
        # Meanings:
            {
                'InputMeaning':  'TokenVec_SeqAS_Sent',
                'OutputMeaning': 'TokenVec_SeqAS_Sent',
                'Reshape_Restore': None,
            },
        # NNName_NNPara
            [
                # NN Name
                'RNN',
                # NN Para
                {'type': 'lstm', 
                 'n_layers': 1,
                 'input_type': 'INPUT-NML', 'direction_type': 'BI-MIX',  'struct_type': 'EXTRACTOR', 
                 'input_size': SIZE,  'output_size': SIZE, 'rnn_dropout': DROP_OUT,
                 'postprecess' :{
                     'dropout' :[True, {'p':DROP_OUT, 'inplace':False}],
                     # 'activiator': [True, 'relu'],
                     'layernorm': [True, {'eps': 1e-05, "elementwise_affine":True}],
                    }
                }
            ]
    ]
]



# ==================================   INTERDEP  ================================== #

Interdep_Template = [
    # (+) DON'T CHANGE THIS PART =======================================
    [ 
        # STRUCTURE:
            'Tensor_Reducer',    
        # Meanings:
            {
                'InputMeaning':    'FieldVec_SeqAS_Token_SeqAS_Sent',
                'OutputMeaning':   'TokenVec_SeqAS_Sent',
                'Reshape_Restore':  None,
            },
        # NNName_NNPara
            [
                # NN Name
                'Sum',
                # NN Para
                {'type': 'sum', 
                 'input_size':  SIZE, 
                 'output_size': SIZE,
                 'postprecess' :{
                     'dropout' :[True, {'p':DROP_OUT, 'inplace':False}],
                     'layernorm': [True, {'eps': 1e-05, "elementwise_affine":True}],
                    }

                }
            ]
    ],
    
    # (+) =======================================
    [ 
        # STRUCTURE:
            'Matrix_Extractor',    
        # Meanings:
            {
                'InputMeaning':  'TokenVec_SeqAS_Sent',
                'OutputMeaning': 'TokenVec_SeqAS_Sent',
                'Reshape_Restore': None,
            },
        # NNName_NNPara
            [
                # NN Name
                'RNN',
                # NN Para
                {'type': 'lstm', 
                 'n_layers': 1,
                 'input_type': 'INPUT-NML', 
                 'direction_type': 'BI-MIX',   # 'FWD', 'BI-SEP'
                 'struct_type': 'EXTRACTOR', 
                 'input_size': SIZE,  'output_size': SIZE, 'rnn_dropout': DROP_OUT,
                 'postprecess' :{
                     'dropout' :[True, {'p':DROP_OUT, 'inplace':False}],
                     # 'activiator': [True, 'relu'],
                     'layernorm': [True, {'eps': 1e-05, "elementwise_affine":True}],
                    }
                }
            ]
    ]
]


