#!/usr/bin/python3
#-*- coding:utf-8 -*-
############################
#File Name: wordgcn.py
#Created Time:
############################
import torch
import torch.nn as nn
from models.wgcn import WGCN, MWGCN
from models.hmcc import HMC,MHMC,SuperCls,Base,LabelAttention, SuperCls2, SuperClsF, SuperClsA, SuperClsF1, SuperClsL, SuperClsFL
from models.new_hmc import n_SuperCls,n_SuperClsF
from models.classifier import MyClassifier

class WordGCN(nn.Module):
    def __init__(self,
                 input_dim,
                 hidden_dim=300,
                 support=None,
                 classes=[8],
                 cls="single",
                 pre=None,
                 dropout=0.0,
                 masks=None):
        super(WordGCN,self).__init__()
        self.wgcn = WGCN(input_dim=input_dim,support=support,dropout_rate=dropout,hidden_dim=hidden_dim,pre=pre,masks=masks)
        num_classes = classes[-1]
        if cls == 'single':
            print("-----single----")
            self.clss = MyClassifier(classes=classes)
        elif cls=="base":
            self.clss = Base(input_dim=hidden_dim,hidden_dim=hidden_dim,classes=classes)
        elif cls=="labelattention":
            self.clss = LabelAttention(input_dim=hidden_dim,hidden_dim=hidden_dim,classes=classes)
        elif cls=='hmc':
            self.clss = HMC(input_dim=hidden_dim,hidden_dim=hidden_dim,classes=classes)
        elif cls=='mhmc':
            print("--------mhmc-----")
            self.clss = MHMC(input_dim=hidden_dim,hidden_dim=hidden_dim,classes=classes)
        elif cls=='supercls':
            self.clss = n_SuperClsF(input_dim=hidden_dim,hidden_dim=hidden_dim,classes=classes)

    def forward(self,tfidf,labels,feature):
        #embeds = self.wgcn()
        print("TO Do")
        #embeds = self.wgcn(feature)

