/*
 * Decompiled with CFR 0.152.
 */
package simplenlg.test.german;

import java.util.ArrayList;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import simplenlg.features.AdjectiveDegree;
import simplenlg.features.Case;
import simplenlg.features.DiscourseFunction;
import simplenlg.features.Form;
import simplenlg.features.Gender;
import simplenlg.features.InterrogativeType;
import simplenlg.features.NumberAgr;
import simplenlg.features.Person;
import simplenlg.features.Position;
import simplenlg.features.Tense;
import simplenlg.lexicon.DBLexicon;
import simplenlg.lexicon.db.XMLAccessor;
import simplenlg.lexicon.lexicalitems.Constants;
import simplenlg.lexicon.lexicalitems.Noun;
import simplenlg.lexicon.lexicalitems.Preposition;
import simplenlg.lexicon.lexicalitems.Pronoun;
import simplenlg.lexicon.lexicalitems.Verb;
import simplenlg.realiser.AdjPhraseSpec;
import simplenlg.realiser.CoordinateNPPhraseSpec;
import simplenlg.realiser.CoordinateSPhraseSpec;
import simplenlg.realiser.NPPhraseSpec;
import simplenlg.realiser.PPPhraseSpec;
import simplenlg.realiser.Phrase;
import simplenlg.realiser.Realiser;
import simplenlg.realiser.RefNPPhraseSpec;
import simplenlg.realiser.SPhraseSpec;
import simplenlg.realiser.comparators.WordOrder;

public class RandomTests {
    static String lexiconFile = "C:\\Users\\Amaroid\\Documents\\lexikon-output.xml";
    static String imslexFile = "C:\\Users\\Amaroid\\Documents\\imslex.xml";
    DBLexicon lex;
    Realiser r;
    Tense[] allTenses;
    Form[] allForms;
    NumberAgr[] allNums;
    Person[] allPersons;
    Case[] allCases;
    Verb sehen;
    Verb geben;
    Pronoun beide;
    AdjPhraseSpec schoen;
    AdjPhraseSpec teuer;
    NPPhraseSpec mann;
    NPPhraseSpec frau;
    NPPhraseSpec kind;
    NPPhraseSpec name;
    NPPhraseSpec buch;
    NPPhraseSpec beamte;
    PPPhraseSpec ubahn;
    SPhraseSpec sentence;
    SPhraseSpec matrix;
    SPhraseSpec sub1;

    @Before
    public void setUp() throws Exception {
        this.lex = new DBLexicon(new XMLAccessor(lexiconFile));
        this.r = new Realiser(this.lex);
        this.allTenses = new Tense[]{Tense.PRESENT, Tense.PAST};
        this.allForms = new Form[]{Form.NORMAL, Form.SUBJUNCTIVE};
        this.allNums = new NumberAgr[]{NumberAgr.SINGULAR, NumberAgr.PLURAL};
        this.allPersons = new Person[]{Person.FIRST, Person.SECOND, Person.THIRD};
        this.allCases = new Case[]{Case.NOMINATIVE, Case.ACCUSATIVE, Case.GENITIVE, Case.DATIVE};
        this.resetAll();
    }

    void resetAll() {
        this.mann = this.lex.makeNP("der", "Mann");
        this.frau = this.lex.makeNP("die", "Frau");
        this.kind = this.lex.makeNP("das", "Kind");
        this.name = this.lex.makeNP("der", "Name");
        this.buch = this.lex.makeNP("ein", "Buch");
        this.ubahn = this.lex.makePP("in", "der", "U-Bahn", Case.DATIVE);
        Noun beamteNoun = new Noun("Beamte", Gender.MASCULINE, "n", "n");
        beamteNoun.setAdjectiveInflection(true);
        this.beamte = new NPPhraseSpec((Object)"der", beamteNoun);
        this.beide = Constants.getPronoun("beide");
        this.sehen = this.lex.getVerb("sehen");
        this.geben = this.lex.getVerb("geben");
        this.schoen = this.lex.makeAdjP("sch\u00f6n");
        this.teuer = this.lex.makeAdjP("teuer");
        this.resetSentence();
        this.resetMatrix();
        this.resetSubordinate();
    }

    void resetSentence() {
        this.sentence = new SPhraseSpec(this.frau, this.geben, this.buch);
        this.sentence.addIndirectObject(this.mann);
        this.sentence.setTense(Tense.PAST);
    }

    void resetMatrix() {
        this.matrix = new SPhraseSpec(this.frau, this.sehen);
    }

    void resetSubordinate() {
        this.sub1 = this.lex.makeS(this.mann, "sein");
        this.sub1.addModifier(this.schoen);
    }

    @Test
    public void testNounDeclension() {
        this.mann.setNumber(NumberAgr.SINGULAR);
        this.mann.setCase(Case.NOMINATIVE);
        Assert.assertEquals((Object)"der Mann", (Object)this.r.realise(this.mann));
        this.mann.setCase(Case.ACCUSATIVE);
        Assert.assertEquals((Object)"den Mann", (Object)this.r.realise(this.mann));
        this.mann.setCase(Case.GENITIVE);
        Assert.assertEquals((Object)"des Mannes", (Object)this.r.realise(this.mann));
        this.mann.setCase(Case.DATIVE);
        Assert.assertEquals((Object)"dem Mann", (Object)this.r.realise(this.mann));
        this.mann.setNumber(NumberAgr.PLURAL);
        this.mann.setCase(Case.NOMINATIVE);
        Assert.assertEquals((Object)"die M\u00e4nner", (Object)this.r.realise(this.mann));
        this.mann.setCase(Case.ACCUSATIVE);
        Assert.assertEquals((Object)"die M\u00e4nner", (Object)this.r.realise(this.mann));
        this.mann.setCase(Case.GENITIVE);
        Assert.assertEquals((Object)"der M\u00e4nner", (Object)this.r.realise(this.mann));
        this.mann.setCase(Case.DATIVE);
        Assert.assertEquals((Object)"den M\u00e4nnern", (Object)this.r.realise(this.mann));
        this.frau.setNumber(NumberAgr.SINGULAR);
        this.frau.setCase(Case.NOMINATIVE);
        Assert.assertEquals((Object)"die Frau", (Object)this.r.realise(this.frau));
        this.frau.setCase(Case.ACCUSATIVE);
        Assert.assertEquals((Object)"die Frau", (Object)this.r.realise(this.frau));
        this.frau.setCase(Case.GENITIVE);
        Assert.assertEquals((Object)"der Frau", (Object)this.r.realise(this.frau));
        this.frau.setCase(Case.DATIVE);
        Assert.assertEquals((Object)"der Frau", (Object)this.r.realise(this.frau));
        this.frau.setNumber(NumberAgr.PLURAL);
        this.frau.setCase(Case.NOMINATIVE);
        Assert.assertEquals((Object)"die Frauen", (Object)this.r.realise(this.frau));
        this.frau.setCase(Case.ACCUSATIVE);
        Assert.assertEquals((Object)"die Frauen", (Object)this.r.realise(this.frau));
        this.frau.setCase(Case.GENITIVE);
        Assert.assertEquals((Object)"der Frauen", (Object)this.r.realise(this.frau));
        this.frau.setCase(Case.DATIVE);
        Assert.assertEquals((Object)"den Frauen", (Object)this.r.realise(this.frau));
        this.kind.setNumber(NumberAgr.SINGULAR);
        this.kind.setCase(Case.NOMINATIVE);
        Assert.assertEquals((Object)"das Kind", (Object)this.r.realise(this.kind));
        this.kind.setCase(Case.ACCUSATIVE);
        Assert.assertEquals((Object)"das Kind", (Object)this.r.realise(this.kind));
        this.kind.setCase(Case.GENITIVE);
        Assert.assertEquals((Object)"des Kindes", (Object)this.r.realise(this.kind));
        this.kind.setCase(Case.DATIVE);
        Assert.assertEquals((Object)"dem Kind", (Object)this.r.realise(this.kind));
        this.kind.setNumber(NumberAgr.PLURAL);
        this.kind.setCase(Case.NOMINATIVE);
        Assert.assertEquals((Object)"die Kinder", (Object)this.r.realise(this.kind));
        this.kind.setCase(Case.ACCUSATIVE);
        Assert.assertEquals((Object)"die Kinder", (Object)this.r.realise(this.kind));
        this.kind.setCase(Case.GENITIVE);
        Assert.assertEquals((Object)"der Kinder", (Object)this.r.realise(this.kind));
        this.kind.setCase(Case.DATIVE);
        Assert.assertEquals((Object)"den Kindern", (Object)this.r.realise(this.kind));
        this.name.setNumber(NumberAgr.SINGULAR);
        this.name.setCase(Case.NOMINATIVE);
        Assert.assertEquals((Object)"der Name", (Object)this.r.realise(this.name));
        this.name.setCase(Case.ACCUSATIVE);
        Assert.assertEquals((Object)"den Namen", (Object)this.r.realise(this.name));
        this.name.setCase(Case.GENITIVE);
        Assert.assertEquals((Object)"des Namens", (Object)this.r.realise(this.name));
        this.name.setCase(Case.DATIVE);
        Assert.assertEquals((Object)"dem Namen", (Object)this.r.realise(this.name));
        this.name.setNumber(NumberAgr.PLURAL);
        this.name.setCase(Case.NOMINATIVE);
        Assert.assertEquals((Object)"die Namen", (Object)this.r.realise(this.name));
        this.name.setCase(Case.ACCUSATIVE);
        Assert.assertEquals((Object)"die Namen", (Object)this.r.realise(this.name));
        this.name.setCase(Case.GENITIVE);
        Assert.assertEquals((Object)"der Namen", (Object)this.r.realise(this.name));
        this.name.setCase(Case.DATIVE);
        Assert.assertEquals((Object)"den Namen", (Object)this.r.realise(this.name));
    }

    @Test
    public void testNounDeclension2() {
        this.resetAll();
        this.beamte.setNumber(NumberAgr.SINGULAR);
        this.beamte.setCase(Case.NOMINATIVE);
        Assert.assertEquals((Object)"der Beamte", (Object)this.r.realise(this.beamte));
        this.beamte.setCase(Case.ACCUSATIVE);
        Assert.assertEquals((Object)"den Beamten", (Object)this.r.realise(this.beamte));
        this.beamte.setCase(Case.GENITIVE);
        Assert.assertEquals((Object)"des Beamten", (Object)this.r.realise(this.beamte));
        this.beamte.setCase(Case.DATIVE);
        Assert.assertEquals((Object)"dem Beamten", (Object)this.r.realise(this.beamte));
        this.beamte.setNumber(NumberAgr.PLURAL);
        this.beamte.setCase(Case.NOMINATIVE);
        Assert.assertEquals((Object)"die Beamten", (Object)this.r.realise(this.beamte));
        this.beamte.setCase(Case.ACCUSATIVE);
        Assert.assertEquals((Object)"die Beamten", (Object)this.r.realise(this.beamte));
        this.beamte.setCase(Case.GENITIVE);
        Assert.assertEquals((Object)"der Beamten", (Object)this.r.realise(this.beamte));
        this.beamte.setCase(Case.DATIVE);
        Assert.assertEquals((Object)"den Beamten", (Object)this.r.realise(this.beamte));
        this.beamte.setNumber(NumberAgr.SINGULAR);
        this.beamte.setSpecifier(Constants.getDeterminer(false));
        this.beamte.setCase(Case.NOMINATIVE);
        Assert.assertEquals((Object)"ein Beamter", (Object)this.r.realise(this.beamte));
        this.beamte.setCase(Case.ACCUSATIVE);
        Assert.assertEquals((Object)"einen Beamten", (Object)this.r.realise(this.beamte));
        this.beamte.setCase(Case.GENITIVE);
        Assert.assertEquals((Object)"eines Beamten", (Object)this.r.realise(this.beamte));
        this.beamte.setCase(Case.DATIVE);
        Assert.assertEquals((Object)"einem Beamten", (Object)this.r.realise(this.beamte));
        this.beamte.setGender(Gender.FEMININE);
        this.beamte.setCase(Case.NOMINATIVE);
        Assert.assertEquals((Object)"eine Beamte", (Object)this.r.realise(this.beamte));
        this.beamte.setCase(Case.ACCUSATIVE);
        Assert.assertEquals((Object)"eine Beamte", (Object)this.r.realise(this.beamte));
        this.beamte.setCase(Case.GENITIVE);
        Assert.assertEquals((Object)"einer Beamten", (Object)this.r.realise(this.beamte));
        this.beamte.setCase(Case.DATIVE);
        Assert.assertEquals((Object)"einer Beamten", (Object)this.r.realise(this.beamte));
    }

    @Test
    public void testVerbConjugation() {
        Object[] expectedForms = new String[]{"sehe", "siehst", "sieht", "sehen", "seht", "sehen", "sah", "sahst", "sah", "sahen", "saht", "sahen", "sehe", "sehest", "sehe", "sehen", "sehet", "sehen", "s\u00e4he", "s\u00e4hest", "s\u00e4he", "s\u00e4hen", "s\u00e4het", "s\u00e4hen", "sieh", "seht", "sehen Sie", "sehen", "sehend", "gesehen"};
        ArrayList<String> actualForms = new ArrayList<String>();
        for (Form f : this.allForms) {
            for (Tense t : this.allTenses) {
                for (NumberAgr n : this.allNums) {
                    for (Person p : this.allPersons) {
                        actualForms.add(this.sehen.getForm(p, n, t, f));
                    }
                }
            }
        }
        actualForms.add(this.sehen.getImperativeForm(NumberAgr.SINGULAR));
        actualForms.add(this.sehen.getImperativeForm(NumberAgr.PLURAL));
        actualForms.add(this.sehen.getHonorificImperativeForm());
        actualForms.add(this.sehen.getInfinitive());
        actualForms.add(this.sehen.getPresentParticiple());
        actualForms.add(this.sehen.getPerfectParticiple());
        Assert.assertArrayEquals((Object[])expectedForms, (Object[])actualForms.toArray());
        Verb rasen = new Verb("rasen");
        expectedForms = new String[]{"rase", "rast", "rast", "rasen", "rast", "rasen", "raste", "rastest", "raste", "rasten", "rastet", "rasten", "rase", "rasest", "rase", "rasen", "raset", "rasen", "raste", "rastest", "raste", "rasten", "rastet", "rasten", "rase", "rast", "rasen Sie", "rasen", "rasend", "gerast"};
        actualForms = new ArrayList();
        for (Form f : this.allForms) {
            for (Tense t : this.allTenses) {
                for (NumberAgr n : this.allNums) {
                    for (Person p : this.allPersons) {
                        actualForms.add(rasen.getForm(p, n, t, f));
                    }
                }
            }
        }
        actualForms.add(rasen.getImperativeForm(NumberAgr.SINGULAR));
        actualForms.add(rasen.getImperativeForm(NumberAgr.PLURAL));
        actualForms.add(rasen.getHonorificImperativeForm());
        actualForms.add(rasen.getInfinitive());
        actualForms.add(rasen.getPresentParticiple());
        actualForms.add(rasen.getPerfectParticiple());
        Assert.assertArrayEquals((Object[])expectedForms, (Object[])actualForms.toArray());
    }

    @Test
    public void testBasicSentenceBuilding() {
        this.resetAll();
        this.sentence = this.lex.makeS(this.frau, this.sehen);
        Assert.assertEquals((String)"Basic: Intransitive sentence", (Object)"Die Frau sieht.", (Object)this.r.realise(this.sentence));
        this.resetAll();
        this.sentence = this.lex.makeS(this.frau, this.sehen, this.mann);
        Assert.assertEquals((String)"Basic: Transitive sentence", (Object)"Die Frau sieht den Mann.", (Object)this.r.realise(this.sentence));
        this.resetAll();
        this.sentence = this.lex.makeS(this.frau, this.geben, this.buch);
        this.sentence.addIndirectObject(this.mann);
        Assert.assertEquals((String)"Basic: Ditransitive sentence", (Object)"Die Frau gibt dem Mann ein Buch.", (Object)this.r.realise(this.sentence));
        this.resetAll();
        Verb gedenken = new Verb("gedenken");
        this.sentence = this.lex.makeS(this.frau, gedenken);
        this.sentence.addComplement(DiscourseFunction.GENITIVE_OBJECT, this.mann);
        Assert.assertEquals((String)"Basic: Genitive object", (Object)"Die Frau gedenkt des Mannes.", (Object)this.r.realise(this.sentence));
    }

    @Test
    public void testRefNP() {
        this.resetAll();
        RefNPPhraseSpec ref = new RefNPPhraseSpec(this.beamte, Constants.PRO_DEM_JENER);
        this.sentence = this.lex.makeS(this.frau, this.geben, this.buch);
        this.sentence.addIndirectObject(ref);
        Assert.assertEquals((String)"RefNP: basic reference (masc. sg.)", (Object)"Die Frau gibt jenem ein Buch.", (Object)this.r.realise(this.sentence));
        this.beamte.setPlural(true);
        Assert.assertEquals((String)"RefNP: reference changed to plural", (Object)"Die Frau gibt jenen ein Buch.", (Object)this.r.realise(this.sentence));
        this.beamte.setPlural(false);
        this.beamte.setGender(Gender.FEMININE);
        Assert.assertEquals((String)"RefNP: reference changed to feminine", (Object)"Die Frau gibt jener ein Buch.", (Object)this.r.realise(this.sentence));
        this.resetAll();
        ref = new RefNPPhraseSpec(this.kind, Constants.PRO_DEM_DERSELBE);
        this.matrix.addComplement(ref);
        Assert.assertEquals((String)"RefNP: basic reference", (Object)"Die Frau sieht dasselbe.", (Object)this.r.realise(this.matrix));
        this.resetAll();
        ref = new RefNPPhraseSpec(this.buch, Constants.PRO_DEM_DERSELBE);
        this.matrix.addModifier(this.lex.makePP("in", ref, Case.ACCUSATIVE));
        Assert.assertEquals((String)"RefNP: reference within a PP", (Object)"Die Frau sieht in dasselbe.", (Object)this.r.realise(this.matrix));
    }

    @Test
    public void testNPGenitiveComplements() {
        this.resetAll();
        this.frau.addComplement(this.mann);
        Assert.assertEquals((String)"NP: genitive complement", (Object)"die Frau des Mannes", (Object)this.r.realise(this.frau));
        this.resetAll();
        this.frau.setSpecifier(this.mann);
        Assert.assertEquals((String)"NP: genitive complement", (Object)"des Mannes Frau", (Object)this.r.realise(this.frau));
        this.resetAll();
        NPPhraseSpec peter = new NPPhraseSpec("Peter");
        this.buch.setSpecifier(peter);
        this.buch.addComplement(this.mann);
        Assert.assertEquals((String)"NP: genitive complement", (Object)"Peters Buch des Mannes", (Object)this.r.realise(this.buch));
    }

    @Test
    public void testNPRelativeClauses() {
        this.resetAll();
        this.sentence = this.lex.makeS(this.geben);
        this.sentence.addIndirectObject(this.mann);
        this.sentence.addComplement(this.buch);
        this.frau.addRelativeClause(this.sentence, DiscourseFunction.SUBJECT);
        Assert.assertEquals((String)"NP: relative clause as subject", (Object)"die Frau, die dem Mann ein Buch gibt, ", (Object)this.r.realise(this.frau));
        this.resetAll();
        this.sentence = this.lex.makeS(this.frau, this.geben, this.buch);
        this.mann.addRelativeClause(this.sentence, DiscourseFunction.INDIRECT_OBJECT);
        Assert.assertEquals((String)"NP: relative clause as indir. object", (Object)"der Mann, dem die Frau ein Buch gibt, ", (Object)this.r.realise(this.mann));
        this.resetAll();
        this.sentence = this.lex.makeS(this.frau, this.geben, this.buch);
        this.mann.setPlural(true);
        this.mann.addRelativeClause(this.sentence, DiscourseFunction.INDIRECT_OBJECT);
        Assert.assertEquals((String)"NP: relative clause as indir. object w/ plural", (Object)"die M\u00e4nner, denen die Frau ein Buch gibt, ", (Object)this.r.realise(this.mann));
        this.resetAll();
        this.sentence = this.lex.makeS(this.frau, this.geben);
        this.sentence.addIndirectObject(this.mann);
        this.buch.addRelativeClause(this.sentence, DiscourseFunction.OBJECT);
        Assert.assertEquals((String)"NP: relative clause as object", (Object)"ein Buch, das die Frau dem Mann gibt, ", (Object)this.r.realise(this.buch));
        this.resetAll();
        this.sentence = this.lex.makeS(this.frau, this.geben);
        this.sentence.addIndirectObject(this.mann);
        this.buch.addRelativeClause(this.sentence, DiscourseFunction.OBJECT);
        this.buch.setPlural(true);
        Assert.assertEquals((String)"NP: relative clause as object w/ plural", (Object)"einige B\u00fccher, die die Frau dem Mann gibt, ", (Object)this.r.realise(this.buch));
        this.resetAll();
        this.buch.addRelativeClause(this.matrix, new Preposition("in", Case.ACCUSATIVE));
        Assert.assertEquals((String)"NP: relative clause as prep. object", (Object)"ein Buch, in das die Frau sieht, ", (Object)this.r.realise(this.buch));
        this.resetAll();
        this.buch.addRelativeClause(this.matrix, new Preposition("in", Case.ACCUSATIVE));
        this.buch.setPlural(true);
        Assert.assertEquals((String)"NP: relative clause as prep. object w/ plural", (Object)"einige B\u00fccher, in die die Frau sieht, ", (Object)this.r.realise(this.buch));
        this.resetAll();
        this.buch.addRelativeClause(this.matrix, new Preposition("in", Case.ACCUSATIVE), Constants.PRO_WELCHER);
        Assert.assertEquals((String)"NP: relative clause as prep. object, w/ welcher", (Object)"ein Buch, in welches die Frau sieht, ", (Object)this.r.realise(this.buch));
        this.resetAll();
        this.frau.addAttributiveRelativeClause(this.sub1, this.kind);
        Assert.assertEquals((String)"NP: relative clause as genitive object", (Object)"die Frau, deren Kind sch\u00f6n ist, ", (Object)this.r.realise(this.frau));
        this.resetAll();
        Verb gedenken = new Verb("gedenken");
        this.sentence = this.lex.makeS(this.frau, gedenken);
        this.mann.addRelativeClause(this.sentence, DiscourseFunction.GENITIVE_OBJECT);
        Assert.assertEquals((String)"NP: relative clause as genitive object", (Object)"der Mann, dessen die Frau gedenkt, ", (Object)this.r.realise(this.mann));
        this.resetAll();
        this.mann.addRelativeClause(this.sentence, DiscourseFunction.INDIRECT_OBJECT);
        Assert.assertEquals((String)"NP: relative clause in a sentence", (Object)"Der Mann, dem die Frau ein Buch gab, ist sch\u00f6n.", (Object)this.r.realise(this.sub1));
        this.resetAll();
        this.sentence.setComplementiser((NPPhraseSpec)new RefNPPhraseSpec(this.mann, Constants.PRO_REL), DiscourseFunction.INDIRECT_OBJECT);
        this.sub1.addAttributivePostmodifier(this.sentence);
        Assert.assertEquals((String)"NP: extraposed relative clause", (Object)"Der Mann ist sch\u00f6n, dem die Frau ein Buch gab.", (Object)this.r.realise(this.sub1));
        this.mann.setPlural(true);
        Assert.assertEquals((String)"NP: extraposed relative clause w/ plural", (Object)"Die M\u00e4nner sind sch\u00f6n, denen die Frau ein Buch gab.", (Object)this.r.realise(this.sub1));
    }

    @Test
    public void testNPReusing() {
        this.resetAll();
        SPhraseSpec s1 = new SPhraseSpec(this.mann, this.sehen);
        SPhraseSpec s2 = new SPhraseSpec(this.frau, this.sehen, this.mann);
        SPhraseSpec s3 = new SPhraseSpec(this.frau, this.geben, this.buch);
        s3.addIndirectObject(this.mann);
        SPhraseSpec s4 = new SPhraseSpec(this.frau, this.sehen);
        s4.addModifier(this.lex.makePP("wegen", this.mann));
        Assert.assertEquals((Object)"Der Mann sieht.", (Object)this.r.realise(s1));
        Assert.assertEquals((Object)"Die Frau sieht den Mann.", (Object)this.r.realise(s2));
        Assert.assertEquals((Object)"Die Frau gibt dem Mann ein Buch.", (Object)this.r.realise(s3));
        Assert.assertEquals((Object)"Die Frau sieht wegen des Mannes.", (Object)this.r.realise(s4));
        this.mann.setPlural(true);
        Assert.assertEquals((Object)"Die M\u00e4nner sehen.", (Object)this.r.realise(s1));
        Assert.assertEquals((Object)"Die Frau sieht die M\u00e4nner.", (Object)this.r.realise(s2));
        Assert.assertEquals((Object)"Die Frau gibt den M\u00e4nnern ein Buch.", (Object)this.r.realise(s3));
        Assert.assertEquals((Object)"Die Frau sieht wegen der M\u00e4nner.", (Object)this.r.realise(s4));
        this.mann.setPlural(false);
    }

    @Test
    public void testAdjectiveInflection() {
        this.testAdjDegree();
        this.testAdjectiveInflection1();
        this.testAdjectiveInflection2();
        this.testAdjectiveInflection3();
        this.testAdjectiveInflection4();
    }

    private void testAdjDegree() {
        this.resetAll();
        this.schoen.addComplement(this.mann);
        Assert.assertEquals((String)"AdjP with complement, positive degree", (Object)"sch\u00f6n wie der Mann", (Object)this.r.realise(this.schoen));
        this.schoen.setDegree(AdjectiveDegree.COMPARATIVE);
        Assert.assertEquals((String)"AdjP with complement, comparative degree", (Object)"sch\u00f6ner als der Mann", (Object)this.r.realise(this.schoen));
        this.schoen.setDegree(AdjectiveDegree.SUPERLATIVE);
        Assert.assertEquals((String)"AdjP with complement, superlative degree", (Object)"am sch\u00f6nsten wie der Mann", (Object)this.r.realise(this.schoen));
    }

    private void testAdjectiveInflection1() {
        this.resetAll();
        this.mann.addModifier(this.schoen);
        this.frau.addModifier(this.schoen);
        this.kind.addModifier(this.schoen);
        Object[] expectedForms = new String[]{"der sch\u00f6ne Mann", "den sch\u00f6nen Mann", "des sch\u00f6nen Mannes", "dem sch\u00f6nen Mann", "die sch\u00f6nen M\u00e4nner", "die sch\u00f6nen M\u00e4nner", "der sch\u00f6nen M\u00e4nner", "den sch\u00f6nen M\u00e4nnern"};
        ArrayList<String> actualForms = new ArrayList<String>();
        for (NumberAgr numberAgr : this.allNums) {
            this.mann.setNumber(numberAgr);
            for (Case c : this.allCases) {
                this.mann.setCase(c);
                actualForms.add(this.r.realise(this.mann));
            }
        }
        Assert.assertArrayEquals((String)"adjective with definite det, masc.", (Object[])expectedForms, (Object[])actualForms.toArray());
        expectedForms = new String[]{"die sch\u00f6ne Frau", "die sch\u00f6ne Frau", "der sch\u00f6nen Frau", "der sch\u00f6nen Frau"};
        actualForms = new ArrayList();
        for (Enum enum_ : this.allCases) {
            this.frau.setCase((Case)enum_);
            actualForms.add(this.r.realise(this.frau));
        }
        Assert.assertArrayEquals((String)"adjective with definite det, fem.", (Object[])expectedForms, (Object[])actualForms.toArray());
        expectedForms = new String[]{"das sch\u00f6ne Kind", "das sch\u00f6ne Kind", "des sch\u00f6nen Kindes", "dem sch\u00f6nen Kind"};
        actualForms = new ArrayList();
        for (Enum enum_ : this.allCases) {
            this.kind.setCase((Case)enum_);
            actualForms.add(this.r.realise(this.kind));
        }
        Assert.assertArrayEquals((String)"adjective with definite det, neut.", (Object[])expectedForms, (Object[])actualForms.toArray());
    }

    private void testAdjectiveInflection2() {
        this.resetAll();
        this.mann.addModifier(this.schoen);
        this.mann.setDeterminer(Constants.getDeterminer(false));
        this.frau.addModifier(this.schoen);
        this.frau.setDeterminer(Constants.getDeterminer(false));
        this.kind.addModifier(this.schoen);
        this.kind.setDeterminer(Constants.getDeterminer(false));
        Object[] expectedForms = new String[]{"ein sch\u00f6ner Mann", "einen sch\u00f6nen Mann", "eines sch\u00f6nen Mannes", "einem sch\u00f6nen Mann", "einige sch\u00f6ne M\u00e4nner", "einige sch\u00f6ne M\u00e4nner", "einiger sch\u00f6ner M\u00e4nner", "einigen sch\u00f6nen M\u00e4nnern"};
        ArrayList<String> actualForms = new ArrayList<String>();
        for (NumberAgr numberAgr : this.allNums) {
            this.mann.setNumber(numberAgr);
            for (Case c : this.allCases) {
                this.mann.setCase(c);
                actualForms.add(this.r.realise(this.mann));
            }
        }
        Assert.assertArrayEquals((String)"adjective with indefinite det, masc.", (Object[])expectedForms, (Object[])actualForms.toArray());
        expectedForms = new String[]{"eine sch\u00f6ne Frau", "eine sch\u00f6ne Frau", "einer sch\u00f6nen Frau", "einer sch\u00f6nen Frau"};
        actualForms = new ArrayList();
        for (Enum enum_ : this.allCases) {
            this.frau.setCase((Case)enum_);
            actualForms.add(this.r.realise(this.frau));
        }
        Assert.assertArrayEquals((String)"adjective with indefinite det, fem.", (Object[])expectedForms, (Object[])actualForms.toArray());
        expectedForms = new String[]{"ein sch\u00f6nes Kind", "ein sch\u00f6nes Kind", "eines sch\u00f6nen Kindes", "einem sch\u00f6nen Kind"};
        actualForms = new ArrayList();
        for (Enum enum_ : this.allCases) {
            this.kind.setCase((Case)enum_);
            actualForms.add(this.r.realise(this.kind));
        }
        Assert.assertArrayEquals((String)"adjective with indefinite det, neut.", (Object[])expectedForms, (Object[])actualForms.toArray());
    }

    private void testAdjectiveInflection3() {
        this.resetAll();
        this.mann.addModifier(this.schoen);
        this.mann.setDeterminer(null);
        this.frau.addModifier(this.schoen);
        this.frau.setDeterminer(null);
        this.kind.addModifier(this.schoen);
        this.kind.setDeterminer(null);
        Object[] expectedForms = new String[]{"sch\u00f6ner Mann", "sch\u00f6nen Mann", "sch\u00f6nen Mannes", "sch\u00f6nem Mann", "sch\u00f6ne M\u00e4nner", "sch\u00f6ne M\u00e4nner", "sch\u00f6ner M\u00e4nner", "sch\u00f6nen M\u00e4nnern"};
        ArrayList<String> actualForms = new ArrayList<String>();
        for (NumberAgr numberAgr : this.allNums) {
            this.mann.setNumber(numberAgr);
            for (Case c : this.allCases) {
                this.mann.setCase(c);
                actualForms.add(this.r.realise(this.mann));
            }
        }
        Assert.assertArrayEquals((String)"adjective without det, masc.", (Object[])expectedForms, (Object[])actualForms.toArray());
        expectedForms = new String[]{"sch\u00f6ne Frau", "sch\u00f6ne Frau", "sch\u00f6ner Frau", "sch\u00f6ner Frau"};
        actualForms = new ArrayList();
        for (Enum enum_ : this.allCases) {
            this.frau.setCase((Case)enum_);
            actualForms.add(this.r.realise(this.frau));
        }
        Assert.assertArrayEquals((String)"adjective without det, fem.", (Object[])expectedForms, (Object[])actualForms.toArray());
        expectedForms = new String[]{"sch\u00f6nes Kind", "sch\u00f6nes Kind", "sch\u00f6nen Kindes", "sch\u00f6nem Kind"};
        actualForms = new ArrayList();
        for (Enum enum_ : this.allCases) {
            this.kind.setCase((Case)enum_);
            actualForms.add(this.r.realise(this.kind));
        }
        Assert.assertArrayEquals((String)"adjective without det, neut.", (Object[])expectedForms, (Object[])actualForms.toArray());
    }

    private void testAdjectiveInflection4() {
        this.resetAll();
        this.mann.addModifier(this.teuer);
        Assert.assertEquals((String)"irregular adjective inflection", (Object)"der teure Mann", (Object)this.r.realise(this.mann));
        this.mann.addModifier(this.schoen);
        Assert.assertEquals((String)"multiple adjective modifiers", (Object)"der teure, sch\u00f6ne Mann", (Object)this.r.realise(this.mann));
    }

    @Test
    public void testPronounInflection() {
        this.resetAll();
        this.frau.setDeterminer(Constants.getPossessivePronoun(Person.FIRST, NumberAgr.SINGULAR));
        Object[] expectedForms = new String[]{"meine Frau", "meine Frau", "meiner Frau", "meiner Frau", "meine Frauen", "meine Frauen", "meiner Frauen", "meinen Frauen"};
        ArrayList<String> actualForms = new ArrayList<String>();
        for (NumberAgr n : this.allNums) {
            this.frau.setNumber(n);
            for (Case c : this.allCases) {
                this.frau.setCase(c);
                actualForms.add(this.r.realise(this.frau));
            }
        }
        Assert.assertArrayEquals((String)"pronoun in determiner position", (Object[])expectedForms, (Object[])actualForms.toArray());
    }

    @Test
    public void testPronounAdjectiveCombinations() {
        this.testPACAndere();
        this.testPACBeide();
        this.testPACManchAndere();
    }

    private void testPACAndere() {
        this.resetAll();
        Pronoun andere = Constants.getPronoun("andere");
        this.mann.addModifier(andere);
        this.mann.addModifier(this.schoen);
        Object[] expectedForms = new String[]{"der andere sch\u00f6ne Mann", "den anderen sch\u00f6nen Mann", "des anderen sch\u00f6nen Mannes", "dem anderen sch\u00f6nen Mann", "die anderen sch\u00f6nen M\u00e4nner", "die anderen sch\u00f6nen M\u00e4nner", "der anderen sch\u00f6nen M\u00e4nner", "den anderen sch\u00f6nen M\u00e4nnern"};
        ArrayList<String> actualForms = new ArrayList<String>();
        for (NumberAgr n : this.allNums) {
            this.mann.setNumber(n);
            for (Case c : this.allCases) {
                this.mann.setCase(c);
                actualForms.add(this.r.realise(this.mann));
            }
        }
        Assert.assertArrayEquals((String)"'andere' + adj. w/ definite det.", (Object[])expectedForms, (Object[])actualForms.toArray());
        this.mann.setSpecifier(Constants.getDeterminer(false));
        expectedForms = new String[]{"ein anderer sch\u00f6ner Mann", "einen anderen sch\u00f6nen Mann", "eines anderen sch\u00f6nen Mannes", "einem anderen sch\u00f6nen Mann", "einige andere sch\u00f6ne M\u00e4nner", "einige andere sch\u00f6ne M\u00e4nner", "einiger anderer sch\u00f6ner M\u00e4nner", "einigen anderen sch\u00f6nen M\u00e4nnern"};
        actualForms = new ArrayList();
        for (NumberAgr n : this.allNums) {
            this.mann.setNumber(n);
            for (Case c : this.allCases) {
                this.mann.setCase(c);
                actualForms.add(this.r.realise(this.mann));
            }
        }
        Assert.assertArrayEquals((String)"'andere' + adj. w/ indefinite det.", (Object[])expectedForms, (Object[])actualForms.toArray());
        this.mann.setSpecifier(andere);
        this.mann.setPremodifier(this.schoen);
        expectedForms = new String[]{"anderer sch\u00f6ner Mann", "anderen sch\u00f6nen Mann", "anderen sch\u00f6nen Mannes", "anderem sch\u00f6nem Mann", "andere sch\u00f6ne M\u00e4nner", "andere sch\u00f6ne M\u00e4nner", "anderer sch\u00f6ner M\u00e4nner", "anderen sch\u00f6nen M\u00e4nnern"};
        actualForms = new ArrayList();
        for (NumberAgr n : this.allNums) {
            this.mann.setNumber(n);
            for (Case c : this.allCases) {
                this.mann.setCase(c);
                actualForms.add(this.r.realise(this.mann));
            }
        }
        Assert.assertArrayEquals((String)"'andere' in specifier position", (Object[])expectedForms, (Object[])actualForms.toArray());
    }

    private void testPACBeide() {
        this.resetAll();
        this.mann.setPlural(true);
        this.mann.addModifier(this.beide);
        this.mann.addModifier(this.schoen);
        Object[] expectedForms = new String[]{"die beiden sch\u00f6nen M\u00e4nner", "die beiden sch\u00f6nen M\u00e4nner", "der beiden sch\u00f6nen M\u00e4nner", "den beiden sch\u00f6nen M\u00e4nnern"};
        ArrayList<String> actualForms = new ArrayList<String>();
        for (Case c : this.allCases) {
            this.mann.setCase(c);
            actualForms.add(this.r.realise(this.mann));
        }
        Assert.assertArrayEquals((String)"beide + adj. w/ definite det.", (Object[])expectedForms, (Object[])actualForms.toArray());
        this.mann.setSpecifier(this.beide);
        this.mann.setPremodifier(this.schoen);
        expectedForms = new String[]{"beide sch\u00f6nen M\u00e4nner", "beide sch\u00f6nen M\u00e4nner", "beider sch\u00f6nen M\u00e4nner", "beiden sch\u00f6nen M\u00e4nnern"};
        actualForms = new ArrayList();
        for (Case c : this.allCases) {
            this.mann.setCase(c);
            actualForms.add(this.r.realise(this.mann));
        }
        Assert.assertArrayEquals((String)"beide + adj. w/o det.", (Object[])expectedForms, (Object[])actualForms.toArray());
    }

    private void testPACManchAndere() {
        this.resetAll();
        Pronoun andere = Constants.getPronoun("andere");
        Pronoun manch = Constants.getPronoun("manch");
        this.mann.setSpecifier(manch);
        this.mann.addModifier(andere);
        this.mann.addModifier(this.schoen);
        Object[] expectedForms = new String[]{"mancher andere sch\u00f6ne Mann", "manchen anderen sch\u00f6nen Mann", "manches anderen sch\u00f6nen Mannes", "manchem anderen sch\u00f6nen Mann", "manche anderen sch\u00f6nen M\u00e4nner", "manche anderen sch\u00f6nen M\u00e4nner", "mancher anderen sch\u00f6nen M\u00e4nner", "manchen anderen sch\u00f6nen M\u00e4nnern"};
        ArrayList<String> actualForms = new ArrayList<String>();
        for (NumberAgr n : this.allNums) {
            this.mann.setNumber(n);
            for (Case c : this.allCases) {
                this.mann.setCase(c);
                actualForms.add(this.r.realise(this.mann));
            }
        }
        Assert.assertArrayEquals((String)"'manche' (inflected) + 'andere' + adj.", (Object[])expectedForms, (Object[])actualForms.toArray());
        this.mann.setSpecifier("manch");
        expectedForms = new String[]{"manch anderer sch\u00f6ner Mann", "manch anderen sch\u00f6nen Mann", "manch anderen sch\u00f6nen Mannes", "manch anderem sch\u00f6nem Mann", "manch andere sch\u00f6ne M\u00e4nner", "manch andere sch\u00f6ne M\u00e4nner", "manch anderer sch\u00f6ner M\u00e4nner", "manch anderen sch\u00f6nen M\u00e4nnern"};
        actualForms = new ArrayList();
        for (NumberAgr n : this.allNums) {
            this.mann.setNumber(n);
            for (Case c : this.allCases) {
                this.mann.setCase(c);
                actualForms.add(this.r.realise(this.mann));
            }
        }
        Assert.assertArrayEquals((String)"'manch' (uninflected) + 'andere' + adj.", (Object[])expectedForms, (Object[])actualForms.toArray());
    }

    @Test
    public void testPP() {
        this.resetAll();
        PPPhraseSpec pp = this.lex.makePP("wegen", this.mann);
        Assert.assertEquals((Object)"wegen des Mannes", (Object)this.r.realise(pp));
        pp.setContraction(true);
        Assert.assertEquals((Object)"wegen des Mannes", (Object)this.r.realise(pp));
        pp = this.lex.makePP("an", this.mann, Case.DATIVE);
        Assert.assertEquals((Object)"am Mann", (Object)this.r.realise(pp));
        pp.setContraction(false);
        Assert.assertEquals((Object)"an dem Mann", (Object)this.r.realise(pp));
        pp = this.lex.makePP("auf", this.kind);
        Assert.assertEquals((Object)"auf das Kind", (Object)this.r.realise(pp));
        pp.setContraction(true);
        Assert.assertEquals((Object)"aufs Kind", (Object)this.r.realise(pp));
        pp = this.lex.makePP("in", this.buch, Case.DATIVE);
        pp.addPremodifier("mitten");
        Assert.assertEquals((Object)"mitten in einem Buch", (Object)this.r.realise(pp));
    }

    @Test
    public void testNegation() {
        this.resetAll();
        this.schoen.setNegated(true);
        Assert.assertEquals((Object)"nicht sch\u00f6n", (Object)this.r.realise(this.schoen));
        this.schoen.addComplement(this.mann);
        this.schoen.setDegree(AdjectiveDegree.COMPARATIVE);
        Assert.assertEquals((Object)"nicht sch\u00f6ner als der Mann", (Object)this.r.realise(this.schoen));
    }

    @Test
    public void testExpletiveSubject() {
        SPhraseSpec s1 = this.lex.makeS("sein");
        s1.addModifier(this.schoen);
        Assert.assertEquals((Object)"Es ist sch\u00f6n.", (Object)this.r.realise(s1));
    }

    @Test
    public void testImperative() {
        this.resetAll();
        this.sentence.setForm(Form.IMPERATIVE);
        Assert.assertEquals((Object)"Gib dem Mann ein Buch!", (Object)this.r.realise(this.sentence));
        this.sentence.setImperativeForm(NumberAgr.PLURAL, true);
        Assert.assertEquals((Object)"Geben Sie dem Mann ein Buch!", (Object)this.r.realise(this.sentence));
        this.sentence.setImperativeForm(NumberAgr.PLURAL, false);
        Assert.assertEquals((Object)"Gebt dem Mann ein Buch!", (Object)this.r.realise(this.sentence));
        this.matrix.setForm(Form.IMPERATIVE);
        Assert.assertEquals((Object)"Sieh!", (Object)this.r.realise(this.matrix));
    }

    @Test
    public void testPosition() {
        this.resetAll();
        this.sentence.addModifier(Position.DEFAULT, (Object)"gestern");
        Assert.assertEquals((String)"default position", (Object)"Die Frau gab dem Mann ein Buch gestern.", (Object)this.r.realise(this.sentence));
        this.resetSentence();
        this.sentence.addModifier(Position.FRONT, (Object)"gestern");
        Assert.assertEquals((String)"front position", (Object)"Gestern gab die Frau dem Mann ein Buch.", (Object)this.r.realise(this.sentence));
        this.resetSentence();
        this.sentence.addModifier(Position.VORFELD, (Object)"gestern");
        Assert.assertEquals((String)"vorfeld position", (Object)"Gestern gab die Frau dem Mann ein Buch.", (Object)this.r.realise(this.sentence));
        this.resetSentence();
        this.sentence.addModifier(Position.PRE_SUBJECT, (Object)"gestern");
        Assert.assertEquals((String)"pre-subject position", (Object)"Gestern gab die Frau dem Mann ein Buch.", (Object)this.r.realise(this.sentence));
        this.resetSentence();
        this.sentence.addModifier(Position.PRE_OBJECT, (Object)"gestern");
        Assert.assertEquals((String)"pre-object position", (Object)"Die Frau gab dem Mann gestern ein Buch.", (Object)this.r.realise(this.sentence));
        this.resetSentence();
        this.sentence.addModifier(Position.POST_INDIRECT_OBJECT, (Object)"gestern");
        Assert.assertEquals((String)"post-indirect-object position", (Object)"Die Frau gab dem Mann gestern ein Buch.", (Object)this.r.realise(this.sentence));
        this.resetSentence();
        this.sentence.addModifier(Position.PRE_INDIRECT_OBJECT, (Object)"gestern");
        Assert.assertEquals((String)"pre-indirect-object position", (Object)"Die Frau gab gestern dem Mann ein Buch.", (Object)this.r.realise(this.sentence));
        this.resetSentence();
        this.sentence.addModifier(Position.POST_SUBJECT, (Object)"gestern");
        Assert.assertEquals((String)"post-subject position", (Object)"Die Frau gab gestern dem Mann ein Buch.", (Object)this.r.realise(this.sentence));
        this.resetSentence();
        this.sentence.addModifier(Position.POST_OBJECT, (Object)"gestern");
        Assert.assertEquals((String)"post-subject position", (Object)"Die Frau gab dem Mann ein Buch gestern.", (Object)this.r.realise(this.sentence));
    }

    @Test
    public void testWordOrder() {
        this.resetAll();
        Assert.assertEquals((Object)"Die Frau gab dem Mann ein Buch.", (Object)this.r.realise(this.sentence));
        this.resetSentence();
        this.sentence.setWordOrder(WordOrder.SIO);
        Assert.assertEquals((Object)"Die Frau gab dem Mann ein Buch.", (Object)this.r.realise(this.sentence));
        this.resetSentence();
        this.sentence.setWordOrder(WordOrder.SOI);
        Assert.assertEquals((Object)"Die Frau gab ein Buch dem Mann.", (Object)this.r.realise(this.sentence));
        this.resetSentence();
        this.sentence.setWordOrder(WordOrder.ISO);
        Assert.assertEquals((Object)"Dem Mann gab die Frau ein Buch.", (Object)this.r.realise(this.sentence));
        this.resetSentence();
        this.sentence.setWordOrder(WordOrder.IOS);
        Assert.assertEquals((Object)"Dem Mann gab ein Buch die Frau.", (Object)this.r.realise(this.sentence));
        this.resetSentence();
        this.sentence.setWordOrder(WordOrder.OSI);
        Assert.assertEquals((Object)"Ein Buch gab die Frau dem Mann.", (Object)this.r.realise(this.sentence));
        this.resetSentence();
        this.sentence.setWordOrder(WordOrder.OIS);
        Assert.assertEquals((Object)"Ein Buch gab dem Mann die Frau.", (Object)this.r.realise(this.sentence));
    }

    @Test
    public void testPassive() {
        this.resetAll();
        this.sentence.setPassive(true);
        Assert.assertEquals((Object)"Ein Buch wurde dem Mann von der Frau gegeben.", (Object)this.r.realise(this.sentence));
        this.resetSentence();
        this.sentence.setPassive(true);
        this.sentence.setWordOrder(WordOrder.IOS);
        Assert.assertEquals((Object)"Dem Mann wurde ein Buch von der Frau gegeben.", (Object)this.r.realise(this.sentence));
        this.resetSentence();
        this.sentence.setPassive(true);
        this.sentence.setPassiveComplementPosition(Position.PRE_SUBJECT);
        this.sentence.setWordOrder(WordOrder.IOS);
        Assert.assertEquals((Object)"Dem Mann wurde von der Frau ein Buch gegeben.", (Object)this.r.realise(this.sentence));
        this.resetSentence();
        this.sentence.setPassive(true);
        this.sentence.setPassiveComplementPosition(Position.FRONT);
        this.sentence.setWordOrder(WordOrder.IOS);
        Assert.assertEquals((Object)"Von der Frau wurde dem Mann ein Buch gegeben.", (Object)this.r.realise(this.sentence));
        this.resetSentence();
        this.sentence.setPassive(true);
        this.sentence.setPassiveComplementRealisation(false);
        Assert.assertEquals((Object)"Ein Buch wurde dem Mann gegeben.", (Object)this.r.realise(this.sentence));
        this.resetMatrix();
        this.matrix.setPassive(true);
        Assert.assertEquals((Object)"Es wird von der Frau gesehen.", (Object)this.r.realise(this.matrix));
    }

    @Test
    public void testInterrogatives() {
        this.resetAll();
        this.sentence.setInterrogative(InterrogativeType.JA_NEIN);
        Assert.assertEquals((Object)"Gab die Frau dem Mann ein Buch?", (Object)this.r.realise(this.sentence));
        this.resetSentence();
        this.sentence.setInterrogative(InterrogativeType.JA_NEIN);
        this.sentence.setWordOrder(WordOrder.OSI);
        this.sentence.addModifier(Position.FRONT, (Object)"gestern");
        Assert.assertEquals((Object)"Gab gestern ein Buch die Frau dem Mann?", (Object)this.r.realise(this.sentence));
        this.resetSentence();
        this.sentence.setInterrogative(InterrogativeType.WER);
        Assert.assertEquals((Object)"Wer gab dem Mann ein Buch?", (Object)this.r.realise(this.sentence));
        this.resetSentence();
        this.sentence.setInterrogative(InterrogativeType.WER, DiscourseFunction.INDIRECT_OBJECT);
        Assert.assertEquals((Object)"Wem gab die Frau ein Buch?", (Object)this.r.realise(this.sentence));
        this.resetSentence();
        this.sentence.setInterrogative(InterrogativeType.WER, DiscourseFunction.OBJECT);
        Assert.assertEquals((Object)"Wen gab die Frau dem Mann?", (Object)this.r.realise(this.sentence));
        this.resetSentence();
        this.sentence.setInterrogative(InterrogativeType.WARUM);
        Assert.assertEquals((Object)"Warum gab die Frau dem Mann ein Buch?", (Object)this.r.realise(this.sentence));
        this.resetSentence();
        this.sentence.setInterrogative("inwiefern");
        Assert.assertEquals((Object)"Inwiefern gab die Frau dem Mann ein Buch?", (Object)this.r.realise(this.sentence));
        this.resetMatrix();
        this.mann.setSpecifier(Constants.getPronoun("welcher"));
        this.matrix.setInterrogative(this.mann, DiscourseFunction.OBJECT);
        Assert.assertEquals((Object)"Welchen Mann sieht die Frau?", (Object)this.r.realise(this.matrix));
        this.resetAll();
        this.sentence.setEchoInterrogative("ob");
        Assert.assertEquals((Object)"Ob die Frau dem Mann ein Buch gab?", (Object)this.r.realise(this.sentence));
        this.resetSentence();
        this.sentence.setEchoInterrogative(InterrogativeType.WAS, DiscourseFunction.OBJECT);
        Assert.assertEquals((Object)"Was die Frau dem Mann gab?", (Object)this.r.realise(this.sentence));
        this.resetAll();
        this.sentence.setIndirectObject(Constants.getInterrogative(InterrogativeType.WER));
        this.sentence.setSentenceTerminator('?');
        Assert.assertEquals((Object)"Die Frau gab wem ein Buch?", (Object)this.r.realise(this.sentence));
    }

    @Test
    public void testPassiveInterrogatives() {
        this.resetAll();
        this.sentence.setInterrogative(InterrogativeType.WARUM);
        this.sentence.setPassive(true);
        Assert.assertEquals((Object)"Warum wurde ein Buch dem Mann von der Frau gegeben?", (Object)this.r.realise(this.sentence));
        this.resetSentence();
        this.sentence.setInterrogative(InterrogativeType.WER, DiscourseFunction.INDIRECT_OBJECT);
        this.sentence.setPassive(true);
        Assert.assertEquals((Object)"Wem wurde ein Buch von der Frau gegeben?", (Object)this.r.realise(this.sentence));
        this.resetAll();
        this.sentence = new SPhraseSpec(this.frau, this.geben, this.buch);
        this.sentence.setTense(Tense.PAST);
        this.mann.setSpecifier(Constants.getPronoun("welcher"));
        this.sentence.setInterrogative(this.mann, DiscourseFunction.INDIRECT_OBJECT);
        this.sentence.setPassive(true);
        Assert.assertEquals((Object)"Welchem Mann wurde ein Buch von der Frau gegeben?", (Object)this.r.realise(this.sentence));
        this.resetAll();
        this.sentence.setInterrogative(InterrogativeType.WER, DiscourseFunction.OBJECT);
        this.sentence.setPassive(true);
        Assert.assertEquals((Object)"Wer wurde dem Mann von der Frau gegeben?", (Object)this.r.realise(this.sentence));
        this.resetSentence();
        this.sentence.setInterrogative(InterrogativeType.WER, DiscourseFunction.SUBJECT);
        this.sentence.setPassive(true);
        Assert.assertEquals((Object)"Von wem wurde ein Buch dem Mann gegeben?", (Object)this.r.realise(this.sentence));
    }

    @Test
    public void testSubordinates() {
        this.resetAll();
        this.sentence.addSubordinate("obwohl", this.sub1);
        Assert.assertEquals((Object)"Die Frau gab dem Mann ein Buch, obwohl der Mann sch\u00f6n ist.", (Object)this.r.realise(this.sentence));
        this.resetAll();
        CoordinateSPhraseSpec s2 = (CoordinateSPhraseSpec)this.sentence.coordinate(new Phrase[]{this.sub1});
        s2.setConjunction("denn");
        s2.setEnforceComma(true);
        Assert.assertEquals((Object)"Die Frau gab dem Mann ein Buch, denn der Mann ist sch\u00f6n.", (Object)this.r.realise(s2));
    }

    @Test
    public void testSententialModifiers() {
        this.resetAll();
        this.matrix.addSubordinate("dass", this.sub1);
        Assert.assertEquals((Object)"Die Frau sieht, dass der Mann sch\u00f6n ist.", (Object)this.r.realise(this.matrix));
        this.resetMatrix();
        this.matrix.addComplement(this.sub1);
        Assert.assertEquals((Object)"Die Frau sieht den Mann sch\u00f6n sein.", (Object)this.r.realise(this.matrix));
    }

    @Test
    public void testSubordinatePlacement() {
        this.resetAll();
        this.sentence.addSubordinate("weil", this.sub1);
        Assert.assertEquals((Object)"Die Frau gab dem Mann ein Buch, weil der Mann sch\u00f6n ist.", (Object)this.r.realise(this.sentence));
        this.resetAll();
        this.sentence.addSubordinate("weil", this.sub1);
        this.sentence.setPerfect(true);
        Assert.assertEquals((Object)"Die Frau hatte dem Mann ein Buch gegeben, weil der Mann sch\u00f6n ist.", (Object)this.r.realise(this.sentence));
        this.resetAll();
        this.sentence.addSubordinate(Position.DEFAULT, "weil", this.sub1);
        Assert.assertEquals((Object)"Die Frau gab dem Mann ein Buch, weil der Mann sch\u00f6n ist.", (Object)this.r.realise(this.sentence));
        this.resetAll();
        this.sentence.addSubordinate(Position.DEFAULT, "weil", this.sub1);
        this.sentence.setPerfect(true);
        Assert.assertEquals((Object)"Die Frau hatte dem Mann ein Buch, weil der Mann sch\u00f6n ist, gegeben.", (Object)this.r.realise(this.sentence));
        this.resetAll();
        this.sentence.addSubordinate(Position.FRONT, "weil", this.sub1);
        Assert.assertEquals((Object)"Weil der Mann sch\u00f6n ist, gab die Frau dem Mann ein Buch.", (Object)this.r.realise(this.sentence));
        this.resetAll();
        this.sentence.addSubordinate(Position.POST_INDIRECT_OBJECT, "weil", this.sub1);
        Assert.assertEquals((Object)"Die Frau gab dem Mann, weil der Mann sch\u00f6n ist, ein Buch.", (Object)this.r.realise(this.sentence));
        this.resetAll();
        this.sentence.addSubordinate(Position.PRE_INDIRECT_OBJECT, "weil", this.sub1);
        Assert.assertEquals((Object)"Die Frau gab, weil der Mann sch\u00f6n ist, dem Mann ein Buch.", (Object)this.r.realise(this.sentence));
    }

    @Test
    public void testKlabundeSentences() {
        NPPhraseSpec trainGrund = this.lex.makeNP("ein Grundlagentraining");
        NPPhraseSpec trainErhol = this.lex.makeNP("ein Erholungstraining");
        CoordinateNPPhraseSpec cnp = new CoordinateNPPhraseSpec(trainGrund, trainErhol);
        cnp.setConjunction("oder");
        cnp.raiseSpecifier();
        PPPhraseSpec pp1 = this.lex.makePP("f\u00fcr", cnp);
        NPPhraseSpec werte = this.lex.makeNP("Wert");
        werte.setPlural(true);
        werte.setSpecifier(Constants.getHonorificPronoun(true));
        SPhraseSpec s1 = this.lex.makeS(werte, "sein");
        s1.addModifier(pp1);
        s1.addModifier("optimal");
        Assert.assertEquals((Object)"Ihre Werte sind f\u00fcr ein Grundlagentraining oder Erholungstraining optimal.", (Object)this.r.realise(s1));
        NPPhraseSpec tempo = this.lex.makeNP("Trainingstempo");
        tempo.setSpecifier("Ihr");
        SPhraseSpec sub = this.lex.makeS("Sie", "steigern");
        sub.addComplement(tempo);
        sub.addModal("m\u00f6gen");
        sub.setForm(Form.SUBJUNCTIVE_II);
        sub.addModifier("weiter");
        sub.setComplementiser("wenn");
        SPhraseSpec s2 = this.lex.makeS("Sie", "tun");
        s2.addModal("sollen");
        s2.setForm(Form.SUBJUNCTIVE_II);
        s2.addComplement("dies");
        s2.addModifier("ruhig");
        s2.addModifier(Position.FRONT, (Object)sub);
        Assert.assertEquals((Object)"Wenn Sie Ihr Trainingstempo weiter steigern m\u00f6chten, sollten Sie dies ruhig tun.", (Object)this.r.realise(s2));
    }

    @Test
    public void testIMSLex() {
        this.resetAll();
        this.lex = new DBLexicon(new XMLAccessor(imslexFile));
        this.r = new Realiser(this.lex);
        this.sentence = this.lex.makeS("das Pferd", "fressen");
        this.sentence.addComplement(this.lex.makeNP(Constants.PRO_INDEF_KEIN, "Salat"));
        Assert.assertEquals((Object)"Das Pferd frisst keinen Salat.", (Object)this.r.realise(this.sentence));
        NPPhraseSpec lexikon = this.lex.makeNP("das", "Lexikon");
        NPPhraseSpec eintrag = this.lex.makeNP("Eintrag");
        this.sentence = this.lex.makeS(lexikon, "enthalten");
        lexikon.setPlural(true);
        eintrag.setPlural(true);
        eintrag.addModifier(this.lex.makeAdjP("viel"));
        this.sentence.addComplement(eintrag);
        this.sentence.setTense(Tense.PAST);
        Assert.assertEquals((Object)"Die Lexika enthielten viele Eintr\u00e4ge.", (Object)this.r.realise(this.sentence));
    }
}

