import tensorflow as tf

def model_CNN(input_r, numDimensions, windowSize, filterNum, keepratio):
    print(input_r.shape)
    w_conv = tf.Variable(tf.random_normal([windowSize, numDimensions, 1, filterNum], stddev=0.1))
    b_conv = tf.Variable(tf.random_normal([filterNum], stddev=0.1))
    conv = tf.nn.conv2d(input_r, w_conv, strides=[1, 1, 1, 1], padding='VALID')
    conv = tf.nn.relu(tf.nn.bias_add(conv, b_conv))
    conv = tf.reshape(conv, shape=[conv.shape[0].value, -1, filterNum])
    # pool = tf.nn.max_pool(conv, ksize=[1, input_r.shape[1].value-windowSize+1, 1, 1], strides=[1, 1, 1, 1], padding='VALID')
    pool = tf.reduce_max(conv, axis=1)
    pool = tf.nn.dropout(pool, keepratio)
    return pool

def model_TextCNN(input_r, numDimensions, filterNum, keepratio):
    p1 = model_CNN(input_r, numDimensions, 1, filterNum, keepratio)
    p3 = model_CNN(input_r, numDimensions, 3, filterNum, keepratio)
    p5 = model_CNN(input_r, numDimensions, 5, filterNum, keepratio)
    p7 = model_CNN(input_r, numDimensions, 7, filterNum, keepratio)
    p1 = tf.reshape(p1, shape=[p1.shape[0].value, filterNum])
    p3 = tf.reshape(p3, shape=[p3.shape[0].value, filterNum])
    p5 = tf.reshape(p5, shape=[p5.shape[0].value, filterNum])
    p7 = tf.reshape(p7, shape=[p7.shape[0].value, filterNum])
    P = tf.concat([p1, p3, p5, p7], axis=1)
    return P
