/*
 * Decompiled with CFR 0.152.
 */
package org.ardverk.collection;

import java.io.Serializable;
import org.ardverk.collection.AbstractKeyAnalyzer;

public class IntegerKeyAnalyzer
extends AbstractKeyAnalyzer<Integer>
implements Serializable {
    private static final long serialVersionUID = 8805465126366464399L;
    public static final IntegerKeyAnalyzer INSTANCE = new IntegerKeyAnalyzer();
    private static final int MSB = Integer.MIN_VALUE;

    private static int mask(int n) {
        return Integer.MIN_VALUE >>> n;
    }

    @Override
    public int lengthInBits(Integer n) {
        return 32;
    }

    @Override
    public boolean isBitSet(Integer n, int n2) {
        return (n & IntegerKeyAnalyzer.mask(n2)) != 0;
    }

    @Override
    public int bitIndex(Integer n, Integer n2) {
        int n3 = n;
        if (n3 == 0) {
            return -1;
        }
        int n4 = n2;
        if (n3 != n4) {
            int n5 = n3 ^ n4;
            for (int i = 0; i < 32; ++i) {
                if ((n5 & IntegerKeyAnalyzer.mask(i)) == 0) continue;
                return i;
            }
        }
        return -2;
    }

    @Override
    public boolean isPrefix(Integer n, Integer n2) {
        return n.equals(n2);
    }
}

