#ifndef _graphcjj2gc_prune_WEIGHT_H
#define _graphcjj2gc_prune_WEIGHT_H

#include "graphcjj2gc_prune_macros.h"
#include "common/parser/weight_base.h"
#include "include/learning/perceptron/packed_score.h"

namespace graphcjj2gc_prune {
	class Weight : public WeightBase {
	public:
		WordIntMap m_mapPw;
		POSTagIntMap m_mapPp;
		WordPOSTagIntMap m_mapPwp;

		WordIntMap m_mapCw;
		POSTagIntMap m_mapCp;
		WordPOSTagIntMap m_mapCwp;

		WordIntMap m_mapC1w;
		POSTagIntMap m_mapC1p;
		WordPOSTagIntMap m_mapC1wp;

		WordIntMap m_mapC_1w;
		POSTagIntMap m_mapC_1p;
		WordPOSTagIntMap m_mapC_1wp;

		WordIntMap m_mapP_1w;
		POSTagIntMap m_mapP_1p;
		WordPOSTagIntMap m_mapP_1wp;

		WordIntMap m_mapP1w;
		POSTagIntMap m_mapP1p;
		WordPOSTagIntMap m_mapP1wp;

		WordWordPOSTagPOSTagIntMap m_mapPwpCwp;
		WordPOSTagPOSTagIntMap m_mapPpCwp;
		WordPOSTagPOSTagIntMap m_mapPwpCp;
		WordWordPOSTagIntMap m_mapPwCwp;
		WordWordPOSTagIntMap m_mapPwpCw;
		TwoWordsIntMap m_mapPwCw;
		POSTagSet2IntMap m_mapPpCp;
		POSTagSet3IntMap m_mapPpBpCp;

		POSTagSet4IntMap m_mapPpPp1Cp_1Cp;
		POSTagSet4IntMap m_mapPp_1PpCp_1Cp;
		POSTagSet4IntMap m_mapPpPp1CpCp1;
		POSTagSet4IntMap m_mapPp_1PpCpCp1;

		POSTagSet4IntMap m_mapPC_1C;
		POSTagSet4IntMap m_mapPCC1;
		POSTagSet4IntMap m_mapPP1C;
		POSTagSet4IntMap m_mapP_1PC;

		POSTagSet3IntMap m_mapP_1C,m_mapP1C,m_mapPC1,m_mapPC_1;

		PathIntMap m_mapPath;
		PathIntMap m_mapFPath;
		PathIntMap m_mapLPath;
		PathIntMap m_mapPsubcat;
		PathIntMap m_mapCsubcat;

		POSTagSet2IntMap m_mapPsubcatCtag,m_mapPFPathCtag;
		POSTagSet2IntMap m_mapCsubcatPtag,m_mapCFPathPtag;

		PathIntMap m_mapPC;

		WordPOSTagIntMap m_mapLW,m_mapRW,m_mapLW_1,m_mapRW1;
		POSTagSet3IntMap m_mapPLW,m_mapPRW,m_mapPLW_1,m_mapPRW1;


		LabelIntMap m_mapCLabel;
		POSTagSet2IntMap m_mapLCpPp, m_mapRCpPp, m_mapLSpPp, m_mapRSpPp;
		WordPOSTagIntMap m_mapLCwPp, m_mapRCwPp, m_mapLCpPw, m_mapRCpPw, m_mapLSwPp, m_mapRSwPp;
		TwoWordsIntMap m_mapLCwPw, m_mapRCwPw;

		//sibling
		POSTagSet3IntMap m_mapPpC1pC2p;
		WordPOSTagPOSTagIntMap m_mapPwC1pC2p, m_mapPpC1wC2p, m_mapPpC1pC2w;
		WordPOSTagPOSTagIntMap m_mapPpC1wC2w, m_mapPwC1pC2w, m_mapPwC1wC2p;
		WordPOSTagIntMap m_mapC1wC2p;
		WordPOSTagIntMap m_mapC1pC2w;
		TwoWordsIntMap m_mapC1wC2w;
		POSTagSet2IntMap m_mapC1pC2p;
		//gc
		POSTagSet3IntMap m_mapPpC1pC2p_gc;
		WordPOSTagPOSTagIntMap m_mapPwC1pC2p_gc, m_mapPpC1wC2p_gc, m_mapPpC1pC2w_gc;
		WordPOSTagPOSTagIntMap m_mapPpC1wC2w_gc, m_mapPwC1pC2w_gc, m_mapPwC1wC2p_gc;
		WordPOSTagIntMap m_mapC1wC2p_gc;
		WordPOSTagIntMap m_mapC1pC2w_gc;
		TwoWordsIntMap m_mapC1wC2w_gc;
		POSTagSet2IntMap m_mapC1pC2p_gc;		

	public:
		Weight(const std::string & sRead, const std::string & sRecord);
		Weight(const std::string & sRead, const std::string & sRecord, TDepLabel &DepLabel);
		~Weight();

		void loadScores() override {};
		void loadScores(TDepLabel &DepLabel);
		void saveScores(TDepLabel &DepLabel) const override;
		void computeAverageFeatureWeights(const int & round) override;
	};
}

#endif
