/*
 * Decompiled with CFR 0.152.
 */
package org.ardverk.collection;

import java.io.Serializable;
import org.ardverk.collection.AbstractKeyAnalyzer;

public abstract class ByteArrayKeyAnalyzer
extends AbstractKeyAnalyzer<byte[]>
implements Serializable {
    private static final long serialVersionUID = 6496047734419335722L;
    public static final ByteArrayKeyAnalyzer CONSTANT = new Constant();
    public static final ByteArrayKeyAnalyzer VARIABLE = new Variable();
    @Deprecated
    public static final ByteArrayKeyAnalyzer INSTANCE = CONSTANT;
    private static final int MSB = 128;

    public static ByteArrayKeyAnalyzer create(int n) {
        return new Constant(n);
    }

    @Override
    public int compare(byte[] byArray, byte[] byArray2) {
        if (byArray == null) {
            return byArray2 == null ? 0 : -1;
        }
        if (byArray2 == null) {
            return byArray == null ? 0 : 1;
        }
        if (byArray.length != byArray2.length) {
            return byArray.length - byArray2.length;
        }
        for (int i = 0; i < byArray.length; ++i) {
            int n = (byArray[i] & 0xFF) - (byArray2[i] & 0xFF);
            if (n == 0) continue;
            return n;
        }
        return 0;
    }

    @Override
    public int lengthInBits(byte[] byArray) {
        return byArray.length * 8;
    }

    @Override
    public boolean isPrefix(byte[] byArray, byte[] byArray2) {
        if (byArray.length < byArray2.length) {
            return false;
        }
        for (int i = 0; i < byArray2.length; ++i) {
            if (byArray[i] == byArray2[i]) continue;
            return false;
        }
        return true;
    }

    private static int mask(int n) {
        return 128 >>> n;
    }

    private static byte valueAt(byte[] byArray, int n) {
        if (n >= 0 && n < byArray.length) {
            return byArray[n];
        }
        return 0;
    }

    private static class Constant
    extends ByteArrayKeyAnalyzer {
        private static final long serialVersionUID = 6464528643075848768L;
        private static final int DEFAULT_LENGTH = 0xFFFFFFF;
        private final int maxLength;

        public Constant() {
            this(0xFFFFFFF);
        }

        public Constant(int n) {
            this.maxLength = n;
        }

        @Override
        public boolean isBitSet(byte[] byArray, int n) {
            if (this.maxLength < byArray.length) {
                throw new IllegalArgumentException();
            }
            int n2 = this.lengthInBits(byArray);
            int n3 = this.maxLength * 8 - n2;
            int n4 = n - n3;
            if (n4 >= n2 || n4 < 0) {
                return false;
            }
            int n5 = n4 / 8;
            int n6 = n4 % 8;
            return (byArray[n5] & ByteArrayKeyAnalyzer.mask(n6)) != 0;
        }

        @Override
        public int bitIndex(byte[] byArray, byte[] byArray2) {
            if (this.maxLength < byArray.length) {
                throw new IllegalArgumentException();
            }
            boolean bl = true;
            int n = Math.max(byArray.length, byArray2.length);
            int n2 = (this.maxLength - n) * 8;
            for (int i = 0; i < n; ++i) {
                byte by;
                byte by2 = ByteArrayKeyAnalyzer.valueAt(byArray, byArray.length - n + i);
                if (by2 != (by = ByteArrayKeyAnalyzer.valueAt(byArray2, byArray2.length - n + i))) {
                    int n3 = by2 ^ by;
                    for (int j = 0; j < 8; ++j) {
                        if ((n3 & ByteArrayKeyAnalyzer.mask(j)) == 0) continue;
                        return n2 + i * 8 + j;
                    }
                }
                if (by2 == 0) continue;
                bl = false;
            }
            if (bl) {
                return -1;
            }
            return -2;
        }
    }

    private static class Variable
    extends ByteArrayKeyAnalyzer {
        private static final long serialVersionUID = 5360165640553653434L;

        private Variable() {
        }

        @Override
        public boolean isBitSet(byte[] byArray, int n) {
            if (n >= this.lengthInBits(byArray)) {
                return false;
            }
            int n2 = n / 8;
            int n3 = n % 8;
            return (byArray[n2] & ByteArrayKeyAnalyzer.mask(n3)) != 0;
        }

        @Override
        public int bitIndex(byte[] byArray, byte[] byArray2) {
            int n = Math.max(byArray.length, byArray2.length);
            boolean bl = true;
            for (int i = 0; i < n; ++i) {
                byte by;
                byte by2 = ByteArrayKeyAnalyzer.valueAt(byArray, i);
                if (by2 != (by = ByteArrayKeyAnalyzer.valueAt(byArray2, i))) {
                    int n2 = by2 ^ by;
                    for (int j = 0; j < 8; ++j) {
                        if ((n2 & ByteArrayKeyAnalyzer.mask(j)) == 0) continue;
                        return i * 8 + j;
                    }
                }
                if (by2 == 0) continue;
                bl = false;
            }
            if (bl) {
                return -1;
            }
            return -2;
        }
    }
}

