/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.CompoundFileWriter;
import org.apache.lucene.index.ConcurrentMergeScheduler;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.DocumentsWriter;
import org.apache.lucene.index.IndexDeletionPolicy;
import org.apache.lucene.index.IndexFileDeleter;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.KeepOnlyLastCommitDeletionPolicy;
import org.apache.lucene.index.LogByteSizeMergePolicy;
import org.apache.lucene.index.LogDocMergePolicy;
import org.apache.lucene.index.LogMergePolicy;
import org.apache.lucene.index.MergePolicy;
import org.apache.lucene.index.MergeScheduler;
import org.apache.lucene.index.SegmentInfo;
import org.apache.lucene.index.SegmentInfos;
import org.apache.lucene.index.SegmentMerger;
import org.apache.lucene.index.SegmentReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Similarity;
import org.apache.lucene.store.AlreadyClosedException;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.Lock;
import org.apache.lucene.store.LockObtainFailedException;
import org.apache.lucene.util.BitVector;
import org.apache.lucene.util.Constants;

public class IndexWriter {
    public static long WRITE_LOCK_TIMEOUT;
    private long writeLockTimeout = WRITE_LOCK_TIMEOUT;
    public static final String WRITE_LOCK_NAME = "write.lock";
    public static final int DEFAULT_MERGE_FACTOR = 10;
    public static final int DISABLE_AUTO_FLUSH = -1;
    public static final int DEFAULT_MAX_BUFFERED_DOCS = -1;
    public static final double DEFAULT_RAM_BUFFER_SIZE_MB = 16.0;
    public static final int DEFAULT_MAX_BUFFERED_DELETE_TERMS = -1;
    public static final int DEFAULT_MAX_MERGE_DOCS = Integer.MAX_VALUE;
    public static final int DEFAULT_MAX_FIELD_LENGTH = 10000;
    public static final int DEFAULT_TERM_INDEX_INTERVAL = 128;
    public static final int MAX_TERM_LENGTH = 16383;
    public static final double DEFAULT_MAX_SYNC_PAUSE_SECONDS;
    private static final int MERGE_READ_BUFFER_SIZE = 4096;
    private static Object MESSAGE_ID_LOCK;
    private static int MESSAGE_ID;
    private int messageID = -1;
    private volatile boolean hitOOM;
    private Directory directory;
    private Analyzer analyzer;
    private Similarity similarity = Similarity.getDefault();
    private volatile long changeCount;
    private long lastCommitChangeCount;
    private SegmentInfos rollbackSegmentInfos;
    private HashMap rollbackSegments;
    volatile SegmentInfos pendingCommit;
    volatile long pendingCommitChangeCount;
    private SegmentInfos localRollbackSegmentInfos;
    private boolean localAutoCommit;
    private int localFlushedDocCount;
    private boolean autoCommit = true;
    private SegmentInfos segmentInfos = new SegmentInfos();
    private DocumentsWriter docWriter;
    private IndexFileDeleter deleter;
    private Set segmentsToOptimize = new HashSet();
    private Lock writeLock;
    private int termIndexInterval = 128;
    private boolean closeDir;
    private boolean closed;
    private boolean closing;
    private HashSet mergingSegments = new HashSet();
    private MergePolicy mergePolicy = new LogByteSizeMergePolicy();
    private MergeScheduler mergeScheduler = new ConcurrentMergeScheduler();
    private LinkedList pendingMerges = new LinkedList();
    private Set runningMerges = new HashSet();
    private List mergeExceptions = new ArrayList();
    private long mergeGen;
    private boolean stopMerges;
    private int flushCount;
    private int flushDeletesCount;
    private double maxSyncPauseSeconds = DEFAULT_MAX_SYNC_PAUSE_SECONDS;
    private int readCount;
    private Thread writeThread;
    private int maxFieldLength;
    private PrintStream infoStream = null;
    private static PrintStream defaultInfoStream;
    private boolean committing;
    private HashSet synced = new HashSet();
    private HashSet syncing = new HashSet();
    static final /* synthetic */ boolean $assertionsDisabled;

    synchronized void acquireWrite() {
        while (this.writeThread != null || this.readCount > 0) {
            this.doWait();
        }
        this.ensureOpen();
        this.writeThread = Thread.currentThread();
    }

    synchronized void releaseWrite() {
        if (!$assertionsDisabled && Thread.currentThread() != this.writeThread) {
            throw new AssertionError();
        }
        this.writeThread = null;
        this.notifyAll();
    }

    synchronized void acquireRead() {
        Thread current = Thread.currentThread();
        while (this.writeThread != null && this.writeThread != current) {
            this.doWait();
        }
        ++this.readCount;
    }

    synchronized void releaseRead() {
        --this.readCount;
        if (!$assertionsDisabled && this.readCount < 0) {
            throw new AssertionError();
        }
        if (0 == this.readCount) {
            this.notifyAll();
        }
    }

    protected final synchronized void ensureOpen(boolean includePendingClose) throws AlreadyClosedException {
        if (this.closed || includePendingClose && this.closing) {
            throw new AlreadyClosedException("this IndexWriter is closed");
        }
    }

    protected final synchronized void ensureOpen() throws AlreadyClosedException {
        this.ensureOpen(true);
    }

    public void message(String message) {
        if (this.infoStream != null) {
            this.infoStream.println("IW " + this.messageID + " [" + Thread.currentThread().getName() + "]: " + message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void setMessageID(PrintStream infoStream) {
        if (infoStream != null && this.messageID == -1) {
            Object object = MESSAGE_ID_LOCK;
            synchronized (object) {
                this.messageID = MESSAGE_ID++;
            }
        }
        this.infoStream = infoStream;
    }

    private LogMergePolicy getLogMergePolicy() {
        if (this.mergePolicy instanceof LogMergePolicy) {
            return (LogMergePolicy)this.mergePolicy;
        }
        throw new IllegalArgumentException("this method can only be called when the merge policy is the default LogMergePolicy");
    }

    public boolean getUseCompoundFile() {
        return this.getLogMergePolicy().getUseCompoundFile();
    }

    public void setUseCompoundFile(boolean value) {
        this.getLogMergePolicy().setUseCompoundFile(value);
        this.getLogMergePolicy().setUseCompoundDocStore(value);
    }

    public void setSimilarity(Similarity similarity) {
        this.ensureOpen();
        this.similarity = similarity;
        this.docWriter.setSimilarity(similarity);
    }

    public Similarity getSimilarity() {
        this.ensureOpen();
        return this.similarity;
    }

    public void setTermIndexInterval(int interval) {
        this.ensureOpen();
        this.termIndexInterval = interval;
    }

    public int getTermIndexInterval() {
        this.ensureOpen(false);
        return this.termIndexInterval;
    }

    public IndexWriter(String path, Analyzer a, boolean create, MaxFieldLength mfl) throws CorruptIndexException, LockObtainFailedException, IOException {
        this.init(FSDirectory.getDirectory(path), a, create, true, null, false, mfl.getLimit());
    }

    public IndexWriter(String path, Analyzer a, boolean create) throws CorruptIndexException, LockObtainFailedException, IOException {
        this.init(FSDirectory.getDirectory(path), a, create, true, null, true, 10000);
    }

    public IndexWriter(File path, Analyzer a, boolean create, MaxFieldLength mfl) throws CorruptIndexException, LockObtainFailedException, IOException {
        this.init(FSDirectory.getDirectory(path), a, create, true, null, false, mfl.getLimit());
    }

    public IndexWriter(File path, Analyzer a, boolean create) throws CorruptIndexException, LockObtainFailedException, IOException {
        this.init(FSDirectory.getDirectory(path), a, create, true, null, true, 10000);
    }

    public IndexWriter(Directory d, Analyzer a, boolean create, MaxFieldLength mfl) throws CorruptIndexException, LockObtainFailedException, IOException {
        this.init(d, a, create, false, null, false, mfl.getLimit());
    }

    public IndexWriter(Directory d, Analyzer a, boolean create) throws CorruptIndexException, LockObtainFailedException, IOException {
        this.init(d, a, create, false, null, true, 10000);
    }

    public IndexWriter(String path, Analyzer a, MaxFieldLength mfl) throws CorruptIndexException, LockObtainFailedException, IOException {
        this.init(FSDirectory.getDirectory(path), a, true, null, false, mfl.getLimit());
    }

    public IndexWriter(String path, Analyzer a) throws CorruptIndexException, LockObtainFailedException, IOException {
        this.init(FSDirectory.getDirectory(path), a, true, null, true, 10000);
    }

    public IndexWriter(File path, Analyzer a, MaxFieldLength mfl) throws CorruptIndexException, LockObtainFailedException, IOException {
        this.init(FSDirectory.getDirectory(path), a, true, null, false, mfl.getLimit());
    }

    public IndexWriter(File path, Analyzer a) throws CorruptIndexException, LockObtainFailedException, IOException {
        this.init(FSDirectory.getDirectory(path), a, true, null, true, 10000);
    }

    public IndexWriter(Directory d, Analyzer a, MaxFieldLength mfl) throws CorruptIndexException, LockObtainFailedException, IOException {
        this.init(d, a, false, null, false, mfl.getLimit());
    }

    public IndexWriter(Directory d, Analyzer a) throws CorruptIndexException, LockObtainFailedException, IOException {
        this.init(d, a, false, null, true, 10000);
    }

    public IndexWriter(Directory d, boolean autoCommit, Analyzer a) throws CorruptIndexException, LockObtainFailedException, IOException {
        this.init(d, a, false, null, autoCommit, 10000);
    }

    public IndexWriter(Directory d, boolean autoCommit, Analyzer a, boolean create) throws CorruptIndexException, LockObtainFailedException, IOException {
        this.init(d, a, create, false, null, autoCommit, 10000);
    }

    public IndexWriter(Directory d, Analyzer a, IndexDeletionPolicy deletionPolicy, MaxFieldLength mfl) throws CorruptIndexException, LockObtainFailedException, IOException {
        this.init(d, a, false, deletionPolicy, false, mfl.getLimit());
    }

    public IndexWriter(Directory d, boolean autoCommit, Analyzer a, IndexDeletionPolicy deletionPolicy) throws CorruptIndexException, LockObtainFailedException, IOException {
        this.init(d, a, false, deletionPolicy, autoCommit, 10000);
    }

    public IndexWriter(Directory d, Analyzer a, boolean create, IndexDeletionPolicy deletionPolicy, MaxFieldLength mfl) throws CorruptIndexException, LockObtainFailedException, IOException {
        this.init(d, a, create, false, deletionPolicy, false, mfl.getLimit());
    }

    public IndexWriter(Directory d, boolean autoCommit, Analyzer a, boolean create, IndexDeletionPolicy deletionPolicy) throws CorruptIndexException, LockObtainFailedException, IOException {
        this.init(d, a, create, false, deletionPolicy, autoCommit, 10000);
    }

    private void init(Directory d, Analyzer a, boolean closeDir, IndexDeletionPolicy deletionPolicy, boolean autoCommit, int maxFieldLength) throws CorruptIndexException, LockObtainFailedException, IOException {
        if (IndexReader.indexExists(d)) {
            this.init(d, a, false, closeDir, deletionPolicy, autoCommit, maxFieldLength);
        } else {
            this.init(d, a, true, closeDir, deletionPolicy, autoCommit, maxFieldLength);
        }
    }

    private void init(Directory d, Analyzer a, boolean create, boolean closeDir, IndexDeletionPolicy deletionPolicy, boolean autoCommit, int maxFieldLength) throws CorruptIndexException, LockObtainFailedException, IOException {
        Lock writeLock;
        this.closeDir = closeDir;
        this.directory = d;
        this.analyzer = a;
        this.setMessageID(defaultInfoStream);
        this.maxFieldLength = maxFieldLength;
        if (create) {
            this.directory.clearLock(WRITE_LOCK_NAME);
        }
        if (!(writeLock = this.directory.makeLock(WRITE_LOCK_NAME)).obtain(this.writeLockTimeout)) {
            throw new LockObtainFailedException("Index locked for write: " + writeLock);
        }
        this.writeLock = writeLock;
        try {
            if (create) {
                try {
                    this.segmentInfos.read(this.directory);
                    this.segmentInfos.clear();
                }
                catch (IOException e) {
                    // empty catch block
                }
                this.segmentInfos.commit(this.directory);
            } else {
                this.segmentInfos.read(this.directory);
                for (int i = 0; i < this.segmentInfos.size(); ++i) {
                    SegmentInfo info = this.segmentInfos.info(i);
                    List files = info.files();
                    for (int j = 0; j < files.size(); ++j) {
                        this.synced.add(files.get(j));
                    }
                }
            }
            this.autoCommit = autoCommit;
            this.setRollbackSegmentInfos(this.segmentInfos);
            this.docWriter = new DocumentsWriter(this.directory, this);
            this.docWriter.setInfoStream(this.infoStream);
            this.docWriter.setMaxFieldLength(maxFieldLength);
            this.deleter = new IndexFileDeleter(this.directory, deletionPolicy == null ? new KeepOnlyLastCommitDeletionPolicy() : deletionPolicy, this.segmentInfos, this.infoStream, this.docWriter);
            this.pushMaxBufferedDocs();
            if (this.infoStream != null) {
                this.message("init: create=" + create);
                this.messageState();
            }
        }
        catch (IOException e) {
            this.writeLock.release();
            this.writeLock = null;
            throw e;
        }
    }

    private synchronized void setRollbackSegmentInfos(SegmentInfos infos) {
        this.rollbackSegmentInfos = (SegmentInfos)infos.clone();
        if (!$assertionsDisabled && this.hasExternalSegments(this.rollbackSegmentInfos)) {
            throw new AssertionError();
        }
        this.rollbackSegments = new HashMap();
        int size = this.rollbackSegmentInfos.size();
        for (int i = 0; i < size; ++i) {
            this.rollbackSegments.put(this.rollbackSegmentInfos.info(i), new Integer(i));
        }
    }

    public void setMergePolicy(MergePolicy mp) {
        this.ensureOpen();
        if (mp == null) {
            throw new NullPointerException("MergePolicy must be non-null");
        }
        if (this.mergePolicy != mp) {
            this.mergePolicy.close();
        }
        this.mergePolicy = mp;
        this.pushMaxBufferedDocs();
        if (this.infoStream != null) {
            this.message("setMergePolicy " + mp);
        }
    }

    public MergePolicy getMergePolicy() {
        this.ensureOpen();
        return this.mergePolicy;
    }

    public synchronized void setMergeScheduler(MergeScheduler mergeScheduler) throws CorruptIndexException, IOException {
        this.ensureOpen();
        if (mergeScheduler == null) {
            throw new NullPointerException("MergeScheduler must be non-null");
        }
        if (this.mergeScheduler != mergeScheduler) {
            this.finishMerges(true);
            this.mergeScheduler.close();
        }
        this.mergeScheduler = mergeScheduler;
        if (this.infoStream != null) {
            this.message("setMergeScheduler " + mergeScheduler);
        }
    }

    public MergeScheduler getMergeScheduler() {
        this.ensureOpen();
        return this.mergeScheduler;
    }

    public void setMaxMergeDocs(int maxMergeDocs) {
        this.getLogMergePolicy().setMaxMergeDocs(maxMergeDocs);
    }

    public int getMaxMergeDocs() {
        return this.getLogMergePolicy().getMaxMergeDocs();
    }

    public void setMaxFieldLength(int maxFieldLength) {
        this.ensureOpen();
        this.maxFieldLength = maxFieldLength;
        this.docWriter.setMaxFieldLength(maxFieldLength);
        if (this.infoStream != null) {
            this.message("setMaxFieldLength " + maxFieldLength);
        }
    }

    public int getMaxFieldLength() {
        this.ensureOpen();
        return this.maxFieldLength;
    }

    public void setMaxBufferedDocs(int maxBufferedDocs) {
        this.ensureOpen();
        if (maxBufferedDocs != -1 && maxBufferedDocs < 2) {
            throw new IllegalArgumentException("maxBufferedDocs must at least be 2 when enabled");
        }
        if (maxBufferedDocs == -1 && this.getRAMBufferSizeMB() == -1.0) {
            throw new IllegalArgumentException("at least one of ramBufferSize and maxBufferedDocs must be enabled");
        }
        this.docWriter.setMaxBufferedDocs(maxBufferedDocs);
        this.pushMaxBufferedDocs();
        if (this.infoStream != null) {
            this.message("setMaxBufferedDocs " + maxBufferedDocs);
        }
    }

    private void pushMaxBufferedDocs() {
        MergePolicy mp;
        if (this.docWriter.getMaxBufferedDocs() != -1 && (mp = this.mergePolicy) instanceof LogDocMergePolicy) {
            LogDocMergePolicy lmp = (LogDocMergePolicy)mp;
            int maxBufferedDocs = this.docWriter.getMaxBufferedDocs();
            if (lmp.getMinMergeDocs() != maxBufferedDocs) {
                if (this.infoStream != null) {
                    this.message("now push maxBufferedDocs " + maxBufferedDocs + " to LogDocMergePolicy");
                }
                lmp.setMinMergeDocs(maxBufferedDocs);
            }
        }
    }

    public int getMaxBufferedDocs() {
        this.ensureOpen();
        return this.docWriter.getMaxBufferedDocs();
    }

    public void setRAMBufferSizeMB(double mb) {
        if (mb != -1.0 && mb <= 0.0) {
            throw new IllegalArgumentException("ramBufferSize should be > 0.0 MB when enabled");
        }
        if (mb == -1.0 && this.getMaxBufferedDocs() == -1) {
            throw new IllegalArgumentException("at least one of ramBufferSize and maxBufferedDocs must be enabled");
        }
        this.docWriter.setRAMBufferSizeMB(mb);
        if (this.infoStream != null) {
            this.message("setRAMBufferSizeMB " + mb);
        }
    }

    public double getRAMBufferSizeMB() {
        return this.docWriter.getRAMBufferSizeMB();
    }

    public void setMaxBufferedDeleteTerms(int maxBufferedDeleteTerms) {
        this.ensureOpen();
        if (maxBufferedDeleteTerms != -1 && maxBufferedDeleteTerms < 1) {
            throw new IllegalArgumentException("maxBufferedDeleteTerms must at least be 1 when enabled");
        }
        this.docWriter.setMaxBufferedDeleteTerms(maxBufferedDeleteTerms);
        if (this.infoStream != null) {
            this.message("setMaxBufferedDeleteTerms " + maxBufferedDeleteTerms);
        }
    }

    public int getMaxBufferedDeleteTerms() {
        this.ensureOpen();
        return this.docWriter.getMaxBufferedDeleteTerms();
    }

    public void setMergeFactor(int mergeFactor) {
        this.getLogMergePolicy().setMergeFactor(mergeFactor);
    }

    public int getMergeFactor() {
        return this.getLogMergePolicy().getMergeFactor();
    }

    public double getMaxSyncPauseSeconds() {
        return this.maxSyncPauseSeconds;
    }

    public void setMaxSyncPauseSeconds(double seconds) {
        this.maxSyncPauseSeconds = seconds;
    }

    public static void setDefaultInfoStream(PrintStream infoStream) {
        defaultInfoStream = infoStream;
    }

    public static PrintStream getDefaultInfoStream() {
        return defaultInfoStream;
    }

    public void setInfoStream(PrintStream infoStream) {
        this.ensureOpen();
        this.setMessageID(infoStream);
        this.docWriter.setInfoStream(infoStream);
        this.deleter.setInfoStream(infoStream);
        if (infoStream != null) {
            this.messageState();
        }
    }

    private void messageState() {
        this.message("setInfoStream: dir=" + this.directory + " autoCommit=" + this.autoCommit + " mergePolicy=" + this.mergePolicy + " mergeScheduler=" + this.mergeScheduler + " ramBufferSizeMB=" + this.docWriter.getRAMBufferSizeMB() + " maxBufferedDocs=" + this.docWriter.getMaxBufferedDocs() + " maxBuffereDeleteTerms=" + this.docWriter.getMaxBufferedDeleteTerms() + " maxFieldLength=" + this.maxFieldLength + " index=" + this.segString());
    }

    public PrintStream getInfoStream() {
        this.ensureOpen();
        return this.infoStream;
    }

    public void setWriteLockTimeout(long writeLockTimeout) {
        this.ensureOpen();
        this.writeLockTimeout = writeLockTimeout;
    }

    public long getWriteLockTimeout() {
        this.ensureOpen();
        return this.writeLockTimeout;
    }

    public static void setDefaultWriteLockTimeout(long writeLockTimeout) {
        WRITE_LOCK_TIMEOUT = writeLockTimeout;
    }

    public static long getDefaultWriteLockTimeout() {
        return WRITE_LOCK_TIMEOUT;
    }

    public void close() throws CorruptIndexException, IOException {
        this.close(true);
    }

    public void close(boolean waitForMerges) throws CorruptIndexException, IOException {
        if (this.hitOOM) {
            this.rollback();
            return;
        }
        if (this.shouldClose()) {
            this.closeInternal(waitForMerges);
        }
    }

    private synchronized boolean shouldClose() {
        while (!this.closed) {
            if (!this.closing) {
                this.closing = true;
                return true;
            }
            this.doWait();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeInternal(boolean waitForMerges) throws CorruptIndexException, IOException {
        this.docWriter.pauseAllThreads();
        try {
            if (this.infoStream != null) {
                this.message("now flush at close");
            }
            this.docWriter.close();
            this.flush(waitForMerges, true, true);
            if (waitForMerges) {
                this.mergeScheduler.merge(this);
            }
            this.mergePolicy.close();
            this.finishMerges(waitForMerges);
            this.mergeScheduler.close();
            if (this.infoStream != null) {
                this.message("now call final commit()");
            }
            this.commit(0L);
            if (this.infoStream != null) {
                this.message("at close: " + this.segString());
            }
            IndexWriter indexWriter = this;
            synchronized (indexWriter) {
                this.docWriter = null;
                this.deleter.close();
            }
            if (this.closeDir) {
                this.directory.close();
            }
            if (this.writeLock != null) {
                this.writeLock.release();
                this.writeLock = null;
            }
            indexWriter = this;
            synchronized (indexWriter) {
                this.closed = true;
            }
        }
        catch (OutOfMemoryError oom) {
            this.hitOOM = true;
            throw oom;
        }
        finally {
            IndexWriter indexWriter = this;
            synchronized (indexWriter) {
                this.closing = false;
                this.notifyAll();
                if (!this.closed) {
                    if (this.docWriter != null) {
                        this.docWriter.resumeAllThreads();
                    }
                    if (this.infoStream != null) {
                        this.message("hit exception while closing");
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized boolean flushDocStores() throws IOException {
        String docStoreSegment;
        boolean useCompoundDocStore = false;
        boolean success = false;
        try {
            docStoreSegment = this.docWriter.closeDocStore();
            success = true;
        }
        finally {
            if (!success && this.infoStream != null) {
                this.message("hit exception closing doc store segment");
            }
        }
        useCompoundDocStore = this.mergePolicy.useCompoundDocStore(this.segmentInfos);
        if (useCompoundDocStore && docStoreSegment != null && this.docWriter.closedFiles().size() != 0) {
            success = false;
            int numSegments = this.segmentInfos.size();
            String compoundFileName = docStoreSegment + "." + "cfx";
            try {
                CompoundFileWriter cfsWriter = new CompoundFileWriter(this.directory, compoundFileName);
                Iterator it = this.docWriter.closedFiles().iterator();
                while (it.hasNext()) {
                    cfsWriter.addFile((String)it.next());
                }
                cfsWriter.close();
                success = true;
            }
            finally {
                if (!success) {
                    if (this.infoStream != null) {
                        this.message("hit exception building compound file doc store for segment " + docStoreSegment);
                    }
                    this.deleter.deleteFile(compoundFileName);
                }
            }
            for (int i = 0; i < numSegments; ++i) {
                SegmentInfo si = this.segmentInfos.info(i);
                if (si.getDocStoreOffset() == -1 || !si.getDocStoreSegment().equals(docStoreSegment)) continue;
                si.setDocStoreIsCompoundFile(true);
            }
            this.checkpoint();
            this.deleter.deleteNewFiles(this.docWriter.closedFiles());
        }
        return useCompoundDocStore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            if (this.writeLock != null) {
                this.writeLock.release();
                this.writeLock = null;
            }
        }
        finally {
            super.finalize();
        }
    }

    public Directory getDirectory() {
        this.ensureOpen(false);
        return this.directory;
    }

    public Analyzer getAnalyzer() {
        this.ensureOpen();
        return this.analyzer;
    }

    public synchronized int docCount() {
        this.ensureOpen();
        return this.maxDoc();
    }

    public synchronized int maxDoc() {
        int count = this.docWriter != null ? this.docWriter.getNumDocsInRAM() : 0;
        for (int i = 0; i < this.segmentInfos.size(); ++i) {
            count += this.segmentInfos.info((int)i).docCount;
        }
        return count;
    }

    public synchronized int numDocs() throws IOException {
        int count = this.docWriter != null ? this.docWriter.getNumDocsInRAM() : 0;
        for (int i = 0; i < this.segmentInfos.size(); ++i) {
            SegmentInfo info = this.segmentInfos.info(i);
            count += info.docCount - info.getDelCount();
        }
        return count;
    }

    public synchronized boolean hasDeletions() throws IOException {
        this.ensureOpen();
        if (this.docWriter.hasDeletes()) {
            return true;
        }
        for (int i = 0; i < this.segmentInfos.size(); ++i) {
            if (!this.segmentInfos.info(i).hasDeletions()) continue;
            return true;
        }
        return false;
    }

    public void addDocument(Document doc) throws CorruptIndexException, IOException {
        this.addDocument(doc, this.analyzer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDocument(Document doc, Analyzer analyzer) throws CorruptIndexException, IOException {
        this.ensureOpen();
        boolean doFlush = false;
        boolean success = false;
        try {
            try {
                doFlush = this.docWriter.addDocument(doc, analyzer);
                success = true;
            }
            finally {
                if (!success) {
                    if (this.infoStream != null) {
                        this.message("hit exception adding document");
                    }
                    IndexWriter indexWriter = this;
                    synchronized (indexWriter) {
                        Collection files;
                        if (this.docWriter != null && (files = this.docWriter.abortedFiles()) != null) {
                            this.deleter.deleteNewFiles(files);
                        }
                    }
                }
            }
            if (doFlush) {
                this.flush(true, false, false);
            }
        }
        catch (OutOfMemoryError oom) {
            this.hitOOM = true;
            throw oom;
        }
    }

    public void deleteDocuments(Term term) throws CorruptIndexException, IOException {
        this.ensureOpen();
        try {
            boolean doFlush = this.docWriter.bufferDeleteTerm(term);
            if (doFlush) {
                this.flush(true, false, false);
            }
        }
        catch (OutOfMemoryError oom) {
            this.hitOOM = true;
            throw oom;
        }
    }

    public void deleteDocuments(Term[] terms) throws CorruptIndexException, IOException {
        this.ensureOpen();
        try {
            boolean doFlush = this.docWriter.bufferDeleteTerms(terms);
            if (doFlush) {
                this.flush(true, false, false);
            }
        }
        catch (OutOfMemoryError oom) {
            this.hitOOM = true;
            throw oom;
        }
    }

    public void deleteDocuments(Query query) throws CorruptIndexException, IOException {
        this.ensureOpen();
        boolean doFlush = this.docWriter.bufferDeleteQuery(query);
        if (doFlush) {
            this.flush(true, false, false);
        }
    }

    public void deleteDocuments(Query[] queries) throws CorruptIndexException, IOException {
        this.ensureOpen();
        boolean doFlush = this.docWriter.bufferDeleteQueries(queries);
        if (doFlush) {
            this.flush(true, false, false);
        }
    }

    public void updateDocument(Term term, Document doc) throws CorruptIndexException, IOException {
        this.ensureOpen();
        this.updateDocument(term, doc, this.getAnalyzer());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateDocument(Term term, Document doc, Analyzer analyzer) throws CorruptIndexException, IOException {
        this.ensureOpen();
        try {
            boolean doFlush = false;
            boolean success = false;
            try {
                doFlush = this.docWriter.updateDocument(term, doc, analyzer);
                success = true;
            }
            finally {
                if (!success) {
                    if (this.infoStream != null) {
                        this.message("hit exception updating document");
                    }
                    IndexWriter indexWriter = this;
                    synchronized (indexWriter) {
                        Collection files = this.docWriter.abortedFiles();
                        if (files != null) {
                            this.deleter.deleteNewFiles(files);
                        }
                    }
                }
            }
            if (doFlush) {
                this.flush(true, false, false);
            }
        }
        catch (OutOfMemoryError oom) {
            this.hitOOM = true;
            throw oom;
        }
    }

    final synchronized int getSegmentCount() {
        return this.segmentInfos.size();
    }

    final synchronized int getNumBufferedDocuments() {
        return this.docWriter.getNumDocsInRAM();
    }

    final synchronized int getDocCount(int i) {
        if (i >= 0 && i < this.segmentInfos.size()) {
            return this.segmentInfos.info((int)i).docCount;
        }
        return -1;
    }

    final synchronized int getFlushCount() {
        return this.flushCount;
    }

    final synchronized int getFlushDeletesCount() {
        return this.flushDeletesCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final String newSegmentName() {
        SegmentInfos segmentInfos = this.segmentInfos;
        synchronized (segmentInfos) {
            ++this.changeCount;
            return "_" + Integer.toString(this.segmentInfos.counter++, 36);
        }
    }

    public void optimize() throws CorruptIndexException, IOException {
        this.optimize(true);
    }

    public void optimize(int maxNumSegments) throws CorruptIndexException, IOException {
        this.optimize(maxNumSegments, true);
    }

    public void optimize(boolean doWait) throws CorruptIndexException, IOException {
        this.optimize(1, doWait);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void optimize(int maxNumSegments, boolean doWait) throws CorruptIndexException, IOException {
        MergePolicy.OneMerge merge;
        this.ensureOpen();
        if (maxNumSegments < 1) {
            throw new IllegalArgumentException("maxNumSegments must be >= 1; got " + maxNumSegments);
        }
        if (this.infoStream != null) {
            this.message("optimize: index now " + this.segString());
        }
        this.flush(true, false, true);
        IndexWriter indexWriter = this;
        synchronized (indexWriter) {
            this.resetMergeExceptions();
            this.segmentsToOptimize = new HashSet();
            int numSegments = this.segmentInfos.size();
            for (int i = 0; i < numSegments; ++i) {
                this.segmentsToOptimize.add(this.segmentInfos.info(i));
            }
            Iterator it = this.pendingMerges.iterator();
            while (it.hasNext()) {
                merge = (MergePolicy.OneMerge)it.next();
                merge.optimize = true;
                merge.maxNumSegmentsOptimize = maxNumSegments;
            }
            it = this.runningMerges.iterator();
            while (it.hasNext()) {
                merge = (MergePolicy.OneMerge)it.next();
                merge.optimize = true;
                merge.maxNumSegmentsOptimize = maxNumSegments;
            }
        }
        this.maybeMerge(maxNumSegments, true);
        if (doWait) {
            indexWriter = this;
            synchronized (indexWriter) {
                while (true) {
                    if (this.mergeExceptions.size() > 0) {
                        int size = this.mergeExceptions.size();
                        for (int i = 0; i < size; ++i) {
                            merge = (MergePolicy.OneMerge)this.mergeExceptions.get(0);
                            if (!merge.optimize) continue;
                            IOException err = new IOException("background merge hit exception: " + merge.segString(this.directory));
                            Throwable t = merge.getException();
                            if (t != null) {
                                err.initCause(t);
                            }
                            throw err;
                        }
                    }
                    if (!this.optimizeMergesPending()) break;
                    this.doWait();
                }
            }
            this.ensureOpen();
        }
    }

    private synchronized boolean optimizeMergesPending() {
        Iterator it = this.pendingMerges.iterator();
        while (it.hasNext()) {
            if (!((MergePolicy.OneMerge)it.next()).optimize) continue;
            return true;
        }
        it = this.runningMerges.iterator();
        while (it.hasNext()) {
            if (!((MergePolicy.OneMerge)it.next()).optimize) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void expungeDeletes(boolean doWait) throws CorruptIndexException, IOException {
        MergePolicy.MergeSpecification spec;
        this.ensureOpen();
        if (this.infoStream != null) {
            this.message("expungeDeletes: index now " + this.segString());
        }
        IndexWriter indexWriter = this;
        synchronized (indexWriter) {
            spec = this.mergePolicy.findMergesToExpungeDeletes(this.segmentInfos, this);
            if (spec != null) {
                int numMerges = spec.merges.size();
                for (int i = 0; i < numMerges; ++i) {
                    this.registerMerge((MergePolicy.OneMerge)spec.merges.get(i));
                }
            }
        }
        this.mergeScheduler.merge(this);
        if (spec != null && doWait) {
            int numMerges = spec.merges.size();
            IndexWriter indexWriter2 = this;
            synchronized (indexWriter2) {
                boolean running = true;
                while (running) {
                    running = false;
                    for (int i = 0; i < numMerges; ++i) {
                        Throwable t;
                        MergePolicy.OneMerge merge = (MergePolicy.OneMerge)spec.merges.get(i);
                        if (this.pendingMerges.contains(merge) || this.runningMerges.contains(merge)) {
                            running = true;
                        }
                        if ((t = merge.getException()) == null) continue;
                        IOException ioe = new IOException("background merge hit exception: " + merge.segString(this.directory));
                        ioe.initCause(t);
                        throw ioe;
                    }
                    if (!running) continue;
                    this.doWait();
                }
            }
        }
    }

    public void expungeDeletes() throws CorruptIndexException, IOException {
        this.expungeDeletes(true);
    }

    public final void maybeMerge() throws CorruptIndexException, IOException {
        this.maybeMerge(false);
    }

    private final void maybeMerge(boolean optimize) throws CorruptIndexException, IOException {
        this.maybeMerge(1, optimize);
    }

    private final void maybeMerge(int maxNumSegmentsOptimize, boolean optimize) throws CorruptIndexException, IOException {
        this.updatePendingMerges(maxNumSegmentsOptimize, optimize);
        this.mergeScheduler.merge(this);
    }

    private synchronized void updatePendingMerges(int maxNumSegmentsOptimize, boolean optimize) throws CorruptIndexException, IOException {
        int i;
        int numMerges;
        MergePolicy.MergeSpecification spec;
        if (!$assertionsDisabled && optimize && maxNumSegmentsOptimize <= 0) {
            throw new AssertionError();
        }
        if (this.stopMerges) {
            return;
        }
        if (optimize) {
            spec = this.mergePolicy.findMergesForOptimize(this.segmentInfos, this, maxNumSegmentsOptimize, this.segmentsToOptimize);
            if (spec != null) {
                numMerges = spec.merges.size();
                for (i = 0; i < numMerges; ++i) {
                    MergePolicy.OneMerge merge = (MergePolicy.OneMerge)spec.merges.get(i);
                    merge.optimize = true;
                    merge.maxNumSegmentsOptimize = maxNumSegmentsOptimize;
                }
            }
        } else {
            spec = this.mergePolicy.findMerges(this.segmentInfos, this);
        }
        if (spec != null) {
            numMerges = spec.merges.size();
            for (i = 0; i < numMerges; ++i) {
                this.registerMerge((MergePolicy.OneMerge)spec.merges.get(i));
            }
        }
    }

    synchronized MergePolicy.OneMerge getNextMerge() {
        if (this.pendingMerges.size() == 0) {
            return null;
        }
        MergePolicy.OneMerge merge = (MergePolicy.OneMerge)this.pendingMerges.removeFirst();
        this.runningMerges.add(merge);
        return merge;
    }

    private synchronized MergePolicy.OneMerge getNextExternalMerge() {
        if (this.pendingMerges.size() == 0) {
            return null;
        }
        Iterator it = this.pendingMerges.iterator();
        while (it.hasNext()) {
            MergePolicy.OneMerge merge = (MergePolicy.OneMerge)it.next();
            if (!merge.isExternal) continue;
            it.remove();
            this.runningMerges.add(merge);
            return merge;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void startTransaction(boolean haveWriteLock) throws IOException {
        boolean success = false;
        try {
            if (this.infoStream != null) {
                this.message("now start transaction");
            }
            if (!$assertionsDisabled && this.docWriter.getNumBufferedDeleteTerms() != 0) {
                throw new AssertionError((Object)("calling startTransaction with buffered delete terms not supported: numBufferedDeleteTerms=" + this.docWriter.getNumBufferedDeleteTerms()));
            }
            if (!$assertionsDisabled && this.docWriter.getNumDocsInRAM() != 0) {
                throw new AssertionError((Object)("calling startTransaction with buffered documents not supported: numDocsInRAM=" + this.docWriter.getNumDocsInRAM()));
            }
            this.ensureOpen();
            IndexWriter indexWriter = this;
            synchronized (indexWriter) {
                while (this.stopMerges) {
                    this.doWait();
                }
            }
            success = true;
        }
        finally {
            if (!success && haveWriteLock) {
                this.releaseWrite();
            }
        }
        if (!haveWriteLock) {
            this.acquireWrite();
        }
        success = false;
        try {
            this.localRollbackSegmentInfos = (SegmentInfos)this.segmentInfos.clone();
            if (!$assertionsDisabled && this.hasExternalSegments(this.segmentInfos)) {
                throw new AssertionError();
            }
            this.localAutoCommit = this.autoCommit;
            this.localFlushedDocCount = this.docWriter.getFlushedDocCount();
            if (this.localAutoCommit) {
                if (this.infoStream != null) {
                    this.message("flush at startTransaction");
                }
                this.flush(true, false, false);
                this.autoCommit = false;
            } else {
                this.deleter.incRef(this.segmentInfos, false);
            }
            success = true;
        }
        finally {
            if (!success) {
                this.finishAddIndexes();
            }
        }
    }

    private synchronized void rollbackTransaction() throws IOException {
        if (this.infoStream != null) {
            this.message("now rollback transaction");
        }
        this.autoCommit = this.localAutoCommit;
        this.docWriter.setFlushedDocCount(this.localFlushedDocCount);
        this.finishMerges(false);
        this.segmentInfos.clear();
        this.segmentInfos.addAll(this.localRollbackSegmentInfos);
        this.localRollbackSegmentInfos = null;
        this.finishAddIndexes();
        this.deleter.checkpoint(this.segmentInfos, false);
        if (!this.autoCommit) {
            this.deleter.decRef(this.segmentInfos);
        }
        this.deleter.refresh();
        this.notifyAll();
        if (!$assertionsDisabled && this.hasExternalSegments()) {
            throw new AssertionError();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void commitTransaction() throws IOException {
        if (this.infoStream != null) {
            this.message("now commit transaction");
        }
        this.autoCommit = this.localAutoCommit;
        this.checkpoint();
        if (this.autoCommit) {
            boolean success = false;
            try {
                this.commit(0L);
                success = true;
            }
            finally {
                if (!success) {
                    if (this.infoStream != null) {
                        this.message("hit exception committing transaction");
                    }
                    this.rollbackTransaction();
                }
            }
        } else {
            this.deleter.decRef(this.localRollbackSegmentInfos);
        }
        this.localRollbackSegmentInfos = null;
        if (!$assertionsDisabled && this.hasExternalSegments()) {
            throw new AssertionError();
        }
        this.finishAddIndexes();
    }

    public void abort() throws IOException {
        this.rollback();
    }

    public void rollback() throws IOException {
        this.ensureOpen();
        if (this.autoCommit) {
            throw new IllegalStateException("rollback() can only be called when IndexWriter was opened with autoCommit=false");
        }
        if (this.shouldClose()) {
            this.rollbackInternal();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rollbackInternal() throws IOException {
        boolean success = false;
        this.docWriter.pauseAllThreads();
        try {
            this.finishMerges(false);
            this.mergePolicy.close();
            this.mergeScheduler.close();
            IndexWriter indexWriter = this;
            synchronized (indexWriter) {
                if (this.pendingCommit != null) {
                    this.pendingCommit.rollbackCommit(this.directory);
                    this.deleter.decRef(this.pendingCommit);
                    this.pendingCommit = null;
                    this.notifyAll();
                }
                this.segmentInfos.clear();
                this.segmentInfos.addAll(this.rollbackSegmentInfos);
                if (!$assertionsDisabled && this.hasExternalSegments()) {
                    throw new AssertionError();
                }
                this.docWriter.abort();
                if (!$assertionsDisabled && !this.testPoint("rollback before checkpoint")) {
                    throw new AssertionError();
                }
                this.deleter.checkpoint(this.segmentInfos, false);
                this.deleter.refresh();
            }
            this.lastCommitChangeCount = this.changeCount;
            success = true;
        }
        catch (OutOfMemoryError oom) {
            this.hitOOM = true;
            throw oom;
        }
        finally {
            IndexWriter indexWriter = this;
            synchronized (indexWriter) {
                if (!success) {
                    this.docWriter.resumeAllThreads();
                    this.closing = false;
                    this.notifyAll();
                    if (this.infoStream != null) {
                        this.message("hit exception during rollback");
                    }
                }
            }
        }
        this.closeInternal(false);
    }

    private synchronized void finishMerges(boolean waitForMerges) throws IOException {
        if (!waitForMerges) {
            MergePolicy.OneMerge merge;
            this.stopMerges = true;
            Iterator it = this.pendingMerges.iterator();
            while (it.hasNext()) {
                merge = (MergePolicy.OneMerge)it.next();
                if (this.infoStream != null) {
                    this.message("now abort pending merge " + merge.segString(this.directory));
                }
                merge.abort();
                this.mergeFinish(merge);
            }
            this.pendingMerges.clear();
            it = this.runningMerges.iterator();
            while (it.hasNext()) {
                merge = (MergePolicy.OneMerge)it.next();
                if (this.infoStream != null) {
                    this.message("now abort running merge " + merge.segString(this.directory));
                }
                merge.abort();
            }
            this.acquireRead();
            this.releaseRead();
            while (this.runningMerges.size() > 0) {
                if (this.infoStream != null) {
                    this.message("now wait for " + this.runningMerges.size() + " running merge to abort");
                }
                this.doWait();
            }
            this.stopMerges = false;
            this.notifyAll();
            if (!$assertionsDisabled && 0 != this.mergingSegments.size()) {
                throw new AssertionError();
            }
            if (this.infoStream != null) {
                this.message("all running merges have aborted");
            }
        } else {
            this.acquireRead();
            this.releaseRead();
            while (this.pendingMerges.size() > 0 || this.runningMerges.size() > 0) {
                this.doWait();
            }
            if (!$assertionsDisabled && 0 != this.mergingSegments.size()) {
                throw new AssertionError();
            }
        }
    }

    private synchronized void checkpoint() throws IOException {
        ++this.changeCount;
        this.deleter.checkpoint(this.segmentInfos, false);
    }

    private void finishAddIndexes() {
        this.releaseWrite();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void blockAddIndexes(boolean includePendingClose) {
        this.acquireRead();
        boolean success = false;
        try {
            this.ensureOpen(includePendingClose);
            success = true;
        }
        finally {
            if (!success) {
                this.releaseRead();
            }
        }
    }

    private void resumeAddIndexes() {
        this.releaseRead();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addIndexes(Directory[] dirs) throws CorruptIndexException, IOException {
        this.ensureOpen();
        this.noDupDirs(dirs);
        this.docWriter.pauseAllThreads();
        try {
            if (this.infoStream != null) {
                this.message("flush at addIndexes");
            }
            this.flush(true, false, true);
            boolean success = false;
            this.startTransaction(false);
            try {
                int docCount = 0;
                IndexWriter indexWriter = this;
                synchronized (indexWriter) {
                    this.ensureOpen();
                    for (int i = 0; i < dirs.length; ++i) {
                        SegmentInfos sis = new SegmentInfos();
                        sis.read(dirs[i]);
                        for (int j = 0; j < sis.size(); ++j) {
                            SegmentInfo info = sis.info(j);
                            docCount += info.docCount;
                            if (!$assertionsDisabled && this.segmentInfos.contains(info)) {
                                throw new AssertionError();
                            }
                            this.segmentInfos.add(info);
                        }
                    }
                }
                this.docWriter.updateFlushedDocCount(docCount);
                this.optimize();
                success = true;
            }
            finally {
                if (success) {
                    this.commitTransaction();
                } else {
                    this.rollbackTransaction();
                }
            }
        }
        catch (OutOfMemoryError oom) {
            this.hitOOM = true;
            throw oom;
        }
        finally {
            this.docWriter.resumeAllThreads();
        }
    }

    private synchronized void resetMergeExceptions() {
        this.mergeExceptions = new ArrayList();
        ++this.mergeGen;
    }

    private void noDupDirs(Directory[] dirs) {
        HashSet<Directory> dups = new HashSet<Directory>();
        for (int i = 0; i < dirs.length; ++i) {
            if (dups.contains(dirs[i])) {
                throw new IllegalArgumentException("Directory " + dirs[i] + " appears more than once");
            }
            if (dirs[i] == this.directory) {
                throw new IllegalArgumentException("Cannot add directory to itself");
            }
            dups.add(dirs[i]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addIndexesNoOptimize(Directory[] dirs) throws CorruptIndexException, IOException {
        this.ensureOpen();
        this.noDupDirs(dirs);
        this.docWriter.pauseAllThreads();
        try {
            if (this.infoStream != null) {
                this.message("flush at addIndexesNoOptimize");
            }
            this.flush(true, false, true);
            boolean success = false;
            this.startTransaction(false);
            try {
                int docCount = 0;
                IndexWriter indexWriter = this;
                synchronized (indexWriter) {
                    this.ensureOpen();
                    for (int i = 0; i < dirs.length; ++i) {
                        if (this.directory == dirs[i]) {
                            throw new IllegalArgumentException("Cannot add this index to itself");
                        }
                        SegmentInfos sis = new SegmentInfos();
                        sis.read(dirs[i]);
                        for (int j = 0; j < sis.size(); ++j) {
                            SegmentInfo info = sis.info(j);
                            if (!$assertionsDisabled && this.segmentInfos.contains(info)) {
                                throw new AssertionError((Object)("dup info dir=" + info.dir + " name=" + info.name));
                            }
                            docCount += info.docCount;
                            this.segmentInfos.add(info);
                        }
                    }
                }
                this.docWriter.updateFlushedDocCount(docCount);
                this.maybeMerge();
                this.ensureOpen();
                this.resolveExternalSegments();
                this.ensureOpen();
                success = true;
            }
            finally {
                if (success) {
                    this.commitTransaction();
                } else {
                    this.rollbackTransaction();
                }
            }
        }
        catch (OutOfMemoryError oom) {
            this.hitOOM = true;
            throw oom;
        }
        finally {
            this.docWriter.resumeAllThreads();
        }
    }

    private boolean hasExternalSegments() {
        return this.hasExternalSegments(this.segmentInfos);
    }

    private boolean hasExternalSegments(SegmentInfos infos) {
        int numSegments = infos.size();
        for (int i = 0; i < numSegments; ++i) {
            if (infos.info((int)i).dir == this.directory) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resolveExternalSegments() throws CorruptIndexException, IOException {
        boolean any = false;
        boolean done = false;
        while (!done) {
            SegmentInfo info = null;
            MergePolicy.OneMerge merge = null;
            IndexWriter indexWriter = this;
            synchronized (indexWriter) {
                if (this.stopMerges) {
                    throw new MergePolicy.MergeAbortedException("rollback() was called or addIndexes* hit an unhandled exception");
                }
                int numSegments = this.segmentInfos.size();
                done = true;
                for (int i = 0; i < numSegments; ++i) {
                    info = this.segmentInfos.info(i);
                    if (info.dir == this.directory) continue;
                    done = false;
                    MergePolicy.OneMerge newMerge = new MergePolicy.OneMerge(this.segmentInfos.range(i, 1 + i), info.getUseCompoundFile());
                    if (!this.registerMerge(newMerge)) continue;
                    merge = newMerge;
                    this.pendingMerges.remove(merge);
                    this.runningMerges.add(merge);
                    break;
                }
                if (!done && merge == null) {
                    merge = this.getNextExternalMerge();
                }
                if (!done && merge == null) {
                    this.doWait();
                }
            }
            if (merge == null) continue;
            any = true;
            this.merge(merge);
        }
        if (any) {
            this.mergeScheduler.merge(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addIndexes(IndexReader[] readers) throws CorruptIndexException, IOException {
        block44: {
            this.ensureOpen();
            this.docWriter.pauseAllThreads();
            this.acquireWrite();
            try {
                boolean success = false;
                SegmentInfo info = null;
                String mergedName = null;
                SegmentMerger merger = null;
                try {
                    this.flush(true, false, true);
                    this.optimize();
                    success = true;
                }
                finally {
                    if (!success) {
                        this.releaseWrite();
                    }
                }
                this.startTransaction(true);
                try {
                    mergedName = this.newSegmentName();
                    merger = new SegmentMerger(this, mergedName, null);
                    SegmentReader sReader = null;
                    IndexWriter indexWriter = this;
                    synchronized (indexWriter) {
                        if (this.segmentInfos.size() == 1) {
                            sReader = SegmentReader.get(true, this.segmentInfos.info(0));
                        }
                    }
                    try {
                        if (sReader != null) {
                            merger.add(sReader);
                        }
                        for (int i = 0; i < readers.length; ++i) {
                            merger.add(readers[i]);
                        }
                        int docCount = merger.merge();
                        if (sReader != null) {
                            sReader.close();
                            sReader = null;
                        }
                        IndexWriter indexWriter2 = this;
                        synchronized (indexWriter2) {
                            this.segmentInfos.clear();
                            info = new SegmentInfo(mergedName, docCount, this.directory, false, true, -1, null, false, merger.hasProx());
                            this.segmentInfos.add(info);
                        }
                        this.docWriter.updateFlushedDocCount(docCount);
                        success = true;
                    }
                    finally {
                        if (sReader != null) {
                            sReader.close();
                        }
                    }
                }
                finally {
                    if (!success) {
                        if (this.infoStream != null) {
                            this.message("hit exception in addIndexes during merge");
                        }
                        this.rollbackTransaction();
                    } else {
                        this.commitTransaction();
                    }
                }
                if (!(this.mergePolicy instanceof LogMergePolicy) || !this.getUseCompoundFile()) break block44;
                List files = null;
                IndexWriter indexWriter = this;
                synchronized (indexWriter) {
                    if (this.segmentInfos.contains(info)) {
                        files = info.files();
                        this.deleter.incRef(files);
                    }
                }
                if (files == null) break block44;
                success = false;
                this.startTransaction(false);
                try {
                    merger.createCompoundFile(mergedName + ".cfs");
                    indexWriter = this;
                    synchronized (indexWriter) {
                        info.setUseCompoundFile(true);
                    }
                    success = true;
                }
                finally {
                    this.deleter.decRef(files);
                    if (!success) {
                        if (this.infoStream != null) {
                            this.message("hit exception building compound file in addIndexes during merge");
                        }
                        this.rollbackTransaction();
                    } else {
                        this.commitTransaction();
                    }
                }
            }
            catch (OutOfMemoryError oom) {
                this.hitOOM = true;
                throw oom;
            }
            finally {
                this.docWriter.resumeAllThreads();
            }
        }
    }

    void doAfterFlush() throws IOException {
    }

    public final void flush() throws CorruptIndexException, IOException {
        this.flush(true, false, true);
    }

    public final void prepareCommit() throws CorruptIndexException, IOException {
        this.ensureOpen();
        this.prepareCommit(false);
    }

    private final void prepareCommit(boolean internal) throws CorruptIndexException, IOException {
        if (this.hitOOM) {
            throw new IllegalStateException("this writer hit an OutOfMemoryError; cannot commit");
        }
        if (this.autoCommit && !internal) {
            throw new IllegalStateException("this method can only be used when autoCommit is false");
        }
        if (!this.autoCommit && this.pendingCommit != null) {
            throw new IllegalStateException("prepareCommit was already called with no corresponding call to commit");
        }
        this.message("prepareCommit: flush");
        this.flush(true, true, true);
        this.startCommit(0L);
    }

    private void commit(long sizeInBytes) throws IOException {
        this.startCommit(sizeInBytes);
        this.finishCommit();
    }

    private synchronized void waitForCommit() {
        while (this.committing) {
            this.doWait();
        }
        this.committing = true;
    }

    private synchronized void doneCommit() {
        this.committing = false;
        this.notifyAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void commit() throws CorruptIndexException, IOException {
        this.ensureOpen();
        this.waitForCommit();
        try {
            this.message("commit: start");
            if (this.autoCommit || this.pendingCommit == null) {
                this.message("commit: now prepare");
                this.prepareCommit(true);
            } else {
                this.message("commit: already prepared");
            }
            this.finishCommit();
        }
        finally {
            this.doneCommit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final synchronized void finishCommit() throws CorruptIndexException, IOException {
        if (this.pendingCommit != null) {
            try {
                this.message("commit: pendingCommit != null");
                this.pendingCommit.finishCommit(this.directory);
                this.lastCommitChangeCount = this.pendingCommitChangeCount;
                this.segmentInfos.updateGeneration(this.pendingCommit);
                this.setRollbackSegmentInfos(this.pendingCommit);
                this.deleter.checkpoint(this.pendingCommit, true);
            }
            finally {
                this.deleter.decRef(this.pendingCommit);
                this.pendingCommit = null;
                this.notifyAll();
            }
        } else {
            this.message("commit: pendingCommit == null; skip");
        }
        this.message("commit: done");
    }

    protected final void flush(boolean triggerMerge, boolean flushDocStores, boolean flushDeletes) throws CorruptIndexException, IOException {
        this.ensureOpen(false);
        if (this.doFlush(flushDocStores, flushDeletes) && triggerMerge) {
            this.maybeMerge();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final synchronized boolean doFlush(boolean flushDocStores, boolean flushDeletes) throws CorruptIndexException, IOException {
        this.ensureOpen(false);
        if (!$assertionsDisabled && !this.testPoint("startDoFlush")) {
            throw new AssertionError();
        }
        ++this.flushCount;
        flushDeletes |= this.docWriter.deletesFull();
        flushDeletes |= this.autoCommit;
        if (this.docWriter.pauseAllThreads()) {
            this.docWriter.resumeAllThreads();
            return false;
        }
        try {
            boolean success;
            SegmentInfo newSegment = null;
            int numDocs = this.docWriter.getNumDocsInRAM();
            boolean flushDocs = numDocs > 0;
            flushDocStores |= this.autoCommit;
            String docStoreSegment = this.docWriter.getDocStoreSegment();
            if (docStoreSegment == null) {
                flushDocStores = false;
            }
            int docStoreOffset = this.docWriter.getDocStoreOffset();
            if (!$assertionsDisabled && this.autoCommit && 0 != docStoreOffset) {
                throw new AssertionError();
            }
            boolean docStoreIsCompoundFile = false;
            if (this.infoStream != null) {
                this.message("  flush: segment=" + this.docWriter.getSegment() + " docStoreSegment=" + this.docWriter.getDocStoreSegment() + " docStoreOffset=" + docStoreOffset + " flushDocs=" + flushDocs + " flushDeletes=" + flushDeletes + " flushDocStores=" + flushDocStores + " numDocs=" + numDocs + " numBufDelTerms=" + this.docWriter.getNumBufferedDeleteTerms());
                this.message("  index before flush " + this.segString());
            }
            if (!(!flushDocStores || flushDocs && this.docWriter.getSegment().equals(this.docWriter.getDocStoreSegment()))) {
                if (this.infoStream != null) {
                    this.message("  flush shared docStore segment " + docStoreSegment);
                }
                docStoreIsCompoundFile = this.flushDocStores();
                flushDocStores = false;
            }
            String segment = this.docWriter.getSegment();
            if (!$assertionsDisabled && segment == null && flushDocs) {
                throw new AssertionError();
            }
            if (flushDocs) {
                int flushedDocCount;
                success = false;
                try {
                    flushedDocCount = this.docWriter.flush(flushDocStores);
                    success = true;
                }
                finally {
                    if (!success) {
                        if (this.infoStream != null) {
                            this.message("hit exception flushing segment " + segment);
                        }
                        this.deleter.refresh(segment);
                    }
                }
                if (0 == docStoreOffset && flushDocStores) {
                    if (!$assertionsDisabled && docStoreSegment == null) {
                        throw new AssertionError();
                    }
                    if (!$assertionsDisabled && !docStoreSegment.equals(segment)) {
                        throw new AssertionError();
                    }
                    docStoreOffset = -1;
                    docStoreIsCompoundFile = false;
                    docStoreSegment = null;
                }
                newSegment = new SegmentInfo(segment, flushedDocCount, this.directory, false, true, docStoreOffset, docStoreSegment, docStoreIsCompoundFile, this.docWriter.hasProx());
            }
            this.docWriter.pushDeletes();
            if (flushDocs) {
                this.segmentInfos.add(newSegment);
            }
            if (flushDeletes) {
                ++this.flushDeletesCount;
                this.applyDeletes();
            }
            this.doAfterFlush();
            if (flushDocs) {
                this.checkpoint();
            }
            if (flushDocs && this.mergePolicy.useCompoundFile(this.segmentInfos, newSegment)) {
                success = false;
                try {
                    this.docWriter.createCompoundFile(segment);
                    success = true;
                }
                finally {
                    if (!success) {
                        if (this.infoStream != null) {
                            this.message("hit exception creating compound file for newly flushed segment " + segment);
                        }
                        this.deleter.deleteFile(segment + "." + "cfs");
                    }
                }
                newSegment.setUseCompoundFile(true);
                this.checkpoint();
            }
            boolean bl = flushDocs;
            return bl;
        }
        catch (OutOfMemoryError oom) {
            this.hitOOM = true;
            throw oom;
        }
        finally {
            this.docWriter.clearFlushPending();
            this.docWriter.resumeAllThreads();
        }
    }

    public final long ramSizeInBytes() {
        this.ensureOpen();
        return this.docWriter.getRAMUsed();
    }

    public final synchronized int numRamDocs() {
        this.ensureOpen();
        return this.docWriter.getNumDocsInRAM();
    }

    private int ensureContiguousMerge(MergePolicy.OneMerge merge) {
        int first = this.segmentInfos.indexOf(merge.segments.info(0));
        if (first == -1) {
            throw new MergePolicy.MergeException("could not find segment " + merge.segments.info((int)0).name + " in current segments", this.directory);
        }
        int numSegments = this.segmentInfos.size();
        int numSegmentsToMerge = merge.segments.size();
        for (int i = 0; i < numSegmentsToMerge; ++i) {
            SegmentInfo info = merge.segments.info(i);
            if (first + i < numSegments && this.segmentInfos.info(first + i).equals(info)) continue;
            if (this.segmentInfos.indexOf(info) == -1) {
                throw new MergePolicy.MergeException("MergePolicy selected a segment (" + info.name + ") that is not in the index", this.directory);
            }
            throw new MergePolicy.MergeException("MergePolicy selected non-contiguous segments to merge (" + merge.segString(this.directory) + " vs " + this.segString() + "), which IndexWriter (currently) cannot handle", this.directory);
        }
        return first;
    }

    private synchronized void commitMergedDeletes(MergePolicy.OneMerge merge) throws IOException {
        if (!$assertionsDisabled && !this.testPoint("startCommitMergeDeletes")) {
            throw new AssertionError();
        }
        SegmentInfos sourceSegmentsClone = merge.segmentsClone;
        SegmentInfos sourceSegments = merge.segments;
        if (this.infoStream != null) {
            this.message("commitMergeDeletes " + merge.segString(this.directory));
        }
        BitVector deletes = null;
        int docUpto = 0;
        int delCount = 0;
        int numSegmentsToMerge = sourceSegments.size();
        for (int i = 0; i < numSegmentsToMerge; ++i) {
            SegmentInfo previousInfo = sourceSegmentsClone.info(i);
            SegmentInfo currentInfo = sourceSegments.info(i);
            if (!$assertionsDisabled && currentInfo.docCount != previousInfo.docCount) {
                throw new AssertionError();
            }
            int docCount = currentInfo.docCount;
            if (previousInfo.hasDeletions()) {
                if (!$assertionsDisabled && !currentInfo.hasDeletions()) {
                    throw new AssertionError();
                }
                BitVector previousDeletes = new BitVector(previousInfo.dir, previousInfo.getDelFileName());
                if (!currentInfo.getDelFileName().equals(previousInfo.getDelFileName())) {
                    if (deletes == null) {
                        deletes = new BitVector(merge.info.docCount);
                    }
                    BitVector currentDeletes = new BitVector(currentInfo.dir, currentInfo.getDelFileName());
                    for (int j = 0; j < docCount; ++j) {
                        if (previousDeletes.get(j)) {
                            if (!$assertionsDisabled && !currentDeletes.get(j)) {
                                throw new AssertionError();
                            }
                            continue;
                        }
                        if (currentDeletes.get(j)) {
                            deletes.set(docUpto);
                            ++delCount;
                        }
                        ++docUpto;
                    }
                    continue;
                }
                docUpto += docCount - previousDeletes.count();
                continue;
            }
            if (currentInfo.hasDeletions()) {
                if (deletes == null) {
                    deletes = new BitVector(merge.info.docCount);
                }
                BitVector currentDeletes = new BitVector(this.directory, currentInfo.getDelFileName());
                for (int j = 0; j < docCount; ++j) {
                    if (currentDeletes.get(j)) {
                        deletes.set(docUpto);
                        ++delCount;
                    }
                    ++docUpto;
                }
                continue;
            }
            docUpto += currentInfo.docCount;
        }
        if (deletes != null) {
            merge.info.advanceDelGen();
            this.message("commit merge deletes to " + merge.info.getDelFileName());
            deletes.write(this.directory, merge.info.getDelFileName());
            merge.info.setDelCount(delCount);
            if (!$assertionsDisabled && delCount != deletes.count()) {
                throw new AssertionError();
            }
        }
    }

    private synchronized boolean commitMerge(MergePolicy.OneMerge merge, SegmentMerger merger, int mergedDocCount) throws IOException {
        if (!$assertionsDisabled && !this.testPoint("startCommitMerge")) {
            throw new AssertionError();
        }
        if (this.hitOOM) {
            return false;
        }
        if (this.infoStream != null) {
            this.message("commitMerge: " + merge.segString(this.directory) + " index=" + this.segString());
        }
        if (!$assertionsDisabled && !merge.registerDone) {
            throw new AssertionError();
        }
        if (merge.isAborted()) {
            if (this.infoStream != null) {
                this.message("commitMerge: skipping merge " + merge.segString(this.directory) + ": it was aborted");
            }
            this.deleter.refresh(merge.info.name);
            return false;
        }
        int start = this.ensureContiguousMerge(merge);
        this.commitMergedDeletes(merge);
        this.docWriter.remapDeletes(this.segmentInfos, merger.getDocMaps(), merger.getDelCounts(), merge, mergedDocCount);
        String mergeDocStoreSegment = merge.info.getDocStoreSegment();
        if (mergeDocStoreSegment != null && !merge.info.getDocStoreIsCompoundFile()) {
            int size = this.segmentInfos.size();
            for (int i = 0; i < size; ++i) {
                SegmentInfo info = this.segmentInfos.info(i);
                String docStoreSegment = info.getDocStoreSegment();
                if (docStoreSegment == null || !docStoreSegment.equals(mergeDocStoreSegment) || !info.getDocStoreIsCompoundFile()) continue;
                merge.info.setDocStoreIsCompoundFile(true);
                break;
            }
        }
        merge.info.setHasProx(merger.hasProx());
        this.segmentInfos.subList(start, start + merge.segments.size()).clear();
        if (!$assertionsDisabled && this.segmentInfos.contains(merge.info)) {
            throw new AssertionError();
        }
        this.segmentInfos.add(start, merge.info);
        this.checkpoint();
        this.decrefMergeSegments(merge);
        if (merge.optimize) {
            this.segmentsToOptimize.add(merge.info);
        }
        return true;
    }

    private void decrefMergeSegments(MergePolicy.OneMerge merge) throws IOException {
        SegmentInfos sourceSegmentsClone = merge.segmentsClone;
        int numSegmentsToMerge = sourceSegmentsClone.size();
        if (!$assertionsDisabled && !merge.increfDone) {
            throw new AssertionError();
        }
        merge.increfDone = false;
        for (int i = 0; i < numSegmentsToMerge; ++i) {
            SegmentInfo previousInfo = sourceSegmentsClone.info(i);
            if (previousInfo.dir != this.directory) continue;
            this.deleter.decRef(previousInfo.files());
        }
    }

    private final void handleMergeException(Throwable t, MergePolicy.OneMerge merge) throws IOException {
        merge.setException(t);
        this.addMergeException(merge);
        if (t instanceof MergePolicy.MergeAbortedException) {
            if (merge.isExternal) {
                throw (MergePolicy.MergeAbortedException)t;
            }
        } else {
            if (t instanceof IOException) {
                throw (IOException)t;
            }
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            if (t instanceof Error) {
                throw (Error)t;
            }
            throw new RuntimeException(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void merge(MergePolicy.OneMerge merge) throws CorruptIndexException, IOException {
        boolean success = false;
        try {
            IndexWriter indexWriter;
            try {
                try {
                    this.mergeInit(merge);
                    if (this.infoStream != null) {
                        this.message("now merge\n  merge=" + merge.segString(this.directory) + "\n  merge=" + merge + "\n  index=" + this.segString());
                    }
                    this.mergeMiddle(merge);
                    success = true;
                }
                catch (Throwable t) {
                    this.handleMergeException(t, merge);
                }
                Object var5_5 = null;
                indexWriter = this;
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                IndexWriter indexWriter2 = this;
                synchronized (indexWriter2) {
                    try {
                        this.mergeFinish(merge);
                        if (!success) {
                            if (this.infoStream != null) {
                                this.message("hit exception during merge");
                            }
                            if (merge.info != null && !this.segmentInfos.contains(merge.info)) {
                                this.deleter.refresh(merge.info.name);
                            }
                        }
                        if (success && !merge.isAborted() && !this.closed && !this.closing) {
                            this.updatePendingMerges(merge.maxNumSegmentsOptimize, merge.optimize);
                        }
                        Object var8_11 = null;
                        this.runningMerges.remove(merge);
                    }
                    catch (Throwable throwable2) {
                        Object var8_12 = null;
                        this.runningMerges.remove(merge);
                        throw throwable2;
                    }
                }
                throw throwable;
            }
            synchronized (indexWriter) {
                try {
                    this.mergeFinish(merge);
                    if (!success) {
                        if (this.infoStream != null) {
                            this.message("hit exception during merge");
                        }
                        if (merge.info != null && !this.segmentInfos.contains(merge.info)) {
                            this.deleter.refresh(merge.info.name);
                        }
                    }
                    if (success && !merge.isAborted() && !this.closed && !this.closing) {
                        this.updatePendingMerges(merge.maxNumSegmentsOptimize, merge.optimize);
                    }
                    Object var8_9 = null;
                    this.runningMerges.remove(merge);
                }
                catch (Throwable throwable) {
                    Object var8_10 = null;
                    this.runningMerges.remove(merge);
                    throw throwable;
                }
            }
        }
        catch (OutOfMemoryError oom) {
            this.hitOOM = true;
            throw oom;
        }
    }

    final synchronized boolean registerMerge(MergePolicy.OneMerge merge) throws MergePolicy.MergeAbortedException {
        int i;
        if (merge.registerDone) {
            return true;
        }
        if (this.stopMerges) {
            merge.abort();
            throw new MergePolicy.MergeAbortedException("merge is aborted: " + merge.segString(this.directory));
        }
        int count = merge.segments.size();
        boolean isExternal = false;
        for (i = 0; i < count; ++i) {
            SegmentInfo info = merge.segments.info(i);
            if (this.mergingSegments.contains(info)) {
                return false;
            }
            if (this.segmentInfos.indexOf(info) == -1) {
                return false;
            }
            if (info.dir == this.directory) continue;
            isExternal = true;
        }
        this.ensureContiguousMerge(merge);
        this.pendingMerges.add(merge);
        if (this.infoStream != null) {
            this.message("add merge to pendingMerges: " + merge.segString(this.directory) + " [total " + this.pendingMerges.size() + " pending]");
        }
        merge.mergeGen = this.mergeGen;
        merge.isExternal = isExternal;
        for (i = 0; i < count; ++i) {
            this.mergingSegments.add(merge.segments.info(i));
        }
        merge.registerDone = true;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    final synchronized void mergeInit(MergePolicy.OneMerge merge) throws IOException {
        boolean success = false;
        try {
            this._mergeInit(merge);
            return;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (success) throw throwable;
            this.mergeFinish(merge);
            this.runningMerges.remove(merge);
            throw throwable;
        }
    }

    private final synchronized void _mergeInit(MergePolicy.OneMerge merge) throws IOException {
        boolean docStoreIsCompoundFile;
        String docStoreSegment;
        int docStoreOffset;
        if (!$assertionsDisabled && !this.testPoint("startMergeInit")) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !merge.registerDone) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && merge.optimize && merge.maxNumSegmentsOptimize <= 0) {
            throw new AssertionError();
        }
        if (merge.info != null) {
            return;
        }
        if (merge.isAborted()) {
            return;
        }
        boolean changed = this.applyDeletes();
        if (!$assertionsDisabled && changed && this.autoCommit) {
            throw new AssertionError();
        }
        SegmentInfos sourceSegments = merge.segments;
        int end = sourceSegments.size();
        Directory lastDir = this.directory;
        String lastDocStoreSegment = null;
        int next = -1;
        boolean mergeDocStores = false;
        boolean doFlushDocStore = false;
        String currentDocStoreSegment = this.docWriter.getDocStoreSegment();
        for (int i = 0; i < end; ++i) {
            String docStoreSegment2;
            SegmentInfo si = sourceSegments.info(i);
            if (si.hasDeletions()) {
                mergeDocStores = true;
            }
            if (-1 == si.getDocStoreOffset()) {
                mergeDocStores = true;
            }
            if ((docStoreSegment2 = si.getDocStoreSegment()) == null) {
                mergeDocStores = true;
            } else if (lastDocStoreSegment == null) {
                lastDocStoreSegment = docStoreSegment2;
            } else if (!lastDocStoreSegment.equals(docStoreSegment2)) {
                mergeDocStores = true;
            }
            if (-1 == next) {
                next = si.getDocStoreOffset() + si.docCount;
            } else if (next != si.getDocStoreOffset()) {
                mergeDocStores = true;
            } else {
                next = si.getDocStoreOffset() + si.docCount;
            }
            if (lastDir != si.dir) {
                mergeDocStores = true;
            }
            if (si.getDocStoreOffset() == -1 || currentDocStoreSegment == null || !si.getDocStoreSegment().equals(currentDocStoreSegment)) continue;
            doFlushDocStore = true;
        }
        if (mergeDocStores) {
            docStoreOffset = -1;
            docStoreSegment = null;
            docStoreIsCompoundFile = false;
        } else {
            SegmentInfo si = sourceSegments.info(0);
            docStoreOffset = si.getDocStoreOffset();
            docStoreSegment = si.getDocStoreSegment();
            docStoreIsCompoundFile = si.getDocStoreIsCompoundFile();
        }
        if (mergeDocStores && doFlushDocStore) {
            if (this.infoStream != null) {
                this.message("now flush at merge");
            }
            this.doFlush(true, false);
        }
        merge.segmentsClone = (SegmentInfos)merge.segments.clone();
        for (int i = 0; i < end; ++i) {
            SegmentInfo si = merge.segmentsClone.info(i);
            if (si.dir != this.directory) continue;
            this.deleter.incRef(si.files());
        }
        merge.increfDone = true;
        merge.mergeDocStores = mergeDocStores;
        merge.info = new SegmentInfo(this.newSegmentName(), 0, this.directory, false, true, docStoreOffset, docStoreSegment, docStoreIsCompoundFile, false);
        this.mergingSegments.add(merge.info);
    }

    private synchronized boolean doCommitBeforeMergeCFS(MergePolicy.OneMerge merge) throws IOException {
        long freeableBytes = 0L;
        int size = merge.segments.size();
        for (int i = 0; i < size; ++i) {
            SegmentInfo oldInfo;
            SegmentInfo info = merge.segments.info(i);
            Integer loc = (Integer)this.rollbackSegments.get(info);
            if (loc == null || (oldInfo = this.rollbackSegmentInfos.info(loc)).getUseCompoundFile() == info.getUseCompoundFile()) continue;
            freeableBytes += info.sizeInBytes();
        }
        long totalBytes = 0L;
        int numSegments = this.segmentInfos.size();
        for (int i = 0; i < numSegments; ++i) {
            totalBytes += this.segmentInfos.info(i).sizeInBytes();
        }
        return 3L * freeableBytes > totalBytes;
    }

    final synchronized void mergeFinish(MergePolicy.OneMerge merge) throws IOException {
        this.notifyAll();
        if (merge.increfDone) {
            this.decrefMergeSegments(merge);
        }
        if (!$assertionsDisabled && !merge.registerDone) {
            throw new AssertionError();
        }
        SegmentInfos sourceSegments = merge.segments;
        int end = sourceSegments.size();
        for (int i = 0; i < end; ++i) {
            this.mergingSegments.remove(sourceSegments.info(i));
        }
        this.mergingSegments.remove(merge.info);
        merge.registerDone = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final int mergeMiddle(MergePolicy.OneMerge merge) throws CorruptIndexException, IOException {
        IndexWriter indexWriter;
        boolean success;
        int mergedDocCount;
        SegmentMerger merger;
        String mergedName;
        block42: {
            merge.checkAborted(this.directory);
            mergedName = merge.info.name;
            merger = null;
            mergedDocCount = 0;
            SegmentInfos sourceSegments = merge.segments;
            SegmentInfos sourceSegmentsClone = merge.segmentsClone;
            int numSegments = sourceSegments.size();
            if (this.infoStream != null) {
                this.message("merging " + merge.segString(this.directory));
            }
            merger = new SegmentMerger(this, mergedName, merge);
            success = false;
            try {
                SegmentReader reader;
                int totDocCount = 0;
                for (int i = 0; i < numSegments; totDocCount += ((IndexReader)reader).numDocs(), ++i) {
                    SegmentInfo si = sourceSegmentsClone.info(i);
                    reader = SegmentReader.get(true, si, 4096, merge.mergeDocStores);
                    merger.add(reader);
                }
                if (this.infoStream != null) {
                    this.message("merge: total " + totDocCount + " docs");
                }
                merge.checkAborted(this.directory);
                mergedDocCount = merge.info.docCount = merger.merge(merge.mergeDocStores);
                if (!$assertionsDisabled && mergedDocCount != totDocCount) {
                    throw new AssertionError();
                }
                success = true;
                Object var14_19 = null;
                if (merger == null) break block42;
            }
            catch (Throwable throwable) {
                Object var14_20 = null;
                if (merger != null) {
                    merger.closeReaders();
                }
                throw throwable;
            }
            merger.closeReaders();
        }
        if (!this.commitMerge(merge, merger, mergedDocCount)) {
            return 0;
        }
        if (merge.useCompoundFile) {
            String compoundFileName;
            block43: {
                IndexWriter indexWriter2;
                if (this.autoCommit && this.doCommitBeforeMergeCFS(merge)) {
                    long size;
                    indexWriter = this;
                    synchronized (indexWriter) {
                        size = merge.info.sizeInBytes();
                    }
                    this.commit(size);
                }
                success = false;
                compoundFileName = mergedName + "." + "cfs";
                try {
                    try {
                        merger.createCompoundFile(compoundFileName);
                        success = true;
                    }
                    catch (IOException ioe) {
                        indexWriter = this;
                        synchronized (indexWriter) {
                            if (merge.isAborted()) {
                                success = true;
                            } else {
                                this.handleMergeException(ioe, merge);
                            }
                        }
                        Object var18_23 = null;
                        if (!success) {
                            if (this.infoStream != null) {
                                this.message("hit exception creating compound file during merge");
                            }
                            IndexWriter indexWriter3 = this;
                            synchronized (indexWriter3) {
                                this.deleter.deleteFile(compoundFileName);
                            }
                        }
                        break block43;
                    }
                    catch (Throwable t) {
                        this.handleMergeException(t, merge);
                        Object var18_24 = null;
                        if (!success) {
                            if (this.infoStream != null) {
                                this.message("hit exception creating compound file during merge");
                            }
                            IndexWriter indexWriter4 = this;
                            synchronized (indexWriter4) {
                                this.deleter.deleteFile(compoundFileName);
                            }
                        }
                        break block43;
                    }
                    Object var18_22 = null;
                    if (success) break block43;
                    if (this.infoStream != null) {
                        this.message("hit exception creating compound file during merge");
                    }
                    indexWriter2 = this;
                }
                catch (Throwable throwable) {
                    Object var18_25 = null;
                    if (!success) {
                        if (this.infoStream != null) {
                            this.message("hit exception creating compound file during merge");
                        }
                        IndexWriter indexWriter5 = this;
                        synchronized (indexWriter5) {
                            this.deleter.deleteFile(compoundFileName);
                        }
                    }
                    throw throwable;
                }
                synchronized (indexWriter2) {
                    this.deleter.deleteFile(compoundFileName);
                }
            }
            if (merge.isAborted()) {
                if (this.infoStream != null) {
                    this.message("abort merge after building CFS");
                }
                this.deleter.deleteFile(compoundFileName);
                return 0;
            }
            IndexWriter indexWriter6 = this;
            synchronized (indexWriter6) {
                if (this.segmentInfos.indexOf(merge.info) == -1 || merge.isAborted()) {
                    this.deleter.deleteFile(compoundFileName);
                } else {
                    merge.info.setUseCompoundFile(true);
                    this.checkpoint();
                }
            }
        }
        if (this.autoCommit) {
            long size;
            indexWriter = this;
            synchronized (indexWriter) {
                size = merge.info.sizeInBytes();
            }
            this.commit(size);
        }
        return mergedDocCount;
    }

    synchronized void addMergeException(MergePolicy.OneMerge merge) {
        if (!$assertionsDisabled && merge.getException() == null) {
            throw new AssertionError();
        }
        if (!this.mergeExceptions.contains(merge) && this.mergeGen == merge.mergeGen) {
            this.mergeExceptions.add(merge);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final synchronized boolean applyDeletes() throws CorruptIndexException, IOException {
        boolean changed;
        block8: {
            SegmentInfos rollback;
            block9: {
                if (!$assertionsDisabled && !this.testPoint("startApplyDeletes")) {
                    throw new AssertionError();
                }
                rollback = (SegmentInfos)this.segmentInfos.clone();
                boolean success = false;
                try {
                    changed = this.docWriter.applyDeletes(this.segmentInfos);
                    success = true;
                    Object var5_4 = null;
                    if (success) break block8;
                    if (this.infoStream == null) break block9;
                    this.message("hit exception flushing deletes");
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    if (!success) {
                        if (this.infoStream != null) {
                            this.message("hit exception flushing deletes");
                        }
                        int size = rollback.size();
                        for (int i = 0; i < size; ++i) {
                            String newDelFileName = this.segmentInfos.info(i).getDelFileName();
                            String delFileName = rollback.info(i).getDelFileName();
                            if (newDelFileName == null || newDelFileName.equals(delFileName)) continue;
                            this.deleter.deleteFile(newDelFileName);
                        }
                        this.segmentInfos.clear();
                        this.segmentInfos.addAll(rollback);
                    }
                    throw throwable;
                }
            }
            int size = rollback.size();
            for (int i = 0; i < size; ++i) {
                String newDelFileName = this.segmentInfos.info(i).getDelFileName();
                String delFileName = rollback.info(i).getDelFileName();
                if (newDelFileName == null || newDelFileName.equals(delFileName)) continue;
                this.deleter.deleteFile(newDelFileName);
            }
            this.segmentInfos.clear();
            this.segmentInfos.addAll(rollback);
            {
            }
        }
        if (changed) {
            this.checkpoint();
        }
        return changed;
    }

    final synchronized int getBufferedDeleteTermsSize() {
        return this.docWriter.getBufferedDeleteTerms().size();
    }

    final synchronized int getNumBufferedDeleteTerms() {
        return this.docWriter.getNumBufferedDeleteTerms();
    }

    SegmentInfo newestSegment() {
        return this.segmentInfos.info(this.segmentInfos.size() - 1);
    }

    public synchronized String segString() {
        return this.segString(this.segmentInfos);
    }

    private synchronized String segString(SegmentInfos infos) {
        StringBuffer buffer = new StringBuffer();
        int count = infos.size();
        for (int i = 0; i < count; ++i) {
            if (i > 0) {
                buffer.append(' ');
            }
            SegmentInfo info = infos.info(i);
            buffer.append(info.segString(this.directory));
            if (info.dir == this.directory) continue;
            buffer.append("**");
        }
        return buffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean startSync(String fileName, Collection pending) {
        HashSet hashSet = this.synced;
        synchronized (hashSet) {
            if (!this.synced.contains(fileName)) {
                if (!this.syncing.contains(fileName)) {
                    this.syncing.add(fileName);
                    return true;
                }
                pending.add(fileName);
                return false;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finishSync(String fileName, boolean success) {
        HashSet hashSet = this.synced;
        synchronized (hashSet) {
            if (!$assertionsDisabled && !this.syncing.contains(fileName)) {
                throw new AssertionError();
            }
            this.syncing.remove(fileName);
            if (success) {
                this.synced.add(fileName);
            }
            this.synced.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean waitForAllSynced(Collection syncing) throws IOException {
        HashSet hashSet = this.synced;
        synchronized (hashSet) {
            Iterator it = syncing.iterator();
            while (it.hasNext()) {
                String fileName = (String)it.next();
                while (!this.synced.contains(fileName)) {
                    if (!syncing.contains(fileName)) {
                        return false;
                    }
                    try {
                        this.synced.wait();
                    }
                    catch (InterruptedException ie) {}
                }
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void syncPause(long sizeInBytes) {
        if (this.mergeScheduler instanceof ConcurrentMergeScheduler && this.maxSyncPauseSeconds > 0.0) {
            long pauseTime = 1000L * sizeInBytes / 10L / 1024L / 1024L;
            long maxPauseTime = (long)(this.maxSyncPauseSeconds * 1000.0);
            if (pauseTime > maxPauseTime) {
                pauseTime = maxPauseTime;
            }
            int sleepCount = (int)(pauseTime / 100L);
            for (int i = 0; i < sleepCount; ++i) {
                IndexWriter indexWriter = this;
                synchronized (indexWriter) {
                    if (this.stopMerges || this.closing) {
                        break;
                    }
                }
                try {
                    Thread.sleep(100L);
                    continue;
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                }
            }
        }
    }

    private synchronized void doWait() {
        try {
            this.wait(1000L);
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void startCommit(long sizeInBytes) throws IOException {
        if (!IndexWriter.$assertionsDisabled && !this.testPoint("startStartCommit")) {
            throw new AssertionError();
        }
        if (this.hitOOM) {
            return;
        }
        try {
            if (this.infoStream != null) {
                this.message("startCommit(): start sizeInBytes=" + sizeInBytes);
            }
            if (sizeInBytes > 0L) {
                this.syncPause(sizeInBytes);
            }
            toSync = null;
            var6_4 = this;
            synchronized (var6_4) {
                if (sizeInBytes > 0L && this.stopMerges) {
                    return;
                }
                this.blockAddIndexes(false);
                if (!IndexWriter.$assertionsDisabled && this.hasExternalSegments()) {
                    throw new AssertionError();
                }
                try {
                    if (!IndexWriter.$assertionsDisabled && this.lastCommitChangeCount > this.changeCount) {
                        throw new AssertionError();
                    }
                    if (this.changeCount == this.lastCommitChangeCount) {
                        if (this.infoStream != null) {
                            this.message("  skip startCommit(): no changes pending");
                        }
                        var8_6 = null;
                        this.resumeAddIndexes();
                        return;
                    }
                    if (this.infoStream != null) {
                        this.message("startCommit index=" + this.segString(this.segmentInfos) + " changeCount=" + this.changeCount);
                    }
                    toSync = (SegmentInfos)this.segmentInfos.clone();
                    this.deleter.incRef(toSync, false);
                    myChangeCount = this.changeCount;
                }
                catch (Throwable var7_12) {
                    var8_8 = null;
                    this.resumeAddIndexes();
                    throw var7_12;
                }
                var8_7 = null;
                this.resumeAddIndexes();
            }
            if (!IndexWriter.$assertionsDisabled && !this.testPoint("midStartCommit")) {
                throw new AssertionError();
            }
            setPending = false;
            try {
                do {
                    pending = new ArrayList<E>();
                    for (i = 0; i < toSync.size(); ++i) {
                        info = toSync.info(i);
                        files = info.files();
                        for (j = 0; j < files.size(); ++j) {
                            fileName = (String)files.get(j);
                            if (!this.startSync(fileName, pending)) continue;
                            success = false;
                            try {
                                if (!IndexWriter.$assertionsDisabled && !this.directory.fileExists(fileName)) {
                                    throw new AssertionError((Object)("file '" + fileName + "' does not exist dir=" + this.directory));
                                }
                                this.message("now sync " + fileName);
                                this.directory.sync(fileName);
                                success = true;
                                var15_20 = null;
                                this.finishSync(fileName, success);
                                continue;
                            }
                            catch (Throwable var14_21) {
                                var15_20 = null;
                                this.finishSync(fileName, success);
                                throw var14_21;
                            }
                        }
                    }
                } while (!this.waitForAllSynced(pending));
                if (!IndexWriter.$assertionsDisabled && !this.testPoint("midStartCommit2")) {
                    throw new AssertionError();
                }
                var7_13 = this;
                synchronized (var7_13) {
                    if (myChangeCount > this.lastCommitChangeCount && (this.pendingCommit == null || myChangeCount > this.pendingCommitChangeCount)) {
                        while (this.pendingCommit != null) {
                            this.message("wait for existing pendingCommit to finish...");
                            this.doWait();
                        }
                        if (this.segmentInfos.getGeneration() > toSync.getGeneration()) {
                            toSync.updateGeneration(this.segmentInfos);
                        }
                        success = false;
                        try {
                            try {
                                toSync.prepareCommit(this.directory);
                                var17_22 = null;
                                this.segmentInfos.updateGeneration(toSync);
                            }
                            catch (Throwable var16_24) {
                                var17_23 = null;
                                this.segmentInfos.updateGeneration(toSync);
                                throw var16_24;
                            }
                            if (!IndexWriter.$assertionsDisabled && this.pendingCommit != null) {
                                throw new AssertionError();
                            }
                            setPending = true;
                            this.pendingCommit = toSync;
                            this.pendingCommitChangeCount = myChangeCount;
                            success = true;
                            var19_25 = null;
                            if (success) ** GOTO lbl122
                            this.message("hit exception committing segments file");
                        }
                        catch (Throwable var18_27) {
                            var19_26 = null;
                            if (!success) {
                                this.message("hit exception committing segments file");
                            }
                            throw var18_27;
                        }
                    } else {
                        this.message("sync superseded by newer infos");
                    }
                }
lbl122:
                // 3 sources

                this.message("done all syncs");
                if (!IndexWriter.$assertionsDisabled && !this.testPoint("midStartCommitSuccess")) {
                    throw new AssertionError();
                }
                var22_29 = null;
                var23_31 = this;
            }
            catch (Throwable var21_35) {
                var22_30 = null;
                var23_32 = this;
                synchronized (var23_32) {
                    if (!setPending) {
                        this.deleter.decRef(toSync);
                    }
                }
                throw var21_35;
            }
            synchronized (var23_31) {
                if (!setPending) {
                    this.deleter.decRef(toSync);
                }
            }
        }
        catch (OutOfMemoryError oom) {
            this.hitOOM = true;
            throw oom;
        }
        if (!IndexWriter.$assertionsDisabled && !this.testPoint("finishStartCommit")) {
            throw new AssertionError();
        }
    }

    public static boolean isLocked(Directory directory) throws IOException {
        return directory.makeLock(WRITE_LOCK_NAME).isLocked();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isLocked(String directory) throws IOException {
        boolean bl;
        FSDirectory dir = FSDirectory.getDirectory(directory);
        try {
            bl = IndexWriter.isLocked(dir);
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            ((Directory)dir).close();
            throw throwable;
        }
        ((Directory)dir).close();
        return bl;
    }

    public static void unlock(Directory directory) throws IOException {
        directory.makeLock(WRITE_LOCK_NAME).release();
    }

    boolean testPoint(String name) {
        return true;
    }

    static {
        $assertionsDisabled = !IndexWriter.class.desiredAssertionStatus();
        WRITE_LOCK_TIMEOUT = 1000L;
        DEFAULT_MAX_SYNC_PAUSE_SECONDS = Constants.WINDOWS ? 10.0 : 0.0;
        MESSAGE_ID_LOCK = new Object();
        MESSAGE_ID = 0;
        defaultInfoStream = null;
    }

    public static final class MaxFieldLength {
        private int limit;
        private String name;
        public static final MaxFieldLength UNLIMITED = new MaxFieldLength("UNLIMITED", Integer.MAX_VALUE);
        public static final MaxFieldLength LIMITED = new MaxFieldLength("LIMITED", 10000);

        private MaxFieldLength(String name, int limit) {
            this.name = name;
            this.limit = limit;
        }

        public MaxFieldLength(int limit) {
            this("User-specified", limit);
        }

        public int getLimit() {
            return this.limit;
        }

        public String toString() {
            return this.name + ":" + this.limit;
        }
    }
}

