/*
 * Decompiled with CFR 0.152.
 */
package fig.record;

import fig.record.CommandEnv;
import fig.record.ConstantSubsetHint;
import fig.record.GlobalEnv;
import fig.record.GnuPlotter;
import fig.record.ReceiverInterface;
import fig.record.RecordNode;
import fig.record.SubsetHint;
import fig.record.SubsetHintUtils;
import fig.record.VarBindingList;
import java.rmi.RemoteException;

public class LocalCommandEnv {
    private CommandEnv cmdEnv;
    private RecordNode currRecord;
    private SubsetHint hint;
    private SubsetHint defaultHint;
    private VarBindingList varBindingList;

    private LocalCommandEnv(CommandEnv cmdEnv, RecordNode currRecord, SubsetHint hint, SubsetHint defaultHint, VarBindingList varBindingList) {
        this.cmdEnv = cmdEnv;
        this.currRecord = currRecord;
        this.hint = hint;
        this.defaultHint = defaultHint;
        this.varBindingList = varBindingList;
    }

    public LocalCommandEnv(CommandEnv cmdEnv) {
        this(cmdEnv, cmdEnv.getGlobalEnv().getRootRecord(), ConstantSubsetHint.allHint, ConstantSubsetHint.allHint, VarBindingList.empty);
    }

    public LocalCommandEnv withCurrRecord(RecordNode currRecord) {
        return new LocalCommandEnv(this.cmdEnv, currRecord, this.hint, this.defaultHint, this.varBindingList);
    }

    public LocalCommandEnv withHint(SubsetHint hint) {
        return new LocalCommandEnv(this.cmdEnv, this.currRecord, hint, this.defaultHint, this.varBindingList);
    }

    public LocalCommandEnv withDefaultHint(SubsetHint defaultHint) {
        return new LocalCommandEnv(this.cmdEnv, this.currRecord, this.hint, defaultHint, this.varBindingList);
    }

    public LocalCommandEnv withHintIsDefault() {
        return this.withHint(this.defaultHint);
    }

    public LocalCommandEnv withHintIsSame() {
        return this;
    }

    public LocalCommandEnv withNewBinding(String var, String val) {
        return new LocalCommandEnv(this.cmdEnv, this.currRecord, this.hint, this.defaultHint, this.varBindingList.withNewBinding(var, val));
    }

    public LocalCommandEnv withIndex(int index) {
        return this.withNewBinding("index", "" + index);
    }

    public VarBindingList getVarBindingList() {
        return this.varBindingList;
    }

    public RecordNode getCurrRecord() {
        return this.currRecord;
    }

    public GnuPlotter getPlotter() {
        return this.cmdEnv.getPlotter();
    }

    public ReceiverInterface getReceiver() {
        return this.cmdEnv.getReceiver();
    }

    public CommandEnv getCmdEnv() {
        return this.cmdEnv;
    }

    public GlobalEnv getGlobalEnv() {
        return this.cmdEnv.getGlobalEnv();
    }

    public SubsetHint getHint() {
        return this.hint;
    }

    public RecordNode applyHint(RecordNode record) {
        return SubsetHintUtils.applyHint(this.hint, record);
    }

    public void log(Object o) {
        try {
            this.getReceiver().printErr(o + "\n");
        }
        catch (RemoteException e) {
            throw new RuntimeException(e);
        }
    }

    public void log(String fmt, Object ... args) {
        this.log(String.format(fmt, args));
    }

    public void dbg(Object o) {
        this.log("DBG " + o);
    }

    public void dbg(String fmt, Object ... args) {
        this.dbg(String.format(fmt, args));
    }
}

