/*
 * Decompiled with CFR 0.152.
 */
package fig.record;

import fig.basic.StrUtils;
import fig.basic.Utils;
import fig.record.DirRecordNode;
import fig.record.FullRecordNode;
import fig.record.LeafRecordNode;
import fig.record.LoadFileState;
import fig.record.OffsetReader;
import fig.record.PathRecordNode;
import fig.record.RecordNode;
import fig.record.StructRecordNode;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Random;

public class FileRecordNode
extends PathRecordNode {
    private int offset;
    private int numLines = -1;
    static Random rand = new Random();

    public FileRecordNode(LoadFileState state, String key, String value, File path, int offset) {
        super(state, key, value, path);
        this.offset = offset;
    }

    public FileRecordNode(LoadFileState state, File path, int offset) {
        super(state, path);
        this.offset = offset;
    }

    public FileRecordNode(LoadFileState state, File path) {
        super(state, path);
        this.offset = 0;
    }

    public int getOffset() {
        return this.offset;
    }

    private static int countIndent(String line) {
        int n = 0;
        while (n < line.length() && line.charAt(n) == '\t') {
            ++n;
        }
        return n;
    }

    @Override
    public void loadChildren() {
        this.clearChildren();
        int maxIndent = Integer.MAX_VALUE;
        if (this.numLines == -1 || this.numLines > this.state.getMaxLoadSize()) {
            maxIndent = 0;
        }
        try {
            String currLine;
            boolean alreadyOpened = this.state.alreadyOpened(this.getPath());
            OffsetReader in = this.state.getReader(this.getPath(), this.getOffset());
            if (this.state.verbose(1) && !alreadyOpened) {
                this.state.getReceiver().printErr(String.format("Loading %s:%d", this.getPath(), this.getOffset()));
            }
            ArrayList<FullRecordNode> stack = new ArrayList<FullRecordNode>();
            stack.add(this);
            stack.add(null);
            String[] currStructKeys = null;
            int currLineNum = 0;
            int rootIndent = 0;
            FileRecordNode lastNode = null;
            int lastNodeLineNum = -1;
            boolean warnedAboutZeros = false;
            while ((currLine = in.readLine()) != null) {
                if (currLine.indexOf(0) != -1) {
                    if (!warnedAboutZeros) {
                        this.state.getReceiver().printErr(String.format("Got a bunch of zeros at line " + (currLineNum + 1) + " in file " + this.getPath() + "; skipping line; this should be fixed when the file is flushed\n", new Object[0]));
                    }
                    warnedAboutZeros = true;
                    continue;
                }
                String nextLine = in.peekNextLine();
                int currIndent = FileRecordNode.countIndent(currLine);
                if (currLineNum == 0) {
                    rootIndent = currIndent;
                }
                if ((currIndent -= rootIndent) < 0) break;
                if (currIndent <= maxIndent) {
                    boolean currHasChildren;
                    int prevIndent = stack.size() - 2;
                    int nextIndent = nextLine == null ? 0 : FileRecordNode.countIndent(nextLine) - rootIndent;
                    boolean bl = currHasChildren = nextIndent > currIndent;
                    if (currHasChildren) {
                        currStructKeys = null;
                    }
                    String key = null;
                    String value = null;
                    String[] values = null;
                    int startKeyPosition = currIndent + rootIndent;
                    currLine = currLine.substring(startKeyPosition);
                    if (currStructKeys == null || currLine.startsWith(".struct")) {
                        int sep = currLine.indexOf(9);
                        if (sep == -1) {
                            sep = currLine.length();
                        }
                        key = currLine.substring(0, sep).intern();
                        value = sep + 1 < currLine.length() ? currLine.substring(sep + 1) : null;
                    } else {
                        values = StrUtils.split(currLine, "\t");
                    }
                    if (currIndent > prevIndent + 1) {
                        throw new RuntimeException("Invalid jump from indent " + prevIndent + " to " + currIndent + " at line " + (currLineNum + 1) + " in " + this.getPath() + ":" + in.getOffset());
                    }
                    int i = prevIndent;
                    while (i < currIndent) {
                        stack.add(null);
                        ++i;
                    }
                    i = prevIndent;
                    while (i > currIndent) {
                        stack.remove(stack.size() - 1);
                        --i;
                    }
                    if (".struct".equals(key)) {
                        currStructKeys = value == null ? null : StrUtils.split(value, "\t");
                    } else {
                        RecordNode node;
                        FullRecordNode parent = (FullRecordNode)stack.get(stack.size() - 2);
                        if (currStructKeys != null) {
                            node = new StructRecordNode(currStructKeys, values);
                        } else if (!currHasChildren) {
                            if (key.equals(".dir")) {
                                node = new DirRecordNode(this.state, new File(value));
                            } else if (key.equals(".file")) {
                                String[] pathOffset = StrUtils.split(value, "\t");
                                node = new FileRecordNode(this.state, new File(pathOffset[0]), Utils.parseIntHard(pathOffset[1]));
                            } else if (key.equals(".array")) {
                                values = StrUtils.split(value, "\t");
                                key = values[0];
                                node = null;
                                int j = 1;
                                while (j < values.length) {
                                    value = values[j];
                                    node = new LeafRecordNode(key, value);
                                    if (j < values.length - 1) {
                                        parent.addChild(node);
                                    }
                                    ++j;
                                }
                            } else {
                                node = new LeafRecordNode(key, value);
                            }
                        } else if (currIndent == maxIndent) {
                            if (lastNode != null) {
                                lastNode.numLines = currLineNum - lastNodeLineNum;
                            }
                            lastNode = new FileRecordNode(this.state, key, value, this.getPath(), in.getOffset());
                            node = lastNode;
                            lastNodeLineNum = currLineNum + 1;
                        } else {
                            node = new FullRecordNode(key, value);
                            stack.set(stack.size() - 1, (FullRecordNode)node);
                        }
                        if (node != null) {
                            parent.addChild(node);
                        }
                    }
                    if (nextIndent < currIndent) {
                        currStructKeys = null;
                    }
                }
                if (!this.state.verbose(1) || alreadyOpened || ++currLineNum % 10000 != 0) continue;
                this.state.getReceiver().printErr(".");
            }
            if (lastNode != null) {
                lastNode.numLines = currLineNum - lastNodeLineNum;
            }
            this.numLines = currLineNum;
            if (this.state.verbose(1) && !alreadyOpened) {
                this.state.getReceiver().printErr("\n");
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        super.loadChildren();
    }

    @Override
    public boolean outOfDate() {
        if (this.offset != 0) {
            return this.lastLoadedTime == 0L;
        }
        return super.outOfDate();
    }

    @Override
    public RecordNode shallowCopy(String key, String value) {
        FileRecordNode node = new FileRecordNode(this.state, key, value, this.getPath(), this.getOffset());
        node.setChildren(this.getChildren());
        return node;
    }

    @Override
    public RecordNode withoutChildren() {
        return new FileRecordNode(this.state, this.getKey(), this.getValue(), this.getPath(), this.getOffset()).disableLoading();
    }

    @Override
    public String getDescription(RecordNode.DescriptionType type) {
        if (type == RecordNode.DescriptionType.human) {
            return String.valueOf(super.getDescription(type)) + (this.isChildrenLoaded() ? "" : (this.numLines == -1 ? " ..." : " (" + this.numLines + " lines)"));
        }
        return ".file\t" + this.getPath() + "\t" + this.getOffset() + (this.getValue() == null ? "" : "\t" + this.getValue());
    }
}

