/*
 * Decompiled with CFR 0.152.
 */
package fig.prob;

import fig.basic.NumUtils;
import fig.prob.Distrib;
import fig.prob.SampleUtils;
import fig.prob.SuffStats;
import java.util.Random;

public class InvGamma
implements Distrib<Double> {
    private double shape;
    private double rate;

    public InvGamma(double shape, double rate) {
        this.shape = shape;
        this.rate = rate;
    }

    public double logProb(double x) {
        return this.rate * Math.log(this.shape) - NumUtils.logGamma(this.shape) + (-this.shape - 1.0) * Math.log(x) - this.rate / x;
    }

    @Override
    public double logProb(SuffStats stats) {
        throw new RuntimeException("Not implemented");
    }

    @Override
    public double logProbObject(Double x) {
        return this.logProb(x);
    }

    public double getShape() {
        return this.shape;
    }

    public double getScale() {
        return this.rate;
    }

    public double getMean() {
        return this.rate / (this.shape - 1.0);
    }

    public double getVar() {
        return this.rate * this.rate / ((this.shape - 1.0) * (this.shape - 1.0) * (this.shape - 2.0));
    }

    public double sample(Random random) {
        return InvGamma.sample(random, this.shape, this.rate);
    }

    public static double sample(Random random, double shape, double rate) {
        return 1.0 / SampleUtils.sampleGamma(random, shape, rate);
    }

    @Override
    public Double sampleObject(Random random) {
        return this.sample(random);
    }

    @Override
    public double crossEntropy(Distrib<Double> _that) {
        throw new RuntimeException("Not implemented");
    }

    public String toString() {
        return String.format("InvGamma(%.3f,%.3f)", this.shape, this.rate);
    }
}

