/*
 * Decompiled with CFR 0.152.
 */
package SyntaxUtils;

import LinguaView.syntax.CategoryObject;
import SyntaxUtils.CCGRule;
import java.lang.reflect.Method;
import java.util.EnumMap;
import java.util.Map;

public class CCGUnaryRule
extends CCGRule {
    public String left;
    public RuleType type;
    public static EnumMap<RuleType, Method> typeMethod = new EnumMap(RuleType.class);

    static {
        RuleType[] types = RuleType.values();
        int i = 0;
        while (i < types.length) {
            try {
                typeMethod.put(types[i], CategoryObject.class.getDeclaredMethod(types[i].toString(), CategoryObject.class, CategoryObject.class, Map.class));
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
            ++i;
        }
    }

    public CCGUnaryRule(String left, String result) {
        this.left = left;
        this.result = result;
        this.type = CCGUnaryRule.classifier(left, result);
        this.freq = 1;
        this.headChild = 0;
    }

    public CCGUnaryRule(String io) {
        String[] ss = io.split("\\s+");
        this.freq = Integer.parseInt(ss[0].trim());
        this.type = RuleType.values()[Integer.parseInt(ss[2].trim())];
        this.result = ss[4];
        this.left = ss[6];
        this.headChild = 0;
    }

    public CCGUnaryRule(String left, String result, int freq) {
        this(left, result);
        this.freq = freq;
    }

    protected static RuleType classifier(String left, String result) {
        CategoryObject lc = CategoryObject.fromPlainCat(left);
        CategoryObject res = CategoryObject.fromPlainCat(result);
        RuleType[] types = RuleType.values();
        int i = 0;
        while (i < types.length) {
            Method m = typeMethod.get((Object)types[i]);
            try {
                if (((Boolean)m.invoke(null, lc, res, null)).booleanValue()) {
                    return types[i];
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ++i;
        }
        return RuleType.unknown;
    }

    public CategoryObject perform(CategoryObject child, Map<CategoryObject.CoindexedObject, CategoryObject.CoindexedObject> indices) {
        CategoryObject res = CategoryObject.fromPlainCat(this.result);
        Method m = typeMethod.get((Object)this.type);
        try {
            if (m != null && ((Boolean)m.invoke(null, child, res, indices)).booleanValue()) {
                return res;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public int arity() {
        return 1;
    }

    @Override
    public String key() {
        return CCGUnaryRule.key(this.left);
    }

    public static String key(String unaryCat) {
        return unaryCat;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (!(o instanceof CCGUnaryRule)) {
            return false;
        }
        CCGUnaryRule that = (CCGUnaryRule)o;
        if (that.type != this.type) {
            return false;
        }
        return that.left.equals(this.left) && that.result.equals(this.result);
    }

    public int hashCode() {
        return this.result.hashCode();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(String.valueOf(this.freq) + " # ");
        sb.append(String.valueOf(this.type.ordinal()) + " # ");
        sb.append(String.valueOf(this.result) + " --> ");
        sb.append(this.left);
        return sb.toString();
    }

    public static void main(String[] args) {
        CCGUnaryRule test = new CCGUnaryRule("NP", "S\\(S/NP)");
        System.out.println(test);
        System.out.println((Object)test.type);
        test = new CCGUnaryRule("N", "NP", 2);
        System.out.println(test);
        System.out.println((Object)test.type);
        test = new CCGUnaryRule("S[pss]\\NP", "S/S");
        System.out.println(test);
        System.out.println((Object)test.type);
    }

    @Override
    public int typeOrdinal() {
        return this.type.ordinal();
    }

    public static enum RuleType {
        typeRaising,
        unaryTypeChangingSimple,
        unaryTypeChangingN,
        unaryTypeChangingV,
        unknown;

    }
}

