/*
 * Decompiled with CFR 0.152.
 */
package LinguaView.syntax;

import LinguaView.syntax.CategoryInterpretation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CategoryObject {
    String _category;
    String _feature;
    CategoryInterpretation _interpret;
    public CategoryObject[] _slots = null;
    Direction _dir;
    boolean _isConjunctConstituent = false;
    CategoryObject _result = null;
    CategoryObject _argument = null;
    int _depth;
    public boolean _longRange = false;
    public CoindexedObject _headObj = null;
    public static String[] HTMLColors = new String[]{"firebrick", "mediumblue", "green", "orchid"};
    static char[] markedupChars = new char[]{'_', 'Y', 'Z', 'W', 'V', 'U', 'T', 'S', 'R', 'Q', 'P', 'O', 'N', 'M', 'L', 'K', 'J', 'I', 'H', 'G', 'F', 'E', 'D', 'C', 'B', 'A'};
    public static int MaxSecondaryFunctorArity = -1;
    private static Map<String, String> extraCats = new HashMap<String, String>();

    static {
        extraCats.put("{S\\NP}\\{S\\NP}", "{S_1\\NP_2}_1\\{S_1\\NP_2}_1");
    }

    protected CategoryObject(CategoryObject res, Direction dir, CategoryObject arg) {
        if (dir == Direction.BASIC) {
            throw new IllegalArgumentException("Combine with direction basic!");
        }
        this._dir = dir;
        this._result = res;
        this._argument = arg;
        this._depth = this._result._depth + 1;
        this._category = this.toString();
    }

    public CategoryObject() {
    }

    public static CategoryObject fromPlainCat(String label) {
        boolean isConjunction = false;
        CategoryObject cat = null;
        if (label.endsWith("[conj]")) {
            isConjunction = true;
            label = label.substring(0, label.length() - 6);
        }
        cat = CategoryObject.fromPredArgCat(label, null);
        cat._isConjunctConstituent = isConjunction;
        return cat;
    }

    public static CategoryObject fromPredArgCat(String label) {
        boolean isConjunction = false;
        CategoryObject cat = null;
        if (label.endsWith("[conj]")) {
            isConjunction = true;
            label = label.substring(0, label.length() - 6);
        }
        try {
            HashMap<Integer, CoindexedObject> indexCache = new HashMap<Integer, CoindexedObject>();
            cat = CategoryObject.fromPredArgCat(label, indexCache);
            cat.coindexWith((CoindexedObject)indexCache.get(0));
            cat._slots = new CategoryObject[cat.depth()];
            cat._isConjunctConstituent = isConjunction;
            CategoryObject next = cat;
            int i = cat._slots.length - 1;
            while (i >= 0) {
                cat._slots[i] = next._argument;
                next = next._result;
                --i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IllegalArgumentException("Wrong Cat: " + label);
        }
        return cat;
    }

    private static CategoryObject fromPredArgCat(String label, Map<Integer, CoindexedObject> indices) {
        CategoryObject cat = new CategoryObject();
        label = label.replace(":B", "");
        label = label.replace(":U", "");
        label = label.replace("(", "{");
        if ((label = label.replace(")", "}")).contains("/") || label.contains("\\")) {
            int k = -1;
            int l = -1;
            if (label.charAt(0) == '{') {
                boolean needAgain = true;
                while (needAgain) {
                    l = 0;
                    k = -1;
                    if (label.charAt(0) != '{') break;
                    int numOfOpenParen = 1;
                    k = 1;
                    while (k < label.length()) {
                        if (label.charAt(k) == '{') {
                            ++numOfOpenParen;
                        }
                        if (label.charAt(k) == '}') {
                            --numOfOpenParen;
                        }
                        if (numOfOpenParen == 0) break;
                        ++k;
                    }
                    l = ++k;
                    if (l == label.length()) {
                        label = label.substring(1, label.length() - 1);
                        continue;
                    }
                    needAgain = false;
                }
                while (l < label.length()) {
                    if (label.charAt(l) == '_') {
                        k = l;
                    }
                    if (label.charAt(l) == '/' || label.charAt(l) == '\\') break;
                    ++l;
                }
                if (k == -1) {
                    k = l;
                }
            } else {
                l = 1;
                while (l < label.length()) {
                    if (label.charAt(l) == '_') {
                        k = l;
                    }
                    if (label.charAt(l) == '/' || label.charAt(l) == '\\') break;
                    ++l;
                }
                if (k == -1) {
                    k = l;
                }
            }
            if (l == label.length() - 1) {
                throw new IllegalArgumentException(label);
            }
            cat._dir = label.charAt(l) == '\\' ? Direction.BACKWARD : Direction.FORWARD;
            cat._result = label.charAt(0) == '{' ? CategoryObject.fromPredArgCat(label.substring(1, k - 1), indices) : CategoryObject.fromPredArgCat(label.substring(0, k), indices);
            if (indices != null) {
                int indexResult = 0;
                if (l != k) {
                    indexResult = Integer.parseInt(label.substring(k + 1, l));
                }
                cat._result.coindexWith(indices.get(indexResult));
                indices.put(indexResult, cat._result._headObj);
            }
            cat._depth = cat._result._depth + 1;
            if (indices != null) {
                int indexArgument = 0;
                int x = label.length();
                if (label.charAt(label.length() - 1) != '}') {
                    int i = label.length() - 1;
                    while (i > l) {
                        if (label.charAt(i) == '_') {
                            x = i;
                            indexArgument = Integer.parseInt(label.substring(i + 1, label.length()));
                            break;
                        }
                        --i;
                    }
                }
                cat._argument = label.charAt(l + 1) == '{' ? CategoryObject.fromPredArgCat(label.substring(l + 2, x - 1), indices) : CategoryObject.fromPredArgCat(label.substring(l + 1, x), indices);
                cat._argument.coindexWith(indices.get(indexArgument));
                indices.put(indexArgument, cat._argument._headObj);
            } else {
                cat._argument = label.charAt(l + 1) == '{' ? CategoryObject.fromPredArgCat(label.substring(l + 2, label.length() - 1), null) : CategoryObject.fromPredArgCat(label.substring(l + 1, label.length()), null);
            }
            cat._category = cat.toString();
        } else {
            cat._depth = 0;
            Pattern p = Pattern.compile("\\[\\w+\\]");
            Matcher m1 = p.matcher(label);
            if (m1.find()) {
                String feat = m1.group();
                cat._feature = feat.substring(1, feat.length() - 1);
                cat._category = m1.replaceAll("");
            } else {
                cat._category = label;
            }
            cat._dir = Direction.BASIC;
        }
        return cat;
    }

    public static CategoryObject fromCACCats(String label) {
        CategoryObject cat = null;
        label = label.replaceAll("#.*$", "").trim();
        String[] ss = label.split(" ", 2);
        int slotLength = Integer.parseInt(ss[0]);
        CategoryObject[] slotIndices = new CategoryObject[slotLength];
        HashMap<Character, CoindexedObject> indexCache = new HashMap<Character, CoindexedObject>();
        cat = CategoryObject.fromCACCats(ss[1], indexCache, slotIndices);
        cat.coindexWith((CoindexedObject)indexCache.get(Character.valueOf('_')));
        cat._slots = slotIndices;
        return cat;
    }

    public static CategoryObject fromCACCats(String label, Map<Character, CoindexedObject> indices, CategoryObject[] slotIndices) {
        char charIndex;
        char x;
        CategoryObject cat = new CategoryObject();
        label = label.replace("[X]", "");
        int slotIndex = -1;
        if (label.charAt(label.length() - 1) == '>') {
            int temp = label.lastIndexOf(60);
            slotIndex = Integer.parseInt(label.substring(temp + 1, label.length() - 1));
            label = label.substring(0, temp);
        }
        if ((x = label.charAt(label.length() - 2)) == '*') {
            cat._longRange = true;
            charIndex = label.charAt(label.length() - 3);
            label = label.substring(0, label.length() - 4);
        } else {
            cat._longRange = false;
            charIndex = x;
            label = label.substring(0, label.length() - 3);
        }
        if (label.contains("/") || label.contains("\\")) {
            int l = -1;
            if (label.charAt(0) == '(') {
                boolean needAgain = true;
                while (needAgain) {
                    l = 1;
                    if (label.charAt(0) != '(') break;
                    int numOfOpenParen = 1;
                    while (l < label.length()) {
                        if (label.charAt(l) == '(') {
                            ++numOfOpenParen;
                        }
                        if (label.charAt(l) == ')') {
                            --numOfOpenParen;
                        }
                        if (numOfOpenParen == 0) break;
                        ++l;
                    }
                    if (++l == label.length()) {
                        label = label.substring(1, label.length() - 1);
                        continue;
                    }
                    needAgain = false;
                }
                while (l < label.length()) {
                    if (label.charAt(l) != '/' && label.charAt(l) != '\\') {
                        ++l;
                        continue;
                    }
                    break;
                }
            } else {
                l = 1;
                while (l < label.length()) {
                    if (label.charAt(l) != '/' && label.charAt(l) != '\\') {
                        ++l;
                        continue;
                    }
                    break;
                }
            }
            cat._result = CategoryObject.fromCACCats(label.substring(0, l), indices, slotIndices);
            cat._argument = CategoryObject.fromCACCats(label.substring(l + 1), indices, slotIndices);
            cat._dir = label.charAt(l) == '\\' ? Direction.BACKWARD : Direction.FORWARD;
            cat._depth = cat._result._depth + 1;
            cat._category = cat.toString();
        } else {
            cat._depth = 0;
            Pattern p = Pattern.compile("\\[\\w+\\]");
            Matcher m1 = p.matcher(label);
            if (m1.find()) {
                String feat = m1.group();
                cat._feature = feat.substring(1, feat.length() - 1);
                cat._category = m1.replaceAll("");
            } else {
                cat._category = label;
            }
            cat._dir = Direction.BASIC;
        }
        CoindexedObject head = indices.get(Character.valueOf(charIndex));
        cat.coindexWith(head);
        indices.put(Character.valueOf(charIndex), cat._headObj);
        if (slotIndex > 0) {
            slotIndices[slotIndex - 1] = cat;
        }
        return cat;
    }

    public int depth() {
        return this._depth;
    }

    public boolean isBasic() {
        return this._dir == Direction.BASIC;
    }

    public boolean isForward() {
        return this._dir == Direction.FORWARD;
    }

    public boolean isBackward() {
        return this._dir == Direction.BACKWARD;
    }

    public String getSimplifiedCategoryString() {
        StringBuffer sb = new StringBuffer();
        if (this._dir == Direction.BASIC) {
            sb.append(this._category.charAt(0));
        } else {
            if (this._result._depth > 0) {
                sb.append("{");
            }
            sb.append(this._result.getSimplifiedCategoryString());
            if (this._result._depth > 0) {
                sb.append("}");
            }
            sb.append(this._dir == Direction.BACKWARD ? (char)'\\' : '/');
            if (this._argument._depth > 0) {
                sb.append("{");
            }
            sb.append(this._argument.getSimplifiedCategoryString());
            if (this._argument._depth > 0) {
                sb.append("}");
            }
        }
        return sb.toString();
    }

    static CategoryObject unify(CategoryObject x1, CategoryObject x2) {
        return CategoryObject.unify(x1, x2, null);
    }

    static CategoryObject unify(CategoryObject x1, CategoryObject x2, Map<CoindexedObject, CoindexedObject> indices) {
        if (x1 == null || x2 == null) {
            return null;
        }
        if (x1.depth() != x2.depth() || x1._dir != x2._dir) {
            return null;
        }
        if (x1._dir == Direction.BASIC) {
            if (!(x1._category.equals(x2._category) || x1._category.equals("NP") && x2._category.equals("N") || x2._category.equals("NP") && x1._category.equals("N"))) {
                return null;
            }
            if (x1.feature() != null && x2.feature() != null && !x1.feature().equals(x2.feature())) {
                return null;
            }
            if (indices != null) {
                CategoryObject.merge(x1._headObj, x2._headObj, indices);
            }
            CategoryObject res = CategoryObject.fromPlainCat(x1.feature() == null ? x2.toString() : x1.toString());
            if (indices != null) {
                res.attachHead(x1, indices);
                res.attachHead(x2, indices);
            }
            return res;
        }
        CategoryObject res = CategoryObject.unify(x1._result, x2._result, indices);
        CategoryObject arg = CategoryObject.unify(x1._argument, x2._argument, indices);
        if (res != null && arg != null) {
            if (indices != null) {
                CategoryObject.merge(x1._headObj, x2._headObj, indices);
            }
            res = new CategoryObject(res, x1._dir, arg);
            if (indices != null) {
                res.attachHead(x1, indices);
                res.attachHead(x2, indices);
            }
            return res;
        }
        return null;
    }

    private static CategoryObject generateFromChild(CategoryObject cat) {
        CategoryObject obj = new CategoryObject();
        obj._dir = cat._dir;
        obj._depth = cat.depth();
        HashMap<CoindexedObject, CoindexedObject> indices = new HashMap<CoindexedObject, CoindexedObject>();
        if (obj._depth != 0) {
            obj._result = CategoryObject.generateFromChild(cat._result);
            obj._argument = CategoryObject.generateFromChild(cat._argument);
            obj._category = obj.toString();
        } else {
            obj._category = cat._category;
            obj._feature = cat._feature;
        }
        obj.coindexWith(null);
        obj._headObj.attach(cat._headObj);
        indices.put(cat._headObj, obj._headObj);
        return obj;
    }

    private static CategoryObject generateFromChild(CategoryObject cat, Map<CoindexedObject, CoindexedObject> indices) {
        CategoryObject obj = new CategoryObject();
        obj._dir = cat._dir;
        obj._depth = cat.depth();
        if (obj._depth != 0) {
            obj._result = CategoryObject.generateFromChild(cat._result, indices);
            obj._argument = CategoryObject.generateFromChild(cat._argument, indices);
            obj._category = obj.toString();
        } else {
            obj._category = cat._category;
            obj._feature = cat._feature;
        }
        obj.coindexWith(indices.get(cat._headObj));
        obj._headObj.attach(cat._headObj);
        indices.put(cat._headObj, obj._headObj);
        return obj;
    }

    public String toStringWithoutFeature() {
        StringBuffer sb = new StringBuffer();
        if (this._dir == Direction.BASIC) {
            sb.append(this._category);
        } else {
            if (this._result._depth > 0) {
                sb.append("{");
            }
            sb.append(this._result.toStringWithoutFeature());
            if (this._result._depth > 0) {
                sb.append("}");
            }
            sb.append(this._dir == Direction.BACKWARD ? (char)'\\' : '/');
            if (this._argument._depth > 0) {
                sb.append("{");
            }
            sb.append(this._argument.toStringWithoutFeature());
            if (this._argument._depth > 0) {
                sb.append("}");
            }
        }
        return sb.toString();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (this._dir == Direction.BASIC) {
            sb.append(this._category);
            if (this.feature() != null) {
                sb.append("[" + this.feature() + "]");
            }
            if (this._isConjunctConstituent) {
                sb.append("[conj]");
            }
        } else {
            if (this._result._depth > 0) {
                sb.append("{");
            }
            sb.append(this._result);
            if (this._result._depth > 0) {
                sb.append("}");
            }
            sb.append(this._dir == Direction.BACKWARD ? (char)'\\' : '/');
            if (this._argument._depth > 0) {
                sb.append("{");
            }
            sb.append(this._argument);
            if (this._argument._depth > 0) {
                sb.append("}");
            }
            this._category = sb.toString();
            if (this._isConjunctConstituent) {
                sb.append("[conj]");
            }
        }
        return sb.toString();
    }

    public String toColoredString() {
        return this.toColoredString(this._slots);
    }

    public String toColoredString(CategoryObject[] slots) {
        StringBuffer sb = new StringBuffer();
        boolean colored = false;
        int i = 0;
        while (i < slots.length) {
            if (slots[i] == this) {
                colored = true;
                sb.append(String.format("<font color=\"%s\">", HTMLColors[i % 4]));
                break;
            }
            ++i;
        }
        if (this._dir == Direction.BASIC) {
            sb.append(this._category);
            if (this.feature() != null) {
                sb.append("[" + this.feature() + "]");
            }
            if (this._isConjunctConstituent) {
                sb.append("[conj]");
            }
        } else {
            if (this._result._depth > 0) {
                sb.append("{");
            }
            sb.append(this._result.toColoredString(slots));
            if (this._result._depth > 0) {
                sb.append("}");
            }
            sb.append(this._dir == Direction.BACKWARD ? (char)'\\' : '/');
            if (this._argument._depth > 0) {
                sb.append("{");
            }
            sb.append(this._argument.toColoredString(slots));
            if (this._argument._depth > 0) {
                sb.append("}");
            }
            this._category = sb.toString();
            if (this._isConjunctConstituent) {
                sb.append("[conj]");
            }
        }
        if (colored) {
            sb.append("</font>");
        }
        return sb.toString();
    }

    public String toPredArgCat() {
        if (this._headObj == null) {
            throw new NullPointerException("_headObj null!");
        }
        if (this._dir == Direction.BASIC) {
            return this.toString();
        }
        HashMap<CoindexedObject, Integer> indices = new HashMap<CoindexedObject, Integer>();
        StringBuffer sb = new StringBuffer();
        indices.put(this._headObj, 0);
        sb.append(this._result.toPredArgCat(indices));
        sb.append(this._dir == Direction.BACKWARD ? (char)'\\' : '/');
        sb.append(this._argument.toPredArgCat(indices));
        return sb.toString();
    }

    private String toPredArgCat(Map<CoindexedObject, Integer> indices) {
        int index;
        if (this._headObj == null) {
            throw new NullPointerException("_headObj null!");
        }
        StringBuffer sb = new StringBuffer();
        if (indices.containsKey(this._headObj)) {
            index = indices.get(this._headObj);
        } else {
            index = indices.size();
            indices.put(this._headObj, index);
        }
        if (this._dir == Direction.BASIC) {
            sb.append(this.toString());
        } else {
            sb.append("{");
            sb.append(this._result.toPredArgCat(indices));
            sb.append(this._dir == Direction.BACKWARD ? (char)'\\' : '/');
            sb.append(this._argument.toPredArgCat(indices));
            sb.append("}");
        }
        if (index != 0) {
            sb.append("_" + index);
        }
        return sb.toString();
    }

    public String toMarkedupString() {
        if (this._headObj == null || this._slots == null) {
            throw new NullPointerException("_headObj or slots null!");
        }
        if (this._dir == Direction.BASIC) {
            return "0 " + this.toString() + "{_}";
        }
        HashMap<CoindexedObject, Integer> indices = new HashMap<CoindexedObject, Integer>();
        CategoryObject[] unmarkedSlot = new CategoryObject[this._slots.length];
        int i = 0;
        while (i < this._slots.length) {
            unmarkedSlot[i] = this._slots[i];
            ++i;
        }
        indices.put(this._headObj, 0);
        try {
            StringBuffer sb = new StringBuffer(String.valueOf(this._slots.length) + " ");
            sb.append('(');
            sb.append(this._result.toMarkedupString(indices, unmarkedSlot));
            sb.append(this._dir == Direction.BACKWARD ? (char)'\\' : '/');
            sb.append(this._argument.toMarkedupString(indices, unmarkedSlot));
            sb.append(')');
            sb.append("{_}");
            return sb.toString();
        }
        catch (Exception e) {
            System.err.println(this.toString());
            System.err.println(this.toPredArgCat());
            System.err.println("too much slots...26 letters not enough to hold this");
            return null;
        }
    }

    private String toMarkedupString(Map<CoindexedObject, Integer> indices, CategoryObject[] unmarkedSlot) {
        int index;
        if (this._headObj == null) {
            throw new NullPointerException("_headObj null!");
        }
        StringBuffer sb = new StringBuffer();
        if (indices.containsKey(this._headObj)) {
            index = indices.get(this._headObj);
        } else {
            index = indices.size();
            indices.put(this._headObj, index);
        }
        if (this._dir == Direction.BASIC) {
            sb.append(this.toString());
        } else {
            sb.append("(");
            sb.append(this._result.toMarkedupString(indices, unmarkedSlot));
            sb.append(this._dir == Direction.BACKWARD ? (char)'\\' : '/');
            sb.append(this._argument.toMarkedupString(indices, unmarkedSlot));
            sb.append(")");
        }
        sb.append("{" + markedupChars[index]);
        if (this._longRange) {
            sb.append('*');
        }
        sb.append('}');
        int i = 0;
        while (i < unmarkedSlot.length) {
            if (unmarkedSlot[i] == this) {
                sb.append("<" + (i + 1) + '>');
                break;
            }
            ++i;
        }
        return sb.toString();
    }

    public static boolean compareIndices(CategoryObject x1, CategoryObject x2) {
        Pattern p = Pattern.compile("[^{_}/\\d\\\\]");
        String s1 = x1.toPredArgCat();
        Matcher m1 = p.matcher(s1);
        s1 = m1.replaceAll("");
        String s2 = x2.toPredArgCat();
        Matcher m2 = p.matcher(s2);
        s2 = m2.replaceAll("");
        return s1.equals(s2);
    }

    private static void merge(CoindexedObject x1, CoindexedObject x2, Map<CoindexedObject, CoindexedObject> indices) {
        CoindexedObject o1 = indices.get(x1);
        CoindexedObject o2 = indices.get(x2);
        if (o1 != null && o2 != null) {
            if (o1 != o2) {
                indices.put(x2, o1.mergeWith(o2));
            }
        } else if (o1 == null && o2 == null) {
            CoindexedObject obj = new CoindexedObject();
            obj.attach(x1);
            obj.attach(x2);
            indices.put(x1, obj);
            indices.put(x2, obj);
        } else if (o1 == null) {
            o2.attach(x1);
            indices.put(x1, o2);
        } else {
            o1.attach(x2);
            indices.put(x2, o1);
        }
    }

    public void recursiveAttachHead(CategoryObject prev, Map<CoindexedObject, CoindexedObject> indices) {
        if (this.depth() != prev.depth()) {
            throw new IllegalArgumentException("Attach cats with different depth:" + prev + " " + this);
        }
        this.attachHead(prev, indices);
        if (this._dir != Direction.BASIC) {
            try {
                this._result.recursiveAttachHead(prev._result, indices);
                this._argument.recursiveAttachHead(prev._argument, indices);
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("Attach cats with different depth:" + prev + " " + this);
            }
        }
    }

    public void recursiveAttachHead(CategoryObject prev) {
        this.recursiveAttachHead(prev, new HashMap<CoindexedObject, CoindexedObject>());
    }

    public boolean attachHead(CategoryObject prev, Map<CoindexedObject, CoindexedObject> indices) {
        if (prev._headObj == null) {
            return false;
        }
        this.coindexWith(indices.get(prev._headObj));
        this._headObj.attach(prev._headObj);
        indices.put(prev._headObj, this._headObj);
        return true;
    }

    public void clearCoindex() {
        this._headObj = null;
        if (this._dir != Direction.BASIC) {
            this._result.clearCoindex();
            this._argument.clearCoindex();
        }
    }

    public Set<Integer> head() {
        return this._headObj == null ? null : this._headObj.head();
    }

    public String feature() {
        if (this._dir != Direction.BASIC) {
            return null;
        }
        return this._feature;
    }

    private void setFeature(Set<CoindexedObject> heads) {
        for (CoindexedObject x : heads) {
            String cat = null;
            String feat = null;
            block1: for (CoindexedObject coindexedObject : x.children) {
                for (CategoryObject o : coindexedObject) {
                    if (o._feature == null) continue;
                    cat = o._category;
                    feat = o._feature;
                    continue block1;
                }
            }
            if (feat == null) continue;
            for (CategoryObject categoryObject : x) {
                if (categoryObject._dir == Direction.BASIC) {
                    if (!categoryObject._category.equals(cat)) continue;
                    categoryObject._feature = feat;
                    continue;
                }
                categoryObject._category = null;
            }
        }
    }

    public void head(int head) {
        if (this._headObj != null) {
            this._headObj.head(head);
        } else {
            System.err.println("head not initailized");
        }
    }

    public void coindexWith(CoindexedObject objs) {
        if (objs != null) {
            if (objs == this._headObj) {
                return;
            }
            if (this._headObj != null) {
                this.replaceCoindexObject(objs);
                return;
            }
        }
        if (objs == null) {
            objs = new CoindexedObject();
        }
        objs.add(this);
    }

    private void replaceCoindexObject(CoindexedObject objs) {
        if (this._headObj != null) {
            objs.mergeWith(this._headObj);
        }
        for (CategoryObject cats : this._headObj) {
            objs.add(cats);
            cats._headObj = objs;
        }
    }

    public void recursiveCoindexWith(CategoryObject cat) {
        if (cat.depth() != this.depth()) {
            System.err.println("coindex with something with different depth");
            return;
        }
        this.coindexWith(cat._headObj);
        cat.coindexWith(this._headObj);
        if (cat.depth() > 0) {
            this._result.recursiveCoindexWith(cat._result);
            this._argument.recursiveCoindexWith(cat._argument);
        }
    }

    public static CategoryObject forwardApply(CategoryObject left, CategoryObject arg) {
        HashMap<CoindexedObject, CoindexedObject> indices;
        if (left._dir == Direction.FORWARD && CategoryObject.unify(left._argument, arg, indices = new HashMap<CoindexedObject, CoindexedObject>()) != null) {
            CategoryObject res = CategoryObject.generateFromChild(left._result, indices);
            res.setFeature(new HashSet<CoindexedObject>(indices.values()));
            return res;
        }
        return null;
    }

    public static boolean forwardApply(CategoryObject left, CategoryObject right, CategoryObject res, Map<CoindexedObject, CoindexedObject> indices) {
        if (left._dir != Direction.FORWARD) {
            return false;
        }
        if (CategoryObject.unify(res, left._result) == null) {
            return false;
        }
        if (indices != null) {
            if (CategoryObject.unify(left._argument, right, indices) == null) {
                return false;
            }
            res.recursiveAttachHead(left._result, indices);
        } else if (CategoryObject.unify(left._argument, right) == null) {
            return false;
        }
        return true;
    }

    public static CategoryObject backwardApply(CategoryObject arg, CategoryObject right) {
        HashMap<CoindexedObject, CoindexedObject> indices;
        if (right._dir == Direction.BACKWARD && CategoryObject.unify(right._argument, arg, indices = new HashMap<CoindexedObject, CoindexedObject>()) != null) {
            CategoryObject res = CategoryObject.generateFromChild(right._result, indices);
            res.setFeature(new HashSet<CoindexedObject>(indices.values()));
            return res;
        }
        return null;
    }

    public static boolean backwardApply(CategoryObject left, CategoryObject right, CategoryObject res, Map<CoindexedObject, CoindexedObject> indices) {
        if (right._dir != Direction.BACKWARD) {
            return false;
        }
        if (CategoryObject.unify(res, right._result) == null) {
            return false;
        }
        if (indices != null) {
            if (CategoryObject.unify(right._argument, left, indices) == null) {
                return false;
            }
            res.recursiveAttachHead(right._result, indices);
        } else if (CategoryObject.unify(right._argument, left) == null) {
            return false;
        }
        return true;
    }

    public static CategoryObject simpleForwardCompose(CategoryObject left, CategoryObject arg) {
        HashMap<CoindexedObject, CoindexedObject> indices;
        if (left._dir == Direction.FORWARD && arg._dir == Direction.FORWARD && CategoryObject.unify(left._argument, arg._result, indices = new HashMap<CoindexedObject, CoindexedObject>()) != null) {
            CategoryObject res = new CategoryObject(CategoryObject.generateFromChild(left._result, indices), Direction.FORWARD, CategoryObject.generateFromChild(arg._argument, indices));
            res.coindexWith(res._result._headObj);
            res.setFeature(new HashSet<CoindexedObject>(indices.values()));
            return res;
        }
        return null;
    }

    public static boolean simpleForwardCompose(CategoryObject left, CategoryObject right, CategoryObject res, Map<CoindexedObject, CoindexedObject> indices) {
        if (left._dir != Direction.FORWARD || right._dir != Direction.FORWARD || res._dir != Direction.FORWARD) {
            return false;
        }
        if (CategoryObject.unify(res._result, left._result) == null || CategoryObject.unify(res._argument, right._argument) == null) {
            return false;
        }
        if (indices != null) {
            if (CategoryObject.unify(left._argument, right._result, indices) == null) {
                return false;
            }
            res._result.recursiveAttachHead(left._result, indices);
            res._argument.recursiveAttachHead(right._argument, indices);
            res.coindexWith(res._result._headObj);
        } else if (CategoryObject.unify(left._argument, right._result) == null) {
            return false;
        }
        return true;
    }

    public static CategoryObject simpleBackwardCompose(CategoryObject arg, CategoryObject right) {
        HashMap<CoindexedObject, CoindexedObject> indices;
        if (right._dir == Direction.BACKWARD && arg._dir == Direction.BACKWARD && CategoryObject.unify(right._argument, arg._result, indices = new HashMap<CoindexedObject, CoindexedObject>()) != null) {
            CategoryObject res = new CategoryObject(CategoryObject.generateFromChild(right._result, indices), Direction.BACKWARD, CategoryObject.generateFromChild(arg._argument, indices));
            res.coindexWith(res._result._headObj);
            res.setFeature(new HashSet<CoindexedObject>(indices.values()));
            return res;
        }
        return null;
    }

    public static boolean simpleBackwardCompose(CategoryObject left, CategoryObject right, CategoryObject res, Map<CoindexedObject, CoindexedObject> indices) {
        if (left._dir != Direction.BACKWARD || right._dir != Direction.BACKWARD || res._dir != Direction.BACKWARD) {
            return false;
        }
        if (CategoryObject.unify(res._result, right._result) == null || CategoryObject.unify(res._argument, left._argument) == null) {
            return false;
        }
        if (indices != null) {
            if (CategoryObject.unify(right._argument, left._result, indices) == null) {
                return false;
            }
            res._result.recursiveAttachHead(right._result, indices);
            res._argument.recursiveAttachHead(left._argument, indices);
            res.coindexWith(res._result._headObj);
        } else if (CategoryObject.unify(right._argument, left._result) == null) {
            return false;
        }
        return true;
    }

    public static CategoryObject crossBackwardCompose(CategoryObject arg, CategoryObject right) {
        HashMap<CoindexedObject, CoindexedObject> indices;
        if (right._dir == Direction.BACKWARD && arg._dir == Direction.FORWARD && CategoryObject.unify(right._argument, arg._result, indices = new HashMap<CoindexedObject, CoindexedObject>()) != null) {
            CategoryObject res = new CategoryObject(CategoryObject.generateFromChild(right._result, indices), Direction.FORWARD, CategoryObject.generateFromChild(arg._argument, indices));
            res.coindexWith(res._result._headObj);
            res.setFeature(new HashSet<CoindexedObject>(indices.values()));
            return res;
        }
        return null;
    }

    public static boolean crossBackwardCompose(CategoryObject left, CategoryObject right, CategoryObject res, Map<CoindexedObject, CoindexedObject> indices) {
        if (left._dir != Direction.FORWARD || right._dir != Direction.BACKWARD || res._dir != Direction.FORWARD) {
            return false;
        }
        if (CategoryObject.unify(res._result, right._result) == null || CategoryObject.unify(res._argument, left._argument) == null) {
            return false;
        }
        if (indices != null) {
            if (CategoryObject.unify(right._argument, left._result, indices) == null) {
                return false;
            }
            res._result.recursiveAttachHead(right._result, indices);
            res._argument.recursiveAttachHead(left._argument, indices);
            res.coindexWith(res._result._headObj);
        } else if (CategoryObject.unify(right._argument, left._result) == null) {
            return false;
        }
        return true;
    }

    public static CategoryObject crossForwardCompose(CategoryObject left, CategoryObject arg) {
        HashMap<CoindexedObject, CoindexedObject> indices;
        if (left._dir == Direction.FORWARD && arg._dir == Direction.BACKWARD && CategoryObject.unify(left._argument, arg._result, indices = new HashMap<CoindexedObject, CoindexedObject>()) != null) {
            CategoryObject res = new CategoryObject(CategoryObject.generateFromChild(left._result, indices), Direction.BACKWARD, CategoryObject.generateFromChild(arg._argument, indices));
            res.coindexWith(res._result._headObj);
            res.setFeature(new HashSet<CoindexedObject>(indices.values()));
            return res;
        }
        return null;
    }

    public static boolean crossForwardCompose(CategoryObject left, CategoryObject right, CategoryObject res, Map<CoindexedObject, CoindexedObject> indices) {
        if (left._dir != Direction.FORWARD || right._dir != Direction.BACKWARD || res._dir != Direction.BACKWARD) {
            return false;
        }
        if (CategoryObject.unify(res._result, left._result) == null || CategoryObject.unify(res._argument, right._argument) == null) {
            return false;
        }
        if (indices != null) {
            if (CategoryObject.unify(right._result, left._argument, indices) == null) {
                return false;
            }
            res._result.recursiveAttachHead(left._result, indices);
            res._argument.recursiveAttachHead(right._argument, indices);
            res.coindexWith(res._result._headObj);
        } else if (CategoryObject.unify(right._result, left._argument) == null) {
            return false;
        }
        return true;
    }

    public static CategoryObject generalizedForwardCompose(CategoryObject left, CategoryObject arg) {
        if (left._dir == Direction.FORWARD && arg._dir == Direction.FORWARD) {
            if (left._argument.depth() >= arg._result.depth()) {
                return null;
            }
            if (MaxSecondaryFunctorArity > 0 && arg._result.depth() - left._argument.depth() > MaxSecondaryFunctorArity) {
                return null;
            }
            Stack<CategoryObject> stk = new Stack<CategoryObject>();
            CategoryObject next = arg;
            while (left._argument.depth() < next._result.depth()) {
                stk.push(next);
                next = next._result;
            }
            HashMap<CoindexedObject, CoindexedObject> indices = new HashMap<CoindexedObject, CoindexedObject>();
            if (CategoryObject.unify(left._argument, next._result, indices) == null) {
                return null;
            }
            CategoryObject res = new CategoryObject(CategoryObject.generateFromChild(left._result, indices), Direction.FORWARD, CategoryObject.generateFromChild(next._argument, indices));
            res.coindexWith(res._result._headObj);
            while (stk.size() > 0) {
                CategoryObject n = (CategoryObject)stk.pop();
                res = new CategoryObject(res, n._dir, CategoryObject.generateFromChild(n._argument, indices));
                res.attachHead(n, indices);
            }
            res.setFeature(new HashSet<CoindexedObject>(indices.values()));
            return res;
        }
        return null;
    }

    public static boolean generalizedForwardCompose(CategoryObject left, CategoryObject right, CategoryObject res, Map<CoindexedObject, CoindexedObject> indices) {
        if (left._dir != Direction.FORWARD || right.depth() < 2) {
            return false;
        }
        if (left._argument.depth() >= right._result.depth() || res.depth() != left._result.depth() + right.depth() - left._argument.depth()) {
            return false;
        }
        if (MaxSecondaryFunctorArity > 0 && right._result.depth() - left._argument.depth() > MaxSecondaryFunctorArity) {
            return false;
        }
        Stack<CategoryObject> resStack = new Stack<CategoryObject>();
        CategoryObject resNext = res;
        Stack<CategoryObject> rightStack = new Stack<CategoryObject>();
        CategoryObject rightNext = right;
        while (left._argument.depth() < rightNext._result.depth()) {
            if (rightNext._dir != resNext._dir) {
                return false;
            }
            if (CategoryObject.unify(resNext._argument, rightNext._argument) == null) {
                return false;
            }
            resStack.push(resNext);
            rightStack.push(rightNext);
            resNext = resNext._result;
            rightNext = rightNext._result;
        }
        if (rightNext._dir != Direction.FORWARD || resNext._dir != Direction.FORWARD) {
            return false;
        }
        if (CategoryObject.unify(resNext._result, left._result) == null) {
            return false;
        }
        if (CategoryObject.unify(rightNext._result, left._argument, indices) == null) {
            return false;
        }
        if (indices != null) {
            resNext._result.recursiveAttachHead(left._result, indices);
            resNext._argument.recursiveAttachHead(rightNext._argument, indices);
            resNext.attachHead(left._result, indices);
            while (resStack.size() > 0) {
                resNext = (CategoryObject)resStack.pop();
                rightNext = (CategoryObject)rightStack.pop();
                resNext._argument.recursiveAttachHead(rightNext._argument, indices);
                resNext.attachHead(rightNext, indices);
            }
        }
        return true;
    }

    public static CategoryObject generalizedBackwardCompose(CategoryObject arg, CategoryObject right) {
        if (right._dir == Direction.BACKWARD && arg._dir == Direction.BACKWARD) {
            if (right._argument.depth() >= arg._result.depth()) {
                return null;
            }
            if (MaxSecondaryFunctorArity > 0 && arg._result.depth() - right._argument.depth() > MaxSecondaryFunctorArity) {
                return null;
            }
            Stack<CategoryObject> stk = new Stack<CategoryObject>();
            CategoryObject next = arg;
            while (right._argument.depth() < next._result.depth()) {
                stk.push(next);
                next = next._result;
            }
            HashMap<CoindexedObject, CoindexedObject> indices = new HashMap<CoindexedObject, CoindexedObject>();
            if (CategoryObject.unify(right._argument, next._result, indices) == null) {
                return null;
            }
            CategoryObject res = new CategoryObject(CategoryObject.generateFromChild(right._result, indices), Direction.BACKWARD, CategoryObject.generateFromChild(next._argument, indices));
            res.coindexWith(res._result._headObj);
            while (stk.size() > 0) {
                CategoryObject n = (CategoryObject)stk.pop();
                res = new CategoryObject(res, n._dir, CategoryObject.generateFromChild(n._argument, indices));
                res.attachHead(n, indices);
            }
            res.setFeature(new HashSet<CoindexedObject>(indices.values()));
            return res;
        }
        return null;
    }

    public static boolean generalizedBackwardCompose(CategoryObject left, CategoryObject right, CategoryObject res, Map<CoindexedObject, CoindexedObject> indices) {
        if (right._dir != Direction.BACKWARD || left.depth() < 2) {
            return false;
        }
        if (right._argument.depth() >= left._result.depth() || res.depth() != right._result.depth() + left.depth() - right._argument.depth()) {
            return false;
        }
        if (MaxSecondaryFunctorArity > 0 && left._result.depth() - right._argument.depth() > MaxSecondaryFunctorArity) {
            return false;
        }
        Stack<CategoryObject> resStack = new Stack<CategoryObject>();
        CategoryObject resNext = res;
        Stack<CategoryObject> rightStack = new Stack<CategoryObject>();
        CategoryObject rightNext = left;
        while (right._argument.depth() < rightNext._result.depth()) {
            if (rightNext._dir != resNext._dir) {
                return false;
            }
            if (CategoryObject.unify(resNext._argument, rightNext._argument) == null) {
                return false;
            }
            resStack.push(resNext);
            rightStack.push(rightNext);
            resNext = resNext._result;
            rightNext = rightNext._result;
        }
        if (rightNext._dir != Direction.BACKWARD || resNext._dir != Direction.BACKWARD) {
            return false;
        }
        if (CategoryObject.unify(resNext._result, right._result) == null) {
            return false;
        }
        if (CategoryObject.unify(rightNext._result, right._argument, indices) == null) {
            return false;
        }
        if (indices != null) {
            resNext._result.recursiveAttachHead(right._result, indices);
            resNext._argument.recursiveAttachHead(rightNext._argument, indices);
            resNext.attachHead(right._result, indices);
            while (resStack.size() > 0) {
                resNext = (CategoryObject)resStack.pop();
                rightNext = (CategoryObject)rightStack.pop();
                resNext._argument.recursiveAttachHead(rightNext._argument, indices);
                resNext.attachHead(rightNext, indices);
            }
        }
        return true;
    }

    public static CategoryObject generalizedForwardCrossCompose(CategoryObject left, CategoryObject arg) {
        if (left._dir == Direction.FORWARD && arg._dir != Direction.BASIC) {
            if (left._argument.depth() >= arg._result.depth()) {
                return null;
            }
            if (MaxSecondaryFunctorArity > 0 && arg._result.depth() - left._argument.depth() > MaxSecondaryFunctorArity) {
                return null;
            }
            Stack<CategoryObject> stk = new Stack<CategoryObject>();
            CategoryObject next = arg;
            while (left._argument.depth() < next._result.depth()) {
                stk.push(next);
                next = next._result;
            }
            HashMap<CoindexedObject, CoindexedObject> indices = new HashMap<CoindexedObject, CoindexedObject>();
            if (next._dir != Direction.BACKWARD || CategoryObject.unify(left._argument, next._result, indices) == null) {
                return null;
            }
            CategoryObject res = new CategoryObject(CategoryObject.generateFromChild(left._result, indices), Direction.BACKWARD, CategoryObject.generateFromChild(next._argument, indices));
            res.coindexWith(res._result._headObj);
            while (stk.size() > 0) {
                CategoryObject n = (CategoryObject)stk.pop();
                res = new CategoryObject(res, n._dir, CategoryObject.generateFromChild(n._argument, indices));
                res.attachHead(n, indices);
            }
            res.setFeature(new HashSet<CoindexedObject>(indices.values()));
            return res;
        }
        return null;
    }

    public static boolean generalizedForwardCrossCompose(CategoryObject left, CategoryObject right, CategoryObject res, Map<CoindexedObject, CoindexedObject> indices) {
        if (left._dir != Direction.FORWARD || right.depth() < 2) {
            return false;
        }
        if (left._argument.depth() >= right._result.depth() || res.depth() != left._result.depth() + right.depth() - left._argument.depth()) {
            return false;
        }
        if (MaxSecondaryFunctorArity > 0 && right._result.depth() - left._argument.depth() > MaxSecondaryFunctorArity) {
            return false;
        }
        Stack<CategoryObject> resStack = new Stack<CategoryObject>();
        CategoryObject resNext = res;
        Stack<CategoryObject> rightStack = new Stack<CategoryObject>();
        CategoryObject rightNext = right;
        while (left._argument.depth() < rightNext._result.depth()) {
            if (rightNext._dir != resNext._dir) {
                return false;
            }
            if (CategoryObject.unify(resNext._argument, rightNext._argument) == null) {
                return false;
            }
            resStack.push(resNext);
            rightStack.push(rightNext);
            resNext = resNext._result;
            rightNext = rightNext._result;
        }
        if (rightNext._dir != Direction.BACKWARD || resNext._dir != Direction.BACKWARD) {
            return false;
        }
        if (CategoryObject.unify(resNext._result, left._result) == null) {
            return false;
        }
        if (CategoryObject.unify(rightNext._result, left._argument, indices) == null) {
            return false;
        }
        if (indices != null) {
            resNext._result.recursiveAttachHead(left._result, indices);
            resNext._argument.recursiveAttachHead(rightNext._argument, indices);
            resNext.attachHead(left._result, indices);
            while (resStack.size() > 0) {
                resNext = (CategoryObject)resStack.pop();
                rightNext = (CategoryObject)rightStack.pop();
                resNext._argument.recursiveAttachHead(rightNext._argument, indices);
                resNext.attachHead(rightNext, indices);
            }
        }
        return true;
    }

    public static CategoryObject generalizedBackwardCrossCompose(CategoryObject arg, CategoryObject right) {
        if (right._dir == Direction.BACKWARD && arg._dir != Direction.BASIC) {
            if (right._argument.depth() >= arg._result.depth()) {
                return null;
            }
            if (MaxSecondaryFunctorArity > 0 && arg._result.depth() - right._argument.depth() > MaxSecondaryFunctorArity) {
                return null;
            }
            Stack<CategoryObject> stk = new Stack<CategoryObject>();
            CategoryObject next = arg;
            while (right._argument.depth() < next._result.depth()) {
                stk.push(next);
                next = next._result;
            }
            HashMap<CoindexedObject, CoindexedObject> indices = new HashMap<CoindexedObject, CoindexedObject>();
            if (next._dir != Direction.FORWARD || CategoryObject.unify(right._argument, next._result, indices) == null) {
                return null;
            }
            CategoryObject res = new CategoryObject(CategoryObject.generateFromChild(right._result, indices), Direction.FORWARD, CategoryObject.generateFromChild(next._argument, indices));
            res.coindexWith(res._result._headObj);
            while (stk.size() > 0) {
                CategoryObject n = (CategoryObject)stk.pop();
                res = new CategoryObject(res, n._dir, CategoryObject.generateFromChild(n._argument, indices));
                res.attachHead(n, indices);
            }
            res.setFeature(new HashSet<CoindexedObject>(indices.values()));
            return res;
        }
        return null;
    }

    public static boolean generalizedBackwardCrossCompose(CategoryObject left, CategoryObject right, CategoryObject res, Map<CoindexedObject, CoindexedObject> indices) {
        if (right._dir != Direction.BACKWARD || left.depth() < 2) {
            return false;
        }
        if (right._argument.depth() >= left._result.depth() || res.depth() != right._result.depth() + left.depth() - right._argument.depth()) {
            return false;
        }
        if (MaxSecondaryFunctorArity > 0 && left._result.depth() - right._argument.depth() > MaxSecondaryFunctorArity) {
            return false;
        }
        Stack<CategoryObject> resStack = new Stack<CategoryObject>();
        CategoryObject resNext = res;
        Stack<CategoryObject> rightStack = new Stack<CategoryObject>();
        CategoryObject rightNext = left;
        while (right._argument.depth() < rightNext._result.depth()) {
            if (rightNext._dir != resNext._dir) {
                return false;
            }
            if (CategoryObject.unify(resNext._argument, rightNext._argument) == null) {
                return false;
            }
            resStack.push(resNext);
            rightStack.push(rightNext);
            resNext = resNext._result;
            rightNext = rightNext._result;
        }
        if (rightNext._dir != Direction.FORWARD || resNext._dir != Direction.FORWARD) {
            return false;
        }
        if (CategoryObject.unify(resNext._result, right._result) == null) {
            return false;
        }
        if (CategoryObject.unify(rightNext._result, right._argument, indices) == null) {
            return false;
        }
        if (indices != null) {
            resNext._result.recursiveAttachHead(right._result, indices);
            resNext._argument.recursiveAttachHead(rightNext._argument, indices);
            resNext.attachHead(right._result, indices);
            while (resStack.size() > 0) {
                resNext = (CategoryObject)resStack.pop();
                rightNext = (CategoryObject)rightStack.pop();
                resNext._argument.recursiveAttachHead(rightNext._argument, indices);
                resNext.attachHead(rightNext, indices);
            }
        }
        return true;
    }

    public static CategoryObject forwardSubstitute(CategoryObject left, CategoryObject arg) {
        HashMap<CoindexedObject, CoindexedObject> indices;
        if (left._dir == arg._dir && left._dir != Direction.BASIC && left._result._dir == Direction.FORWARD && CategoryObject.unify(left._result._argument, arg._result, indices = new HashMap<CoindexedObject, CoindexedObject>()) != null && CategoryObject.unify(left._argument, arg._argument, indices) != null) {
            CategoryObject res = new CategoryObject(CategoryObject.generateFromChild(left._result._result, indices), arg._dir, CategoryObject.generateFromChild(arg._argument, indices));
            res.coindexWith(res._result._headObj);
            res._argument.recursiveAttachHead(left._argument, indices);
            res.setFeature(new HashSet<CoindexedObject>(indices.values()));
            return res;
        }
        return null;
    }

    public static boolean forwardSubstitute(CategoryObject left, CategoryObject right, CategoryObject res, Map<CoindexedObject, CoindexedObject> indices) {
        if (res._dir == Direction.BASIC || left._dir != res._dir || right._dir != res._dir || left._result._dir != Direction.FORWARD) {
            return false;
        }
        if (CategoryObject.unify(res._result, left._result._result) == null || CategoryObject.unify(res._argument, right._argument) == null || CategoryObject.unify(res._argument, left._argument) == null) {
            return false;
        }
        if (CategoryObject.unify(left._result._argument, right._result, indices) == null || CategoryObject.unify(left._argument, right._argument, indices) == null) {
            return false;
        }
        if (indices != null) {
            res._result.recursiveAttachHead(left._result._result, indices);
            res._argument.recursiveAttachHead(left._argument, indices);
            res._argument.recursiveAttachHead(right._argument, indices);
            res.coindexWith(res._result._headObj);
        }
        return true;
    }

    public static CategoryObject backwardSubstitute(CategoryObject arg, CategoryObject right) {
        HashMap<CoindexedObject, CoindexedObject> indices;
        if (right._dir == arg._dir && right._dir != Direction.BASIC && right._result._dir == Direction.BACKWARD && CategoryObject.unify(right._result._argument, arg._result, indices = new HashMap<CoindexedObject, CoindexedObject>()) != null && CategoryObject.unify(right._argument, arg._argument, indices) != null) {
            CategoryObject res = new CategoryObject(CategoryObject.generateFromChild(right._result._result, indices), arg._dir, CategoryObject.generateFromChild(arg._argument, indices));
            res.coindexWith(res._result._headObj);
            res._argument.recursiveAttachHead(right._argument, indices);
            res.setFeature(new HashSet<CoindexedObject>(indices.values()));
            return res;
        }
        return null;
    }

    public static boolean backwardSubstitute(CategoryObject left, CategoryObject right, CategoryObject res, Map<CoindexedObject, CoindexedObject> indices) {
        if (res._dir == Direction.BASIC || left._dir != res._dir || right._dir != res._dir || right._result._dir != Direction.BACKWARD) {
            return false;
        }
        if (CategoryObject.unify(res._result, right._result._result) == null || CategoryObject.unify(res._argument, right._argument) == null || CategoryObject.unify(res._argument, left._argument) == null) {
            return false;
        }
        if (CategoryObject.unify(right._result._argument, left._result, indices) == null || CategoryObject.unify(left._argument, right._argument, indices) == null) {
            return false;
        }
        if (indices != null) {
            res._result.recursiveAttachHead(right._result._result, indices);
            res._argument.recursiveAttachHead(left._argument, indices);
            res._argument.recursiveAttachHead(right._argument, indices);
            res.coindexWith(res._result._headObj);
        }
        return true;
    }

    public CategoryObject forwardTypeRaising(CategoryObject target) {
        if (target._dir == Direction.BACKWARD && CategoryObject.unify(this, target._argument) != null) {
            CategoryObject T1 = CategoryObject.fromPredArgCat(target._result.toPredArgCat());
            CategoryObject T2 = CategoryObject.fromPredArgCat(target._result.toPredArgCat());
            CategoryObject X = CategoryObject.generateFromChild(this);
            CategoryObject TX = new CategoryObject(T2, Direction.BACKWARD, X);
            TX.recursiveAttachHead(target);
            T1.coindexWith(T2._headObj);
            CategoryObject res = new CategoryObject(T1, Direction.FORWARD, TX);
            res.coindexWith(res._result._headObj);
            return res;
        }
        return null;
    }

    public CategoryObject backwardTypeRaising(CategoryObject target) {
        if (target._dir == Direction.FORWARD && CategoryObject.unify(this, target._argument) != null) {
            CategoryObject T1 = CategoryObject.fromPredArgCat(target._result.toPredArgCat());
            CategoryObject T2 = CategoryObject.fromPredArgCat(target._result.toPredArgCat());
            CategoryObject X = CategoryObject.generateFromChild(this);
            CategoryObject TX = new CategoryObject(T2, Direction.FORWARD, X);
            TX.recursiveAttachHead(target);
            T1.coindexWith(T2._headObj);
            CategoryObject res = new CategoryObject(T1, Direction.BACKWARD, TX);
            res.coindexWith(res._result._headObj);
            return res;
        }
        return null;
    }

    public void GenerateBlankCoobj() {
        ArrayList<CategoryObject> objs = new ArrayList<CategoryObject>();
        objs.add(this);
        while (!objs.isEmpty()) {
            CategoryObject next = (CategoryObject)objs.remove(0);
            next.coindexWith(null);
            if (next.depth() <= 0) continue;
            objs.add(next._argument);
            objs.add(next._result);
        }
    }

    public static boolean unknown(CategoryObject child, CategoryObject res, Map<CoindexedObject, CoindexedObject> indices) {
        if (indices != null) {
            res.GenerateBlankCoobj();
        }
        return true;
    }

    public static CategoryObject unknown(CategoryObject child) {
        return null;
    }

    public static boolean unknown(CategoryObject left, CategoryObject right, CategoryObject res, Map<CoindexedObject, CoindexedObject> indices) {
        if (indices != null) {
            res.GenerateBlankCoobj();
        }
        return true;
    }

    public static CategoryObject unknown(CategoryObject left, CategoryObject right) {
        return null;
    }

    public static boolean makeHeadFromNowhere(CategoryObject cat) {
        if (cat._depth == 0) {
            cat.coindexWith(null);
        } else {
            String predArgCat = extraCats.get(cat.toString());
            if (predArgCat == null) {
                return false;
            }
            CategoryObject.makeCoindexFromString(predArgCat, cat);
        }
        return true;
    }

    public static boolean makeCoindexFromString(String predArgCat, CategoryObject catWithNoHead) {
        CategoryObject indexedObj = CategoryObject.fromPredArgCat(predArgCat);
        HashMap<CoindexedObject, Integer> referredIndices = new HashMap<CoindexedObject, Integer>();
        HashMap<Integer, CoindexedObject> todoIndices = new HashMap<Integer, CoindexedObject>();
        ArrayList<CategoryObject> indexedCache = new ArrayList<CategoryObject>();
        ArrayList<CategoryObject> todoCache = new ArrayList<CategoryObject>();
        indexedCache.add(indexedObj);
        todoCache.add(catWithNoHead);
        while (indexedCache.size() > 0) {
            CategoryObject next = (CategoryObject)indexedCache.remove(0);
            CategoryObject todoNext = (CategoryObject)todoCache.remove(0);
            if (!referredIndices.containsKey(next._headObj)) {
                referredIndices.put(next._headObj, referredIndices.size());
                if (todoNext._headObj == null) {
                    todoNext.coindexWith(null);
                }
                todoIndices.put(todoIndices.size(), todoNext._headObj);
            } else {
                int index = (Integer)referredIndices.get(next._headObj);
                todoNext.coindexWith((CoindexedObject)todoIndices.get(index));
            }
            if (next._depth <= 0) continue;
            indexedCache.add(next._argument);
            indexedCache.add(next._result);
            todoCache.add(todoNext._argument);
            todoCache.add(todoNext._result);
        }
        return false;
    }

    public static boolean typeRaising(CategoryObject x, CategoryObject res, Map<CoindexedObject, CoindexedObject> indices) {
        if (res._dir == Direction.BASIC || res._argument._dir == Direction.BASIC || res._dir == res._argument._dir) {
            return false;
        }
        if (CategoryObject.unify(res._argument._argument, x) == null) {
            return false;
        }
        if (CategoryObject.unify(res._result, res._argument._result) == null) {
            return false;
        }
        if (indices != null) {
            CategoryObject.makeHeadFromNowhere(res._argument._result);
            res._result.recursiveCoindexWith(res._argument._result);
            res._argument.coindexWith(res._argument._result._headObj);
            res._argument._argument.recursiveAttachHead(x, indices);
            res.coindexWith(res._argument._argument._headObj);
        }
        return true;
    }

    public static CategoryObject unaryTypeChanging(CategoryObject child) {
        if (child._category.equals("N")) {
            CategoryObject NP = CategoryObject.generateFromChild(child);
            NP._category = "NP";
            return NP;
        }
        return null;
    }

    public static boolean unaryTypeChangingSimple(CategoryObject child, CategoryObject res, Map<CoindexedObject, CoindexedObject> indices) {
        if (res._dir == Direction.BASIC && child._dir == Direction.BASIC) {
            if (indices != null) {
                res.attachHead(child, indices);
            }
            return true;
        }
        if (child._dir != Direction.BASIC && CategoryObject.unify(child._result, res) != null) {
            if (indices != null) {
                res.recursiveAttachHead(child._result, indices);
            }
            return true;
        }
        return false;
    }

    public static boolean unaryTypeChangingN(CategoryObject child, CategoryObject res, Map<CoindexedObject, CoindexedObject> indices) {
        if (child._dir != Direction.BASIC && CategoryObject.unify(res, CategoryObject.fromPlainCat("NP\\NP")) != null && CategoryObject.unify(child._argument, CategoryObject.fromPlainCat("NP")) != null && CategoryObject.unify(child._result, CategoryObject.fromPlainCat("S")) != null) {
            if (indices != null) {
                res.attachHead(child, indices);
                res._argument.attachHead(child._argument, indices);
                res._result.attachHead(child._argument, indices);
            }
            return true;
        }
        return false;
    }

    public static boolean unaryTypeChangingV(CategoryObject child, CategoryObject res, Map<CoindexedObject, CoindexedObject> indices) {
        if (child._dir != Direction.BASIC && CategoryObject.unify(res, CategoryObject.fromPlainCat("(S\\NP)\\(S\\NP)")) != null && CategoryObject.unify(child._argument, CategoryObject.fromPlainCat("NP")) != null && CategoryObject.unify(child._result, CategoryObject.fromPlainCat("S")) != null) {
            if (indices != null) {
                res.attachHead(child, indices);
                res._result.coindexWith(null);
                res._argument.coindexWith(res._result._headObj);
                res._result._result.coindexWith(res._result._headObj);
                res._result._argument.attachHead(child._argument, indices);
                res._argument._result.coindexWith(res._result._headObj);
                res._argument._argument.attachHead(child._argument, indices);
            }
            return true;
        }
        return false;
    }

    public static CategoryObject coordination(CategoryObject left, CategoryObject right) {
        HashMap<CoindexedObject, CoindexedObject> indices = new HashMap<CoindexedObject, CoindexedObject>();
        CategoryObject res = null;
        if (CategoryObject.unify(left, right, indices) != null) {
            res = CategoryObject.generateFromChild(left, indices);
            res.attachHead(right, indices);
            res.setFeature(new HashSet<CoindexedObject>(indices.values()));
        } else if (left._category.equals("conj") || left.isPunctuation()) {
            res = CategoryObject.generateFromChild(right);
            res._isConjunctConstituent = true;
        } else if (right._category.equals("conj") || right.isPunctuation()) {
            res = CategoryObject.generateFromChild(left);
            res._isConjunctConstituent = true;
        }
        return res;
    }

    public static boolean coordination(CategoryObject left, CategoryObject right, CategoryObject res, Map<CoindexedObject, CoindexedObject> indices) {
        if (CategoryObject.unify(left, right, indices) != null && CategoryObject.unify(left, res) != null && CategoryObject.unify(right, res) != null) {
            if (indices != null) {
                res.recursiveAttachHead(left, indices);
                res.recursiveAttachHead(right, indices);
            }
            return true;
        }
        if (left._category.equals("conj") || left.isPunctuation()) {
            if (CategoryObject.unify(right, res) != null) {
                if (indices != null) {
                    res.recursiveAttachHead(right, indices);
                }
                return true;
            }
            if (CategoryObject.unaryTypeChangingSimple(right, res, indices)) {
                return true;
            }
            if (CategoryObject.unaryTypeChangingN(right, res, indices)) {
                return true;
            }
            if (CategoryObject.unaryTypeChangingV(right, res, indices)) {
                return true;
            }
        } else if (right._category.equals("conj") || right.isPunctuation()) {
            if (CategoryObject.unify(left, res) != null) {
                if (indices != null) {
                    res.recursiveAttachHead(left, indices);
                }
                return true;
            }
            if (CategoryObject.unaryTypeChangingSimple(left, res, indices)) {
                return true;
            }
            if (CategoryObject.unaryTypeChangingN(left, res, indices)) {
                return true;
            }
            if (CategoryObject.unaryTypeChangingV(left, res, indices)) {
                return true;
            }
        }
        return false;
    }

    public boolean isAdjunct() {
        if (this.toString().equals("{{S[to]\\NP}/{S[b]\\NP}}")) {
            return true;
        }
        if (this._dir != Direction.BASIC) {
            boolean test = this._headObj != null ? this._result.toPredArgCat().equals(this._argument.toPredArgCat()) : this._result.toString().equals(this._argument.toString());
            if (!test) {
                return false;
            }
            String catString = this.toString();
            Pattern p = Pattern.compile("\\[\\w+\\]");
            Matcher m1 = p.matcher(catString);
            int z = 0;
            while (m1.find(z)) {
                String feat = m1.group();
                if (!feat.equals("[adj]")) {
                    return false;
                }
                z = m1.end();
            }
            return true;
        }
        return false;
    }

    public CategoryObject removeModifier() {
        if (this.isAdjunct()) {
            return this._result.removeModifier();
        }
        return this;
    }

    private boolean isPunctuation() {
        if (this._category.equals("LRB") || this._category.equals("RRB")) {
            return true;
        }
        if (this._category.equals("LQU") || this._category.equals("RQU")) {
            return true;
        }
        return this._category.matches("[.,:;'`?!()]+");
    }

    public static void main(String[] args) {
        String s = "16 ((((((((((((((((QP{_}<1>/QP{_}<2>){_}<3>/QP{_}<4>){_}<5>/QP{_}<6>){_}<7>/QP{_}<8>){_}<9>/QP{_}<10>){_}<11>/QP{_}<12>){_}<13>/QP{_}<14>){_}<15>/QP{_}<16>){_}/conj{_}){_}/QP{_}){_}/QP{_}){_}/QP{_}){_}/QP{_}){_}/QP{_}){_}/QP{_}){_}/QP{_}){_}";
        CategoryObject cat = CategoryObject.fromCACCats(s);
        System.out.println(cat);
        System.out.println(cat.toPredArgCat());
        System.out.println(cat.toMarkedupString());
        System.exit(0);
    }

    public static class CoindexedObject
    extends HashSet<CategoryObject> {
        Set<Integer> head = new HashSet<Integer>();
        Set<CoindexedObject> children = new HashSet<CoindexedObject>();

        CoindexedObject() {
        }

        @Override
        public void clear() {
            this.head.clear();
            this.children.clear();
            super.clear();
        }

        @Override
        public boolean add(CategoryObject r) {
            if (r._headObj == null) {
                r._headObj = this;
                return super.add(r);
            }
            if (this != r._headObj) {
                CoindexedObject x = this.mergeWith(r._headObj);
                if (x != null) {
                    r._headObj = x;
                    return true;
                }
                return false;
            }
            return true;
        }

        public boolean attach(CoindexedObject r) {
            this.head.addAll(r.head);
            return this.children.add(r);
        }

        public CoindexedObject mergeWith(CoindexedObject r) {
            this.children.addAll(r.children);
            for (CategoryObject co : r) {
                super.add(co);
            }
            this.head.addAll(r.head);
            return this;
        }

        public CoindexedObject addAll(CoindexedObject r) {
            return this.mergeWith(r);
        }

        public boolean coindexedWith(CategoryObject r) {
            return super.contains(r);
        }

        public void head(int h) {
            this.head.add(h);
        }

        public Set<Integer> head() {
            return this.head;
        }

        public boolean emptyHead() {
            return this.head == null ? true : this.head.isEmpty();
        }
    }

    static enum Direction {
        FORWARD,
        BACKWARD,
        BASIC;

    }
}

