###############################################################################
##                                                                           ##
## This file is part of ModelBlocks. Copyright 2009, ModelBlocks developers. ##
##                                                                           ##
##    ModelBlocks is free software: you can redistribute it and/or modify    ##
##    it under the terms of the GNU General Public License as published by   ##
##    the Free Software Foundation, either version 3 of the License, or      ##
##    (at your option) any later version.                                    ##
##                                                                           ##
##    ModelBlocks is distributed in the hope that it will be useful,         ##
##    but WITHOUT ANY WARRANTY; without even the implied warranty of         ##
##    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          ##
##    GNU General Public License for more details.                           ##
##                                                                           ##
##    You should have received a copy of the GNU General Public License      ##
##    along with ModelBlocks.  If not, see <http://www.gnu.org/licenses/>.   ##
##                                                                           ##
###############################################################################

#!/usr/bin/ruby

require "scripts/umnlp.rb"

##### parse options
require 'optparse'

$options = {}
$options[:halffrd] = false
OptionParser.new do |opts|
  opts.banner = "Usage: cat genmodel/<file>hw.crctrees | grep -v '\^[5-9]' | sed 's/\^[0-9]//g' | ruby scripts/trees2dat-efg.rb [options]"
  opts.on("-f", "--halffrd", "Frd copies s^d_{t-1} = 0.5 or is -:1 = 0.5") do |v|
    $options[:halffrd] = v
  end
end.parse!

######
$error = false
$line = ""
$frd = {}

class Tree
  def toDat ( depth, qParent, numSibs=1 )

    if @children.size==0
      $stderr.print "ERROR: EXPECT (PRETERM), POS, WORD NODES IN RCTREE!!! curr:"+@head + "\nLine=#{$line}\n"
      return
    end
    if @children.size==1 && @children[0].children.size==1 && @children[0].children[0].children.size!=0
      $stderr.print "ERROR: EXPECT (PRETERM), POS, WORD NODES IN RCTREE!!! curr:"+@head + " child:"+@children[0].head + " granch:"+@children[0].children[0].head + "\n"
      return
    end

    ## terminal case, left child post-transform
    if @children.size==1 && @children[0].children.size==1 && @children[0].children[0].children.size==0
      pos = @children[0].children[0].head.gsub(/([^\#]*)\#.*/,'\1')
      #gParentAct = qParent.gsub(/(.*)\/.*/,'\1')
      #gParentAwa = qParent.gsub(/.*\/(.*)/,'\1')
      if depth<5
	## SWU: modified for new efg model
	#print "Tmp " + depth.to_s + " " + qParent + " " + @head + " " + @children[0].head+"\n"
	gParentAw = qParent.gsub(/.*\/.*:(.*)/,'\1')
	lParentAw = qParent.gsub(/.*\/(.*):.*/,'\1')
	gChild = @children[0].head.gsub(/.*:(.*)/,'\1')
	lChild = @children[0].head.gsub(/(.*):.*/,'\1')
	gHeadAc = @head.gsub(/.*:(.*)\/.*/,'\1')
	lHeadAc = @head.gsub(/(.*):.*\/.*/,'\1')
	gHeadAw = @head.gsub(/.*\/.*:(.*)/,'\1')
	lHeadAw = @head.gsub(/.*\/(.*):.*/,'\1')

        #print "Gex " + depth.to_s + " " + qParent.gsub(/.*\/(.*)\*.*/,'\1') + " : " + @children[0].head.gsub(/(.*)\*.*/,'\1') + "\n"
	print "Gex " + depth.to_s + " " + lParentAw+":"+gParentAw + " : " + lChild+":"+gChild + "\n"
        #print "Pg " + @children[0].head.gsub(/(.*)\*.*/,'\1') + " : " + pos + "\n"
	print "Pc " + gChild + " : " + pos + "\n"
        #print "Frd " + depth.to_s + " " + @children[0].head.gsub(/(.*)\*.*/,'\1') + " " + qParent.gsub(/.*\/(.*)\*.*/,'\1') + " : 1\n"
        if $options[:halffrd]==true
          $frd["Frd " + depth.to_s + " " + lChild+":"+gChild + " : -:1"] = 1
        else
          print "Frd " + depth.to_s + " " + lChild+":"+gChild + " " + lParentAw+":"+gParentAw + " : -:1\n"
        end
        #llAc = @children[0].head.gsub(/.*\*(.*)/,'\1') + "~" + @head.gsub(/.*\/.*\*(.*)/,'\1')
        #print "LLac " + depth.to_s             + " " + @children[0].head.gsub(/(.*)\*.*/,'\1') + " " + qParent.gsub(/.*\/(.*)\*.*/,'\1') + " : " + llAc + "\n"
        #print "Gac " + depth.to_s + " " + llAc + " " + @children[0].head.gsub(/(.*)\*.*/,'\1') + " " + qParent.gsub(/.*\/(.*)\*.*/,'\1') + " : " + @head.gsub(/(.*)\*.*\/.*/,'\1') + "\n"
	print "Gac " + depth.to_s + " " + lChild+":"+gChild + " " + lParentAw+":"+gParentAw + " : " + lHeadAc+":"+gHeadAc + "\n"
        #print "Gad " + depth.to_s + " " + llAc + " " + @head.gsub(/(.*)\*.*\/.*/,'\1') + " " + @children[0].head.gsub(/(.*)\*.*/,'\1') + " : " + @head.gsub(/.*\/(.*)\*.*/,'\1') + "\n"
	print "Gad " + depth.to_s + " " + lHeadAc+":"+gHeadAc + " " + lChild+":"+gChild + " : " + lHeadAw+":"+gHeadAw + "\n"
      end
      ## if beyond max depth...
      if depth>=5
        $stderr.print "ERROR: TREE TOO BIG!!!\n"
      end
      return

    ## terminal case, right child post-transform
    elsif @children.size==1 && @children[0].children.size==0
      ## make sure head label equal to pos...
      pos = @children[0].head.gsub(/([^\#]*)\#.*/,'\1')
        ## SWU: modified for new efg model
	gParentAw = qParent.gsub(/.*\/.*:(.*)/,'\1')
	lParentAw = qParent.gsub(/.*\/(.*):.*/,'\1')
	gHeadAc = @head.gsub(/.*:(.*)/,'\1')
	lHeadAc = @head.gsub(/(.*):.*/,'\1')
        #print "Gex " + depth.to_s + " " +qParent.gsub(/.*\/(.*)\*.*/,'\1')  + " : " + @head.gsub(/(.*)\*.*/,'\1') + "\n"
        print "Gex " + depth.to_s + " " + lParentAw+":"+gParentAw + " : " + lHeadAc+":"+gHeadAc + "\n"
        #print "Pg " + @head.gsub(/(.*)\*.*/,'\1') + " : " + pos + "\n"   
        print "Pc " + @head.gsub(/.*:(.*)/,'\1') + " : " + pos + "\n"
        #print "Frd " + depth.to_s + " " + @head.gsub(/(.*)\*.*/,'\1') + " " + lParentAw+":"+gParentAw + " : " + @head.gsub(/(.*)\*.*/,'\1') + "\n"
        if $options[:halffrd] 
          $frd["Frd " + depth.to_s + " " + lHeadAc+":"+gHeadAc + " : " + lHeadAc+":"+gHeadAc] = 1
        else
          print "Frd " + depth.to_s + " " + lHeadAc+":"+gHeadAc + " " + lParentAw+":"+gParentAw + " : " + lHeadAc+":"+gHeadAc + "\n"
        end
      return
      return

    ## unary case
    elsif @children.size==1
      ## recurse to unary child...
      @children[0].toDat(depth,qParent,0)
      ## SWU: modified for new efg model
      gParentAw = qParent.gsub(/.*\/.*:(.*)/,'\1')
      lParentAw = qParent.gsub(/.*\/(.*):.*/,'\1')
      gChildChildAc = @children[0].children[0].head.gsub(/.*:(.*)\/.*/,'\1')
      lChildChildAc = @children[0].children[0].head.gsub(/(.*):.*\/.*/,'\1')
      gHeadAc = @head.gsub(/.*:(.*)\/.*/,'\1')
      lHeadAc = @head.gsub(/(.*):.*\/.*/,'\1')
      gHeadAw = @head.gsub(/.*\/.*:(.*)/,'\1')
      lHeadAw = @head.gsub(/.*\/(.*):.*/,'\1')
      #print "Frd " + depth.to_s + " " + @children[0].children[0].head.gsub(/(.*)\*.*\/.*/,'\1') + " " + qParent.gsub(/.*\/(.*)\*.*/,'\1') + " : 1\n"
      if $options[:halffrd]==true
        $frd["Frd " + depth.to_s + " " + lChildChildAc+":"+gChildChildAc + " : -:1"] = 1
      else
        print "Frd " + depth.to_s + " " + lChildChildAc+":"+gChildChildAc + " " + lParentAw+":"+gParentAw + " : -:1\n"
      end
      #llAc = @children[0].children[0].head.gsub(/.*\*(.*)\/.*/,'\1') + "~" + @head.gsub(/.*\/.*\*(.*)/,'\1')
      #print "LLac " + depth.to_s             + " " + @children[0].children[0].head.gsub(/(.*)\*.*\/.*/,'\1') + " " + qParent.gsub(/.*\/(.*)\*.*/,'\1') + " : " + llAc + "\n"
      #print "Gac " + depth.to_s + " " + llAc + " " + @children[0].children[0].head.gsub(/(.*)\*.*\/.*/,'\1') + " " + qParent.gsub(/.*\/(.*)\*.*/,'\1') + " : " + @head.gsub(/(.*)\*.*\/.*/,'\1') + "\n"
      print "Gac " + depth.to_s + " " + lChildChildAc+":"+gChildChildAc + " " + lParentAw+":"+gParentAw + " : " + lHeadAc+":"+gHeadAc + "\n"
      #print "Gad " + depth.to_s + " " + llAc + " " + @head.gsub(/(.*)\*.*\/.*/,'\1') + " " + @children[0].children[0].head.gsub(/(.*)\*.*\/.*/,'\1') + " : " + @head.gsub(/.*\/(.*)\*.*/,'\1') + "\n"
      print "Gad " + depth.to_s + " " + lHeadAc+":"+gHeadAc + " " + lChildChildAc+":"+gChildChildAc + " : " + lHeadAw+":"+gHeadAw + "\n"
      return

    ## binary case remaining incomplete
    elsif @children.size==2 && @head=~/\//
      ## recurse to left child...
      @children[0].toDat(depth,qParent)
      ## recurse to right child...
      @children[1].toDat(depth+1,@children[0].head)
      ## SWU: modified for efg model
      gHeadAw = @head.gsub(/.*\/.*:(.*)/,'\1')
      lHeadAw = @head.gsub(/.*\/(.*):.*/,'\1')
      gRChild = @children[1].head.gsub(/.*:(.*)/,'\1')
      lRChild = @children[1].head.gsub(/(.*):.*/,'\1')
      gLChild = @children[0].head.gsub(/.*\/.*:(.*)/,'\1')
      lLChild = @children[0].head.gsub(/.*\/(.*):.*/,'\1')
      #llAw = @children[1].head.gsub(/.*\*(.*)/,'\1') + "~" + @head.gsub(/.*\/.*\*(.*)/,'\1')
      #print "LLaw " + depth.to_s             + " " + @children[1].head.gsub(/(.*)\*.*/,'\1') + " " + @children[0].head.gsub(/.*\/(.*)\*.*/,'\1') + " : " + llAw + "\n"
      #print "Gaw " + depth.to_s + " " + llAw + " " + @children[1].head.gsub(/(.*)\*.*/,'\1') + " " + @children[0].head.gsub(/.*\/(.*)\*.*/,'\1') + " : " + @head.gsub(/.*\/(.*)\*.*/,'\1') + "\n"
      print "Gaw " + depth.to_s + " " + lRChild+":"+gRChild + " " + lLChild+":"+gLChild + " : " + lHeadAw+":"+gHeadAw + "\n"
      return

    ## binary case becoming complete
    elsif @children.size==2 && @head!~/\//
      ## recurse to left child...
      @children[0].toDat(depth,qParent)
      ## recurse to right child...
      @children[1].toDat(depth+1,@children[0].head)
      ## SWU: added l for new efg model
      if numSibs > 0
        if $options[:halffrd] ==true
          $frd["Frd " + depth.to_s + " " + @children[0].head.gsub(/(.*):.*\/.*/,'\1')+":"+@children[0].head.gsub(/.*:(.*)\/.*/,'\1') + " : " + @head.gsub(/(.*):.*/,'\1')+":"+@head.gsub(/.*:(.*)/,'\1')] = 1
        else
          print "Frd " + depth.to_s + " " + @children[0].head.gsub(/(.*):.*\/.*/,'\1')+":"+@children[0].head.gsub(/.*:(.*)\/.*/,'\1') + " " + qParent.gsub(/.*\/(.*):.*/,'\1')+":"+qParent.gsub(/.*\/.*:(.*)/,'\1') + " : " + @head.gsub(/(.*):.*/,'\1')+":"+@head.gsub(/.*:(.*)/,'\1') + "\n"
        end
      end
      return
    end

    $stderr.print "ERROR: N-ARY BRANCH IN RCTREE!!!\n"
    return

  end
end

while($line = gets)
  t = Tree.new($line)
  t.toDat(1,"h:ROOT/h:REST")
  if $error
    $stderr.puts "\nWARNING: This tree generated a word-less Pw: #{t}\n"
    $error = false
  end
end

if $options[:halffrd]==true
  $frd.each_key {|key| print key+"\n" }
end
