###############################################################################
##                                                                           ##
## This file is part of ModelBlocks. Copyright 2009, ModelBlocks developers. ##
##                                                                           ##
##    ModelBlocks is free software: you can redistribute it and/or modify    ##
##    it under the terms of the GNU General Public License as published by   ##
##    the Free Software Foundation, either version 3 of the License, or      ##
##    (at your option) any later version.                                    ##
##                                                                           ##
##    ModelBlocks is distributed in the hope that it will be useful,         ##
##    but WITHOUT ANY WARRANTY; without even the implied warranty of         ##
##    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          ##
##    GNU General Public License for more details.                           ##
##                                                                           ##
##    You should have received a copy of the GNU General Public License      ##
##    along with ModelBlocks.  If not, see <http://www.gnu.org/licenses/>.   ##
##                                                                           ##
###############################################################################

#!/usr/bin/perl

#########################
# calc.pl
#
# Takes in a conditional and a marginal,
# and produces L_M and L'_M
#
#########################

use strict;

my %conditional;
my %hd;
my %md;


while(<STDIN>) {
  if ( m/HDMD (\w+) : (\w+) = ([\.\d]+)/ ) {
    $conditional{$1}{$2} = $3;
  } elsif ( m/HD : (\w+) = ([\.\d]+)/ ) {
    $hd{$1} = $2;
  } elsif ( m/MD : (\w+) = ([\.\d]+)/ ) {
    $md{$1} = $2;
  }
}

foreach my $head ( sort keys %conditional ) {
  #to get an idea of the vector size and possible headwords:
  if ($hd{$head}>0) {

    foreach my $mod ( sort keys %{$conditional{$head}} ) {
      # don't count zero probs
      if ($conditional{$head}{$mod}>0 ) { #&& $head ne $mod ) {

	#produce the L modifier distribution
	printf "LM  $head : $mod = $conditional{$head}{$mod}\n";

	#produce the L' modifier distribution
	my $pr = $conditional{$head}{$mod} / $md{$mod};
	printf "LpM $head : $mod = $pr\n";

      }

    }

  }

}

foreach my $head (sort keys %hd ) {
  printf "HD : $head = $hd{$head}\n";
}
### MD is only used in L'm, which has already been calculated!
#foreach my $mod (sort keys %md ) {
#  printf "MD : $mod = $md{$mod}\n";
#}
