setwd('~/acl2011/result')
prec=read.csv('./prec.csv', header=T)
recall=read.csv('./recall.csv', header=T)
fscore=read.csv('./fscore.csv', header=T)
pdf('./dect.pdf', width=6, height=6)
par(mfrow=c(3,1), mar=c(2, 5, 1, 1), oma=c(1,1,2,1), cex.lab=1.5)
x = 1:10
plot(0, xlim=c(1,10), ylim=c(0.60,0.71), type='n', xlab='', ylab='Precision')
lines(x, prec[,1], pch=1, type='b', col='red')
lines(x, prec[,2], pch=2, type='b', col='orange')
lines(x, prec[,3], pch=3, type='b', col='green')
lines(x, prec[,4], pch=4, type='b', col='black')
lines(x, prec[,5], pch=5, type='b', col='blue')
lines(x, prec[,6], pch=6, type='b', col='purple')
plot(0, xlab='', ylab='Recall', xlim=c(1,10), ylim=c(0.2,0.9), type='n')
lines(x, recall[,1], pch=1, type='b', col='red')
lines(x, recall[,2], pch=2, type='b', col='orange')
lines(x, recall[,3], pch=3, type='b', col='green')
lines(x, recall[,4], pch=4, type='b', col='black')
lines(x, recall[,5], pch=5, type='b', col='blue')
lines(x, recall[,6], pch=6, type='b', col='purple')
plot(0, xlab='Classification threshold', ylab='F-score', xlim=c(1,10), ylim=c(0.30,0.75), type='n')
lines(x, fscore[,1], pch=1, type='b', col='red')
lines(x, fscore[,2], pch=2, type='b', col='orange')
lines(x, fscore[,3], pch=3, type='b', col='green')
lines(x, fscore[,4], pch=4, type='b', col='black')
lines(x, fscore[,5], pch=5, type='b', col='blue')
lines(x, fscore[,6], pch=6, type='b', col='purple')
legend('bottomleft', c('NYT-0','NYT-0.5','NYT-1','BLOG-0','BLOG-0.5','BLOG-1'), pch=c(1,2,3,4,5,6), col=c("red", "orange", "green", "black", "blue", "purple"))
dev.off()
