/*
 * Decompiled with CFR 0.152.
 */
package babel.ranking.scorers.context;

import babel.content.eqclasses.properties.context.Context;
import babel.content.eqclasses.properties.type.Type;
import babel.ranking.scorers.context.DictScorer;
import babel.util.dict.Dictionary;

public class FungS1Scorer
extends DictScorer {
    protected double m_srcMaxCount;
    protected double m_trgMaxCount;

    public FungS1Scorer(Dictionary dict, double srcMaxCount, double trgMaxCount) {
        super(dict);
        this.m_srcMaxCount = srcMaxCount;
        this.m_trgMaxCount = trgMaxCount;
        if (this.m_srcMaxCount == 0.0 | this.m_trgMaxCount == 0.0) {
            throw new IllegalArgumentException("Max count is zero");
        }
    }

    @Override
    protected double scoreContItem(Context.ContextualItem contItem, Type.EqType type) {
        double tf = contItem.getContextCount();
        double idf = Math.log((type.equals((Object)Type.EqType.SOURCE) ? this.m_srcMaxCount : this.m_trgMaxCount) / (double)contItem.getCorpusCount()) + 1.0;
        return tf * idf;
    }
}

