/*
 * Decompiled with CFR 0.152.
 */
package org.maltparser.parser.algorithm.covington;

import org.maltparser.core.exception.MaltChainedException;
import org.maltparser.core.syntaxgraph.DependencyStructure;
import org.maltparser.core.syntaxgraph.edge.Edge;
import org.maltparser.core.syntaxgraph.node.DependencyNode;
import org.maltparser.parser.ParserConfiguration;
import org.maltparser.parser.TransitionSystem;
import org.maltparser.parser.algorithm.covington.CovingtonConfig;
import org.maltparser.parser.history.GuideUserHistory;
import org.maltparser.parser.history.History;
import org.maltparser.parser.history.action.ComplexDecisionAction;
import org.maltparser.parser.history.action.GuideUserAction;
import org.maltparser.parser.transition.TransitionTable;

public class Projective
extends TransitionSystem {
    protected static final int SHIFT = 1;
    protected static final int NOARC = 2;
    protected static final int RIGHTARC = 3;
    protected static final int LEFTARC = 4;

    public void apply(GuideUserAction currentAction, ParserConfiguration config) throws MaltChainedException {
        CovingtonConfig covingtonConfig = (CovingtonConfig)config;
        currentAction.getAction(this.actionContainers);
        Edge e = null;
        switch (this.transActionContainer.getActionCode()) {
            case 4: {
                e = covingtonConfig.getDependencyGraph().addDependencyEdge(covingtonConfig.getRightTarget().getIndex(), covingtonConfig.getLeftTarget().getIndex());
                this.addEdgeLabels(e);
                break;
            }
            case 3: {
                e = covingtonConfig.getDependencyGraph().addDependencyEdge(covingtonConfig.getLeftTarget().getIndex(), covingtonConfig.getRightTarget().getIndex());
                this.addEdgeLabels(e);
                break;
            }
        }
        this.update(covingtonConfig, this.transActionContainer.getActionCode());
    }

    private void update(CovingtonConfig covingtonConfig, int trans) throws MaltChainedException {
        if (trans == 1 || trans == 3) {
            covingtonConfig.setRight(covingtonConfig.getRight() + 1);
            covingtonConfig.setLeft(covingtonConfig.getRight() - 1);
        } else {
            int leftstop = covingtonConfig.getLeftstop();
            int left = covingtonConfig.getLeft();
            if (trans == 2) {
                DependencyNode leftNode;
                DependencyStructure dg = covingtonConfig.getDependencyStructure();
                left = dg.getTokenNode((leftNode = covingtonConfig.getInput().get(covingtonConfig.getLeft())).getIndex()) != null && dg.getTokenNode(leftNode.getIndex()).hasHead() ? dg.getTokenNode(leftNode.getIndex()).getHead().getIndex() : leftstop - 1;
            } else {
                DependencyNode rightNode = covingtonConfig.getRightTarget();
                --left;
                DependencyNode leftNode = null;
                while (left >= leftstop) {
                    leftNode = covingtonConfig.getInput().get(left);
                    if (rightNode.findComponent().getIndex() != leftNode.findComponent().getIndex()) break;
                    --left;
                }
            }
            if (left < leftstop) {
                covingtonConfig.setRight(covingtonConfig.getRight() + 1);
                covingtonConfig.setLeft(covingtonConfig.getRight() - 1);
            } else {
                covingtonConfig.setLeft(left);
            }
        }
    }

    public GuideUserAction getDeterministicAction(GuideUserHistory history, ParserConfiguration config) throws MaltChainedException {
        return null;
    }

    protected void addAvailableTransitionToTable(TransitionTable ttable) throws MaltChainedException {
        ttable.addTransition(1, "SH", false, null);
        ttable.addTransition(2, "NA", false, null);
        ttable.addTransition(3, "RA", true, null);
        ttable.addTransition(4, "LA", true, null);
    }

    protected void initWithDefaultTransitions(GuideUserHistory history) throws MaltChainedException {
        ComplexDecisionAction currentAction = new ComplexDecisionAction((History)history);
        this.transActionContainer.setAction(1);
        this.transActionContainer.setAction(2);
        for (int i = 0; i < this.arcLabelActionContainers.length; ++i) {
            this.arcLabelActionContainers[i].setAction(-1);
        }
        currentAction.addAction(this.actionContainers);
    }

    public String getName() {
        return "covnonproj";
    }

    public boolean permissible(GuideUserAction currentAction, ParserConfiguration config) throws MaltChainedException {
        CovingtonConfig covingtonConfig = (CovingtonConfig)config;
        DependencyNode leftTarget = covingtonConfig.getLeftTarget();
        DependencyNode rightTarget = covingtonConfig.getRightTarget();
        DependencyStructure dg = covingtonConfig.getDependencyGraph();
        currentAction.getAction(this.actionContainers);
        int trans = this.transActionContainer.getActionCode();
        if (trans == 1 && !covingtonConfig.isAllowShift()) {
            return false;
        }
        if (!(trans != 4 && trans != 3 || this.isActionContainersLabeled())) {
            return false;
        }
        if (trans == 4 && leftTarget.isRoot()) {
            return false;
        }
        if (trans == 4 && dg.hasLabeledDependency(leftTarget.getIndex())) {
            return false;
        }
        return trans != 3 || !dg.hasLabeledDependency(rightTarget.getIndex());
    }

    public GuideUserAction defaultAction(GuideUserHistory history, ParserConfiguration configuration) throws MaltChainedException {
        return this.updateActionContainers(history, 2, null);
    }
}

