#!/bin/sh

# this runs the experiments
# run make_data.sh first 

# if your system does not have PBS, substitute 'qsub' with 'source' (or, if the scripts are executable, simply remove it)

# if you want to run less experiments, change the loop structure
# 	i iterates over the different leave-1-out settings (i=1 does train on 2,3,4, i=2 on 1,2,4 and so on)
#	alpha is the dirichlet-prior, we report the scores for 0.1

# you can also call the experiment scripts directly

for i in 1 2 3 4
do
  for lang in English Korean
  do
    for wo in WordOrder NoWordOrder
    do
      qsub experiments/${wo}/${lang}/jitter/leave${i}_0.1.sh
      for alpha in 0.1 0.5 1.0
      do
	qsub experiments/${wo}/${lang}/leave${i}_${alpha}.sh
      done
    done
  done
done

# when all jobs are finished, run evaluate_all.sh
