/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.tokenizer;

import com.aliasi.tokenizer.Tokenizer;

class CharacterTokenizer
extends Tokenizer {
    private final char[] mChars;
    private final int mLastPosition;
    private int mPosition;
    private final int mStartPosition;
    private int mLastTokenStartPosition = -1;
    private int mLastTokenEndPosition = -1;

    public CharacterTokenizer(char[] ch, int offset, int length) {
        if (offset < 0) {
            String msg = "Offset must be greater than 0. Found offset=" + offset;
            throw new IllegalArgumentException(msg);
        }
        if (length < 0) {
            String msg = "Length must be greater than 0. Found length=" + length;
            throw new IllegalArgumentException(msg);
        }
        if (offset + length > ch.length) {
            String msg = "Offset Plus length must be less than or equal array length. Found ch.length=" + ch.length + " offset=" + offset + " length=" + length + " (offset+length)=" + (offset + length);
            throw new IllegalArgumentException(msg);
        }
        this.mChars = ch;
        this.mPosition = offset;
        this.mStartPosition = offset;
        this.mLastPosition = offset + length;
    }

    public int lastTokenStartPosition() {
        return this.mLastTokenStartPosition;
    }

    public int lastTokenEndPosition() {
        return this.mLastTokenEndPosition;
    }

    public String nextWhitespace() {
        StringBuilder sb = new StringBuilder();
        while (this.hasMoreCharacters() && Character.isWhitespace(this.currentChar())) {
            sb.append(this.currentChar());
            ++this.mPosition;
        }
        return sb.toString();
    }

    public String nextToken() {
        this.skipWhitespace();
        if (!this.hasMoreCharacters()) {
            return null;
        }
        this.mLastTokenStartPosition = this.mPosition - this.mStartPosition;
        this.mLastTokenEndPosition = this.mLastTokenStartPosition + 1;
        return new String(new char[]{this.mChars[this.mPosition++]});
    }

    public String toString() {
        return this.getClass().getName();
    }

    private void skipWhitespace() {
        while (this.hasMoreCharacters() && Character.isWhitespace(this.currentChar())) {
            ++this.mPosition;
        }
    }

    private boolean hasMoreCharacters() {
        return this.mPosition < this.mLastPosition;
    }

    private char currentChar() {
        return this.mChars[this.mPosition];
    }
}

