/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.tag;

import com.aliasi.tag.Tagging;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringTagging
extends Tagging<String> {
    private final String mCs;
    private final int[] mTokenStarts;
    private final int[] mTokenEnds;

    public StringTagging(List<String> tokens, List<String> tags, CharSequence cs, int[] tokenStarts, int[] tokenEnds) {
        super(tokens, tags);
        int n;
        if (tokenStarts.length != tokens.size()) {
            String msg = "Token starts must be same length as tokens. Found tokens.size()=" + tokens.size() + " tokenStarts.length=" + tokenStarts.length;
            throw new IllegalArgumentException(msg);
        }
        if (tokenEnds.length != tokens.size()) {
            String msg = "Token ends must be same length as tokens. Found tokens.size()=" + tokens.size() + " tokenEnds.length=" + tokenEnds.length;
            throw new IllegalArgumentException(msg);
        }
        for (n = 0; n < tokenStarts.length; ++n) {
            if (tokenStarts[n] <= tokenEnds[n]) continue;
            String msg = "Tokens must start before they end. tokenStarts[" + n + "]=" + tokenStarts[n] + " tokenEnds[n" + n + "]=" + tokenEnds[n];
            throw new IllegalArgumentException(msg);
        }
        for (n = 1; n < tokenStarts.length; ++n) {
            if (tokenStarts[n - 1] > tokenStarts[n]) {
                String msg = "Token starts must be in ascending order. Found tokenStarts[" + (n - 1) + "]=" + tokenStarts[n - 1] + " tokenStarts[" + n + "]=" + tokenStarts[n];
                throw new IllegalArgumentException(msg);
            }
            if (tokenEnds[n - 1] <= tokenEnds[n]) continue;
            String msg = "Token ends must be in ascending order. Found tokenEnds[" + (n - 1) + "]=" + tokenEnds[n - 1] + " tokenEnds[" + n + "]=" + tokenEnds[n];
            throw new IllegalArgumentException(msg);
        }
        if (tokenStarts.length > 0) {
            if (tokenStarts[0] < 0) {
                String msg = "Token starts must be >= 0. Found tokenStarts[0]=" + tokenStarts[0];
                throw new IllegalArgumentException(msg);
            }
            if (tokenEnds[tokenEnds.length - 1] > cs.length()) {
                String msg = "Tokens must fall within span of chars. Found cs=" + cs + " cs.length()=" + cs.length() + " tokenEnds[" + (tokenEnds.length - 1) + "]=" + tokenEnds[tokenEnds.length - 1];
                throw new IllegalArgumentException(msg);
            }
        }
        this.mCs = ((Object)cs).toString();
        this.mTokenStarts = (int[])tokenStarts.clone();
        this.mTokenEnds = (int[])tokenEnds.clone();
    }

    public StringTagging(List<String> tokens, List<String> tags, CharSequence cs, List<Integer> tokenStarts, List<Integer> tokenEnds) {
        this(tokens, tags, cs, StringTagging.toArray(tokenStarts), StringTagging.toArray(tokenEnds));
    }

    static int[] toArray(List<Integer> xs) {
        int[] result = new int[xs.size()];
        for (int i = 0; i < xs.size(); ++i) {
            result[i] = xs.get(i);
        }
        return result;
    }

    StringTagging(String s, List<String> tokens, List<String> tags, int[] tokenStarts, int[] tokenEnds, boolean ignore) {
        super(tokens, tags, ignore);
        this.mCs = s;
        this.mTokenStarts = tokenStarts;
        this.mTokenEnds = tokenEnds;
    }

    public int tokenStart(int n) {
        return this.mTokenStarts[n];
    }

    public int tokenEnd(int n) {
        return this.mTokenEnds[n];
    }

    public String rawToken(int n) {
        return this.mCs.substring(this.tokenStart(n), this.tokenEnd(n));
    }

    public String characters() {
        return this.mCs;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.mCs);
        sb.append('\n');
        for (int i = 0; i < this.size(); ++i) {
            if (i > 0) {
                sb.append(" ");
            }
            sb.append((String)this.token(i) + "/" + this.tag(i) + "//" + this.rawToken(i) + "///@(" + this.tokenStart(i) + "," + this.tokenEnd(i) + ")");
        }
        return sb.toString();
    }

    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (!(that instanceof StringTagging)) {
            return false;
        }
        StringTagging thatTagging = (StringTagging)that;
        if (!this.characters().equals(thatTagging.characters())) {
            return false;
        }
        if (this.size() != thatTagging.size()) {
            return false;
        }
        for (int n = 0; n < this.size(); ++n) {
            if (!((String)this.token(n)).equals(thatTagging.token(n))) {
                return false;
            }
            if (!this.tag(n).equals(thatTagging.tag(n))) {
                return false;
            }
            if (this.tokenStart(n) != thatTagging.tokenStart(n)) {
                return false;
            }
            if (this.tokenEnd(n) == thatTagging.tokenEnd(n)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int c = this.characters().hashCode();
        for (int n = 0; n < this.size(); ++n) {
            c = 31 * c + this.tag(n).hashCode();
        }
        return c;
    }
}

