%option 8Bit batch yylineno noyywrap

%{
/*MA****************************************************************/
/*                                                                 */
/*  FILE     scanner.l                                             */
/*  MODULE   scanner                                               */
/*  PROGRAM  BitPar                                                */
/*  AUTHOR   Helmut Schmid, IMS, University of Stuttgart           */
/*                                                                 */
/*ME****************************************************************/

#include <string.h>

#include "tree.h"
#include "y.tab.h"


extern void yyerror(char *text);

char *copy(const char *s)

{
  char *p, buffer[1000];
  for( p=buffer; ; p++, s++) {
    if (p == buffer+1000)
      throw "string too long!\n";
    if (*s == '\\')
      s++;
    if ((*p = *s) == 0)
      break;
  }
  return strdup(buffer);
}

%}


%%


[()/]		{ return yytext[0]; }

([^ \t\n\r()]|\\.)+ { yylval.name = copy(yytext); return NAME; }

[ \t\n]		{ /* ignored */ }


%%
