/*
 * Decompiled with CFR 0.152.
 */
package tsg.parseEval;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import settings.Parameters;
import util.FileUtil;

public class EvalB {
    static String EvalBPath = String.valueOf(Parameters.softwarePath) + "EVALB/";
    static String EvalBApp = String.valueOf(EvalBPath) + "evalb";
    static String EvalBDefaultParam = String.valueOf(EvalBPath) + "new.prm";
    static String EvalbArgs = "-p " + EvalBDefaultParam;

    public EvalB(File goldFile, File parsedFile, File outputFile, boolean labeled) {
        String resultFolder = "/scratch/fsangati/RESULTS/TSG/";
        String evalbApp = "/Users/fsangati/Work/SOFTWARE/EVALB/evalb";
        String evalbArgs = "-p " + resultFolder + "collins";
        evalbArgs = String.valueOf(evalbArgs) + (labeled ? ".prm" : ".UL.prm");
        try {
            Process p = Runtime.getRuntime().exec(String.valueOf(evalbApp) + " " + evalbArgs + " " + goldFile + " " + parsedFile);
            EvalB.redirectOutput(p, outputFile, false);
        }
        catch (Exception e) {
            FileUtil.handleExceptions(e);
        }
    }

    public EvalB(File goldFile, File parsedFile, File outputFile) {
        try {
            Process p = Runtime.getRuntime().exec(String.valueOf(EvalBApp) + " " + EvalbArgs + " " + goldFile + " " + parsedFile);
            EvalB.redirectOutput(p, outputFile, false);
        }
        catch (Exception e) {
            FileUtil.handleExceptions(e);
        }
    }

    private static void redirectOutput(Process p, File outFile, boolean printProgress) {
        try {
            String s = null;
            BufferedReader stdInput = new BufferedReader(new InputStreamReader(p.getInputStream()));
            PrintWriter pw = FileUtil.getPrintWriter(outFile);
            while ((s = stdInput.readLine()) != null) {
                pw.println(s);
            }
            pw.close();
            stdInput.close();
            p.getOutputStream().close();
            p.getErrorStream().close();
        }
        catch (IOException e) {
            FileUtil.handleExceptions(e);
        }
    }

    public static void main(String[] args) {
        String basePath = "/scratch/fsangati/RESULTS/TSG/DOP_SD_Reranker/";
        File gold = new File(String.valueOf(basePath) + "wsj-22_gold.mrg");
        File test = new File(String.valueOf(basePath) + "wsj-22_reranked_5best_PQ.mrg");
        File evalF = new File(String.valueOf(basePath) + "wsj-22_reranked_5best_PQ.evalB");
        new EvalB(gold, test, evalF, true);
    }
}

