modal_not_adverb = ['albatta', 'shaksiz', 'shubhasiz', 'tabiiy', 'ehtimol', 'chamasi', 'aftidan', 'balki', 'shekilli', 'darhaqiqat', 
                        'haqiqatan', 'xullas', 'demak', 'umuman', 'avvalo', 'avvalambor', 'masalan', 'jumladan', 'attang',
                        'afsus', 'xayriyat', 'baxtimga', 'koshki', 'darvoqe', 'aslida', 'to‘g‘risi', 'ma’lumki', 'ochig‘i', 'chindan', 
                        'ayniqsa', 'haytovur', 'aytmoqchi', 'so‘zsiz', 'essiz', 'ishqilib', 'shuningdek', 'nihoyat', 'aytganday', 
                        'mayli', 'xo‘p', 'to‘g‘ri', 'aksincha', 'shak-shubhasiz', 'xayriyat'] #har qalay #har holda #haqiqatdan ham

imit_not_verb = ['vov', 'vavag‘', 'vadavang', 'uv', 'irr', 'mo‘o‘', 'maa', 'baa', 'mee', 'taraq', 'tap', 'sharaq', 'shalop', 'miyov',
                 'parr', 'pirr', 'gurs', 'tars', 'qars', 'shaq', 'g‘arch', 'ding‘', 'do‘pur', 'qiy-chuv', 'pit-pildiq', 'di-dit', 'bit-bil-diq',
                 'gumbur', 'guldur-guldur', 'gurs-gurs', 'gup-gup', 'chars-churs', 'chug‘ur-chug‘ur', 'dup-dup', 'dupur-dupur', 'dukur-dukur', 
                 'duk-duk', 'duv-duv', 'dang‘-dung‘', 'shiq-shiq', 'ship-ship', 'taq-tuq', 'taq-tiq', 'tuq-tuq', 'to‘q-to‘q', 'taq-taq', 'to‘p-to‘p',
                 'tap-tap', 'tirs-tirs', 'tars-tars', 'tars-turs', 'tiqir-tiqir', 'taraq-turuq', 'taqir-tuqur', 'g‘arch-g‘urch', 'g‘ovur-g‘ovur',
                 'g‘ovur-g‘uvur', 'g‘ala-g‘ovur', 'g‘o‘ng‘ir-g‘o‘ng‘ir', 'g‘a-g‘a', 'g‘ir-g‘ir', 'inga-inga', 'jarang-jurung', 'jangur-jungur', 
                 'pix-pix', 'piq-piq', 'pish-pish', 'paq-puq', 'qult-qult', 'qars-qurs', 'bidir-bidir', 'biliq-biliq', 'baka-baka-bum', 'bilch-bilch',
                 'yarq-yurq', 'ing-ing', 'ang-ang', 'va-vaq', 'vaq-vaq', 'vish-vish', 'viz-viz', 'vov-vov', 'vag‘ir-vug‘uri', 'qu-qu', 'qa-qa', 'qag‘-qag‘',
                 'shitir-shitir', 'shildir-shildir', 'shaq-shuq', 'sharaq-sharaq', 'sharaq-shuruq', 'shaqir-shuqur', 'shov-shuv', 'xi-xi', 'hah-hah', 'lop',
                 'lo‘q', 'lang', 'dang', 'ding', 'yarq', 'xippa', 'gup', 'g‘ir', 'shart', 'shig‘', 'shuv', 'paqqa', 'cho‘rt', 'chirt', 'jiz', 'jaz', 'miq',
                 'vuy', 'tfu', 'apil-tapil', 'hang-mang', 'alg‘ov-dalg‘ov', 'alang-jalang', 'yalt-yult', 'yilt-yilt', 'yarq--yurq', 'yal-yal', 'gir-gir',
                 'gup-gup', 'guppa-guppa', 'g‘uj-g‘uj', 'g‘ivir-g‘ivir', 'jilpang-jilpang', 'jimir-jimir', 'milt-milt', 'mo‘lt-mo‘lt', 'lip-lip', 'luq-luq',
                 'lo‘q-lo‘q', 'laq-laq', 'lik-lik', 'likang-likang', 'lapang-lapang', 'pildir-pildir', 'pir-pir', 'pag‘a-pag‘a', 'par-par', 'qilpang-qilpang',
                 'qalt-qalt', 'qult-qult', 'salang-salang', 'dik-dik', 'duv-duv', 'dikang-dikang', 'dir-dir', 'dag‘-dag‘', 'hil-hil', 'hilp-hilp', 'hang-mang',
                 'vij-vij', 'vijir-vijir', 'bij-bij', 'bijir-bijir', 'taqataq']


def convert_UPOS_to_Standard12(upos_tag, word):
    # This is a simple function that converts a UPOS tag to a Standard12 tag
    word = word.lower()    
    if upos_tag == 'NOUN' or upos_tag == 'PROPN':
        return 'NOUN'
    elif upos_tag == 'PRON' or upos_tag == 'DET':
        return 'PRON'
    elif upos_tag == 'CCONJ' or upos_tag == 'SCONJ':
        return 'CONJ'
    
    elif upos_tag == 'VERB':
        if word in imit_not_verb:
            return 'IMIT'
        return 'VERB'
    elif upos_tag == 'AUX':
        return 'VERB'
    
    elif upos_tag == 'ADV':
        if word in modal_not_adverb:
            return 'MOD'
        return 'ADV'
    
    elif upos_tag == 'ADJ':
        return 'ADJ'
    elif upos_tag == 'INTJ':
        return 'INTJ'
    elif upos_tag == 'NUM':
        return 'NUM'
    elif upos_tag == 'ADP':
        return 'AUX'
    elif upos_tag == 'PART':
        return 'PART'
    else : # upos_tag = 'X' or 'PUNCT' or 'SYM'
        return ''