import pandas as pd
import geopandas as gpd
from matplotlib import pyplot as plt

world = gpd.read_file(gpd.datasets.get_path("naturalearth_lowres"))
fra = world.index[world['name'] == "France"].tolist()[0]
nor = world.index[world['name'] == "Norway"].tolist()[0]
world.at[fra, 'iso_a3'] = "FRA"
world.at[nor, 'iso_a3'] = "NOR"

file = "results.by_country.csv"
df = pd.read_csv(file, index_col = 0)
df.loc[:,"Country"] = df.loc[:,"Country"].str.upper()
df = df.loc[:,["Region", "Country", "Geo (Full)"]]
df.columns = ["Region2", "Country", "Agreement"]
print(df)

world = pd.merge(left=world, right=df, left_on = "iso_a3", right_on = "Country", how = "outer")
print(world)
print(world.columns)
world.to_csv("check.csv")

world.plot(
    column="Agreement",
    legend=True,
    scheme="NaturalBreaks",
    k=8,
    cmap="OrRd",
    edgecolor="black",
    linewidth=0.4,
    missing_kwds={
        "color": "lightgrey",
        "edgecolor": "black",
        "label": "No Data",
        },
    )

plt.show()