import openai


class GPT3():
    def __init__(self, model_key, model_variant):
        if not model_key or not model_variant:
            raise Exception('Please provide a key and engine to use the GPT3 model.')
        openai.api_key = model_key
        self.engine = model_variant

    def compute(self, prompts, sample_decimals=False):
        response = openai.Completion.create(engine=self.engine, prompt=prompts, max_tokens=64,
                                            logprobs=0, temperature=1.0, top_p=0.6, echo=False, n=1)
        output = [r["text"] for r in response["choices"]]
        return output
