#!/bin/bash
#SBATCH --job-name=bbh_finetune # create a short name for your job
#SBATCH -p llm
#SBATCH -N 1 # node count
#SBATCH --ntasks-per-node 1 # number of tasks to run per node
#SBATCH --cpus-per-task 10 # cpu-cores per task (>1 if multi-threaded tasks),--cpus-per-task
#SBATCH --gpus-per-node 1 # total gpus for job

OUTPUT_PREFIX=inference_output
RUN=bbh

python3 bbh_hyperlora_inference_each_task.py \
    --seed 42 \
    --do_train \
    --do_eval \
    --do_predict \
    --finetune \
    --predict_with_generate \
    --bf16 \
    --dataset_name data/data_bbh \
    --model_name_or_path hf_models/flan-t5-large \
    --hypelora_name_or_path hf_models/hyperlora-t5-large \
    --pretrain_checkpoint YOUR_PRETRAIN_CHECKPOINT_FILE \
    --learning_rate 1e-3 \
    --logging_strategy steps \
    --logging_steps 1 \
    --num_train_epochs 50 \
    --per_device_train_batch_size 16 \
    --per_device_eval_batch_size 256 \
    --preprocessing_num_workers 16 \
    --n_demonstrations 5 \
    --generation_max_length 512 \
    --max_seq_length 2048 \
    --max_answer_length 512 \
    --val_max_answer_length 512 \
    --input_column inputs \
    --output_column targets \
    --temperature 8 \
    --lora_rank 16 \
    --lora_alpha 8 \
    --lora_dropout 0.05 \
    --report_to wandb \
    --run_name ${OUTPUT_PREFIX}_${RUN} \
    --output_dir output/$OUTPUT_PREFIX/$RUN/
