This repository contains the code for the paper "Robust Text Classification: Analyzing Prototype-Based Networks". In the following, different parts of the code and repository are explained for reproducibility purposes.

## Repository Structure

The structure of the repository can be broken down to three parts: (1) adversarial attacks and dataset creation, (2) training and evaluation of the Prototype-based networks, and (3) training and evaluation of the baseline vanilla models.

`datasets` directory contains the datasets used in the paper. This includes SST-2 from AdvGLUE, and IMDB, AGNews, and DBPedia that were further attacked by the authors. The script to run the attacks and extract the adversarial perturbed examples is also included in this directory.

`normal_models` directory contains the code for training and evaluating the baseline vanilla models. 

`PBN_Transformer` directory contains the code for training and evaluating the Prototype-based networks.

## Requirements

Since the purpose of each subdirectory as well as the tools and packages used in each of them are different, the requirements are also different and provided separately in each subdirectory as a conda environment file called `conda_environment.yml` that you can use to create a conda environment with the required packages by running the following command:

```
conda env create -f conda_environment.yml
```

## Visualizing the Results

All the results for the targeted attacks can be reproduced in `analysis_on_targeted_attacks.ipynb` and the results for the static attacks can be reproduced in `analysis_on_static_attacks.ipynb`. Both of the notebooks cover both the PBN models and the baseline models.