import json
from tqdm import tqdm
from pathlib import Path
import argparse
from collections import defaultdict

def read_jsonlist(path):
    res = defaultdict(lambda : defaultdict(int))
    with open(path, encoding="utf8") as f:
        for ln in tqdm(f):
            if not ln:
                continue
            if ln.strip() == '':
                continue
            try:
                di = json.loads(ln.strip())
                res[di['author']][di['subreddit']] += 1
            except:
                print('Encountered an error. Skipping a line.')
                continue
    return res


parser = argparse.ArgumentParser()
parser.add_argument("--in_file", type=str, required=True)
parser.add_argument("--out_dir", type=str, required=True)
args = parser.parse_args()
print(args)
out_dir = Path(args.out_dir)
out_dir.mkdir(exist_ok=True)
res = read_jsonlist(Path(args.in_file))
with open(out_dir / f'{Path(args.in_file).parts[-1]}.json', 'w') as f:
    json.dump(res, f)