#!/bin/bash
set -x
dir=$1
#/mnt/user/E-xiaoyi.zp-102098/llm/DeepSpeedChat/applications/DeepSpeed-Chat/output/actor-models/llama7b_en2de_targets/
ref=/mnt/alitranx-nas/users/xiaoyi.zp/llm/docdata/de-en/iwslt16.de
#ref = "/mnt/alitranx-nas/users/xiaoyi.zp/llm/docdata/zh-en/wmt22.en1 /mnt/alitranx-nas/users/xiaoyi.zp/llm/docdata/zh-en/wmt22.en2"
testset=$2
#/mnt/alitranx-nas/users/xiaoyi.zp/llm/docdata/iwslt17_en2de/en-de/test.split.jsonl
models=`ls -d -t  $dir/step*`
evals=$dir/evals
base_model=$3
port=$4
need_convert=$5
mkdir -p $evals

#export CUDA_VISIBLE_DEVICES=0
for model in $models
do
    epoch=${model##*\/}
    echo $epoch
    if [ -s $evals/trans.$epoch.trans.bleu ];
    then
        continue
        echo "skip"
    fi
    curr_model=$model
    if [ $need_convert -eq 1 ];
    then
      curr_model=$model/convert
      if [ ! -s $model/convert/pytorch_model.bin ];
      then
        mkdir -p $model/convert
        python /mnt/user/E-xiaoyi.zp-102098/llm/DeepSpeedChat/applications/DeepSpeed-Chat/training/step1_supervised_finetuning/evaluation_scripts/convert_lora_model.py \
      --model_path $model/pytorch_model.bin --save_dir $model/convert --lora_dim 128
        cp $model/config.json $model/convert/
      fi
    fi

    torchrun --nproc_per_node 1  --master_port $port \
        /mnt/user/E-xiaoyi.zp-102098/llm/DeepSpeedChat/applications/DeepSpeed-Chat/training/step1_supervised_finetuning/prompt_eval_test.py \
        --deepspeed  --model_name_or_path_baseline $base_model \
        --model_name_or_path_finetune $curr_model \
        --input $testset --language English --zero_stage 1 \
        --output $evals/trans.$epoch --bf16 --per_device_batch_size 1
    python  /mnt/user/E-xiaoyi.zp-102098/tools/get_prediction.py $evals/trans.$epoch >   $evals/trans.$epoch.trans
    cat  $evals/trans.$epoch.trans  |  sacrebleu -l en-de  $ref -lc > $evals/trans.$epoch.trans.bleu_lc
    cat  $evals/trans.$epoch.trans | sacrebleu -l en-de  $ref  > $evals/trans.$epoch.trans.bleu
done

