/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.lmdbjni;

import java.util.Comparator;
import org.fusesource.hawtjni.runtime.Callback;
import org.fusesource.lmdbjni.BufferCursor;
import org.fusesource.lmdbjni.Constants;
import org.fusesource.lmdbjni.Cursor;
import org.fusesource.lmdbjni.DirectBuffer;
import org.fusesource.lmdbjni.EntryIterator;
import org.fusesource.lmdbjni.Env;
import org.fusesource.lmdbjni.JNI;
import org.fusesource.lmdbjni.NativeBuffer;
import org.fusesource.lmdbjni.NativeObject;
import org.fusesource.lmdbjni.Stat;
import org.fusesource.lmdbjni.Transaction;
import org.fusesource.lmdbjni.Unsafe;
import org.fusesource.lmdbjni.Util;
import org.fusesource.lmdbjni.Value;

public class Database
extends NativeObject
implements AutoCloseable {
    private final Env env;

    Database(Env env, long self) {
        super(self);
        this.env = env;
    }

    @Override
    public void close() {
        if (this.self != 0L) {
            JNI.mdb_dbi_close(this.env.pointer(), this.self);
            this.self = 0L;
        }
    }

    public Stat stat() {
        try (Transaction tx = this.env.createReadTransaction();){
            Stat stat = new Stat(this.stat(tx));
            return stat;
        }
    }

    public Stat stat(Transaction tx) {
        Util.checkArgNotNull(tx, "tx");
        JNI.MDB_stat rc = new JNI.MDB_stat();
        JNI.mdb_stat(tx.pointer(), this.pointer(), rc);
        return new Stat(rc);
    }

    public void drop(boolean delete) {
        try (Transaction tx = this.env.createWriteTransaction();){
            this.drop(tx, delete);
            tx.commit();
        }
    }

    public void drop(Transaction tx, boolean delete) {
        Util.checkArgNotNull(tx, "tx");
        JNI.mdb_drop(tx.pointer(), this.pointer(), delete ? 1 : 0);
        if (delete) {
            this.self = 0L;
        }
    }

    public int get(DirectBuffer key, DirectBuffer value) {
        Util.checkArgNotNull(key, "key");
        try (Transaction tx = this.env.createReadTransaction();){
            int n = this.get(tx, key, value);
            return n;
        }
    }

    public int get(Transaction tx, DirectBuffer key, DirectBuffer value) {
        Util.checkArgNotNull(key, "key");
        Util.checkArgNotNull(value, "value");
        long address = tx.getBufferAddress();
        Unsafe.putLong(address, 0, key.capacity());
        Unsafe.putLong(address, 1, key.addressOffset());
        int rc = JNI.mdb_get_address(tx.pointer(), this.pointer(), address, address + (long)(2 * Unsafe.ADDRESS_SIZE));
        if (rc == JNI.MDB_NOTFOUND) {
            return JNI.MDB_NOTFOUND;
        }
        int valSize = (int)Unsafe.getLong(address, 2);
        long valAddress = Unsafe.getAddress(address, 3);
        value.wrap(valAddress, valSize);
        return rc;
    }

    public byte[] get(byte[] key) {
        Util.checkArgNotNull(key, "key");
        try (Transaction tx = this.env.createReadTransaction();){
            byte[] byArray = this.get(tx, key);
            return byArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] get(Transaction tx, byte[] key) {
        Util.checkArgNotNull(tx, "tx");
        Util.checkArgNotNull(key, "key");
        NativeBuffer keyBuffer = NativeBuffer.create(key);
        try {
            byte[] byArray = this.get(tx, keyBuffer);
            return byArray;
        }
        finally {
            keyBuffer.delete();
        }
    }

    private byte[] get(Transaction tx, NativeBuffer keyBuffer) {
        return this.get(tx, new Value(keyBuffer));
    }

    private byte[] get(Transaction tx, Value key) {
        Value value = new Value();
        int rc = JNI.mdb_get(tx.pointer(), this.pointer(), key, value);
        if (rc == JNI.MDB_NOTFOUND) {
            return null;
        }
        Util.checkErrorCode(rc);
        return value.toByteArray();
    }

    public EntryIterator seek(Transaction tx, byte[] key) {
        return this.iterate(tx, key, EntryIterator.IteratorType.FORWARD);
    }

    public EntryIterator seekBackward(Transaction tx, byte[] key) {
        return this.iterate(tx, key, EntryIterator.IteratorType.BACKWARD);
    }

    public EntryIterator iterate(Transaction tx) {
        return this.iterate(tx, null, EntryIterator.IteratorType.FORWARD);
    }

    public EntryIterator iterateBackward(Transaction tx) {
        return this.iterate(tx, null, EntryIterator.IteratorType.BACKWARD);
    }

    private EntryIterator iterate(Transaction tx, byte[] key, EntryIterator.IteratorType type) {
        Cursor cursor = this.openCursor(tx);
        return new EntryIterator(cursor, key, type);
    }

    public BufferCursor bufferCursor(Transaction tx) {
        return this.bufferCursor(tx, 1024);
    }

    public BufferCursor bufferCursor(Transaction tx, int maxValueSize) {
        Cursor cursor = this.openCursor(tx);
        return new BufferCursor(cursor, maxValueSize);
    }

    public BufferCursor bufferCursor(Transaction tx, DirectBuffer key, DirectBuffer value) {
        Cursor cursor = this.openCursor(tx);
        return new BufferCursor(cursor, key, value);
    }

    public int put(DirectBuffer key, DirectBuffer value) {
        return this.put(key, value, 0);
    }

    public int put(DirectBuffer key, DirectBuffer value, int flags) {
        Util.checkArgNotNull(key, "key");
        try (Transaction tx = this.env.createWriteTransaction();){
            int ret = this.put(tx, key, value, flags);
            tx.commit();
            int n = ret;
            return n;
        }
    }

    public void put(Transaction tx, DirectBuffer key, DirectBuffer value) {
        this.put(tx, key, value, 0);
    }

    public int put(Transaction tx, DirectBuffer key, DirectBuffer value, int flags) {
        Util.checkArgNotNull(key, "key");
        Util.checkArgNotNull(value, "value");
        long address = tx.getBufferAddress();
        Unsafe.putLong(address, 0, key.capacity());
        Unsafe.putLong(address, 1, key.addressOffset());
        Unsafe.putLong(address, 2, value.capacity());
        Unsafe.putLong(address, 3, value.addressOffset());
        int rc = JNI.mdb_put_address(tx.pointer(), this.pointer(), address, address + (long)(2 * Unsafe.ADDRESS_SIZE), flags);
        Util.checkErrorCode(rc);
        return rc;
    }

    public DirectBuffer reserve(Transaction tx, DirectBuffer key, int size) {
        Util.checkArgNotNull(key, "key");
        long address = tx.getBufferAddress();
        Unsafe.putLong(address, 0, key.capacity());
        Unsafe.putLong(address, 1, key.addressOffset());
        Unsafe.putLong(address, 2, size);
        int rc = JNI.mdb_put_address(tx.pointer(), this.pointer(), address, address + (long)(2 * Unsafe.ADDRESS_SIZE), Constants.RESERVE);
        Util.checkErrorCode(rc);
        int valSize = (int)Unsafe.getLong(address, 2);
        long valAddress = Unsafe.getAddress(address, 3);
        DirectBuffer empty = new DirectBuffer(0L, 0);
        empty.wrap(valAddress, valSize);
        return empty;
    }

    public byte[] put(byte[] key, byte[] value) {
        return this.put(key, value, 0);
    }

    public byte[] put(byte[] key, byte[] value, int flags) {
        Util.checkArgNotNull(key, "key");
        try (Transaction tx = this.env.createWriteTransaction();){
            byte[] ret = this.put(tx, key, value, flags);
            tx.commit();
            byte[] byArray = ret;
            return byArray;
        }
    }

    public byte[] put(Transaction tx, byte[] key, byte[] value) {
        return this.put(tx, key, value, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] put(Transaction tx, byte[] key, byte[] value, int flags) {
        Util.checkArgNotNull(tx, "tx");
        Util.checkArgNotNull(key, "key");
        Util.checkArgNotNull(value, "value");
        NativeBuffer keyBuffer = NativeBuffer.create(key);
        try {
            NativeBuffer valueBuffer = NativeBuffer.create(value);
            try {
                byte[] byArray = this.put(tx, keyBuffer, valueBuffer, flags);
                valueBuffer.delete();
                return byArray;
            }
            catch (Throwable throwable) {
                valueBuffer.delete();
                throw throwable;
            }
        }
        finally {
            keyBuffer.delete();
        }
    }

    private byte[] put(Transaction tx, NativeBuffer keyBuffer, NativeBuffer valueBuffer, int flags) {
        return this.put(tx, new Value(keyBuffer), new Value(valueBuffer), flags);
    }

    private byte[] put(Transaction tx, Value keySlice, Value valueSlice, int flags) {
        int rc = JNI.mdb_put(tx.pointer(), this.pointer(), keySlice, valueSlice, flags);
        if ((flags & JNI.MDB_NOOVERWRITE) != 0 && rc == JNI.MDB_KEYEXIST) {
            return valueSlice.toByteArray();
        }
        Util.checkErrorCode(rc);
        return null;
    }

    public boolean delete(DirectBuffer key) {
        return this.delete(key, null);
    }

    public boolean delete(Transaction tx, DirectBuffer key) {
        Util.checkArgNotNull(key, "key");
        return this.delete(tx, key, null);
    }

    public boolean delete(DirectBuffer key, DirectBuffer value) {
        Util.checkArgNotNull(key, "key");
        try (Transaction tx = this.env.createWriteTransaction();){
            boolean ret = this.delete(tx, key, value);
            tx.commit();
            boolean bl = ret;
            return bl;
        }
    }

    public boolean delete(Transaction tx, DirectBuffer key, DirectBuffer value) {
        byte[] keyBytes = new byte[key.capacity()];
        byte[] valueBytes = null;
        key.getBytes(0, keyBytes);
        if (value != null) {
            valueBytes = new byte[value.capacity()];
            value.getBytes(0, valueBytes);
        }
        return this.delete(tx, keyBytes, valueBytes);
    }

    public boolean delete(byte[] key) {
        return this.delete(key, null);
    }

    public boolean delete(byte[] key, byte[] value) {
        Util.checkArgNotNull(key, "key");
        try (Transaction tx = this.env.createWriteTransaction();){
            boolean ret = this.delete(tx, key, value);
            tx.commit();
            boolean bl = ret;
            return bl;
        }
    }

    public boolean delete(Transaction tx, byte[] key) {
        Util.checkArgNotNull(key, "key");
        return this.delete(tx, key, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean delete(Transaction tx, byte[] key, byte[] value) {
        Util.checkArgNotNull(tx, "tx");
        Util.checkArgNotNull(key, "key");
        NativeBuffer keyBuffer = NativeBuffer.create(key);
        try {
            NativeBuffer valueBuffer = NativeBuffer.create(value);
            try {
                boolean bl = this.delete(tx, keyBuffer, valueBuffer);
                if (valueBuffer != null) {
                    valueBuffer.delete();
                }
                return bl;
            }
            catch (Throwable throwable) {
                if (valueBuffer != null) {
                    valueBuffer.delete();
                }
                throw throwable;
            }
        }
        finally {
            keyBuffer.delete();
        }
    }

    private boolean delete(Transaction tx, NativeBuffer keyBuffer, NativeBuffer valueBuffer) {
        return this.delete(tx, new Value(keyBuffer), Value.create(valueBuffer));
    }

    private boolean delete(Transaction tx, Value keySlice, Value valueSlice) {
        int rc = JNI.mdb_del(tx.pointer(), this.pointer(), keySlice, valueSlice);
        if (rc == JNI.MDB_NOTFOUND) {
            return false;
        }
        Util.checkErrorCode(rc);
        return true;
    }

    public Cursor openCursor(Transaction tx) {
        long[] cursor = new long[1];
        Util.checkErrorCode(JNI.mdb_cursor_open(tx.pointer(), this.pointer(), cursor));
        return new Cursor(cursor[0], tx.isReadOnly());
    }

    public void setComparator(Transaction tx, Comparator<byte[]> comparator) {
        Callback callback = new Callback(new ByteArrayComparator(comparator), "compare", 2);
        JNI.mdb_set_compare(tx.pointer(), this.pointer(), callback.getAddress());
    }

    public void setDirectComparator(Transaction tx, Comparator<DirectBuffer> comparator) {
        Callback callback = new Callback(new DirectBufferComparator(comparator), "compare", 2);
        JNI.mdb_set_compare(tx.pointer(), this.pointer(), callback.getAddress());
    }

    private static final class DirectBufferComparator {
        Comparator<DirectBuffer> comparator;

        public DirectBufferComparator(Comparator<DirectBuffer> comparator) {
            this.comparator = comparator;
        }

        public long compare(long ptr1, long ptr2) {
            int size = (int)Unsafe.getLong(ptr1, 0);
            long address = Unsafe.getAddress(ptr1, 1);
            DirectBuffer key1 = new DirectBuffer();
            key1.wrap(address, size);
            size = (int)Unsafe.getLong(ptr2, 0);
            address = Unsafe.getAddress(ptr2, 1);
            DirectBuffer key2 = new DirectBuffer();
            key2.wrap(address, size);
            return this.comparator.compare(key1, key2);
        }
    }

    private static final class ByteArrayComparator {
        Comparator<byte[]> comparator;

        public ByteArrayComparator(Comparator<byte[]> comparator) {
            this.comparator = comparator;
        }

        public long compare(long ptr1, long ptr2) {
            int size = (int)Unsafe.getLong(ptr1, 0);
            long address = Unsafe.getAddress(ptr1, 1);
            DirectBuffer key1 = new DirectBuffer();
            key1.wrap(address, size);
            byte[] key1Bytes = new byte[size];
            key1.getBytes(0, key1Bytes);
            size = (int)Unsafe.getLong(ptr2, 0);
            address = Unsafe.getAddress(ptr2, 1);
            DirectBuffer key2 = new DirectBuffer();
            key2.wrap(address, size);
            byte[] key2Bytes = new byte[size];
            key2.getBytes(0, key2Bytes);
            return this.comparator.compare(key1Bytes, key2Bytes);
        }
    }
}

