from tqdm import tqdm
from prompt_template_class import GroupingGenerator
from langchain import LLMChain
from langchain.chat_models import ChatOpenAI
from langchain.llms import OpenAI
from api_key import *
from langchain.prompts.chat import SystemMessagePromptTemplate, ChatPromptTemplate
from output_parser import GroupingOutputParser
from data_creator import GroupingDataCreator
import argparse
from utlis import str2bool
import random
import numpy as np
from langchain.prompts import PromptTemplate
from utlis import load_llama, get_prompt, B_INST, E_INST

parser = argparse.ArgumentParser()
parser.add_argument("--num_examples", type=int, default=200)
parser.add_argument("--model_name", type=str, default="text-davinci-003")
parser.add_argument("--few_shot", type=str2bool, default=True)
parser.add_argument("--cot", type=str2bool, default=False)
parser.add_argument("--multiple_run", type=str2bool, default=True)
args = parser.parse_args()
print(args)
# 1.0 0.25 0.06 False False
# 0.733 0 0 True False
# 0.433 0 0 True True
num_polygons = 30  # Generate more polygons
num_rules = 15
sides_options = [3, 4, 5, 6, 7, 8, 9, 10, 11, 12]
colors_options = ['red', 'blue', "while", "black", "yellow", "purple", "gray", "cyan", "brown", "indigo"]
materials_options = ['metal', 'plastic', "glass", "sliver", "gold", "copper", "bronze", "diamond", "jade"]
if "gpt-3.5" in args.model_name or "gpt-4" in args.model_name:
    llm = ChatOpenAI(model=args.model_name, openai_api_key=openai.api_key, temperature=0)
elif "llama" in args.model_name:
    args.model_name = "meta-llama/Llama-2-13b-chat-hf"
    llm = load_llama(args.model_name)
else:
    llm = OpenAI(model=args.model_name, openai_api_key=openai.api_key, temperature=0)
output_parser = GroupingOutputParser()
meta_validation_acc = []
meta_full_acc = []
meta_average_acc = []
seed_list = [714, 123] if args.multiple_run == True else [714]
for seed in seed_list:
    random.seed(seed)
    grouping_creator = GroupingDataCreator(num_polygons, num_rules, sides_options, colors_options, materials_options)
    prompt_generator = GroupingGenerator()
    # Generate polygons and groups
    acc_list = []
    few_shot_polygons = []
    few_shot_groups = []
    few_shot_deleted_groups = []
    few_shot_selected_rules = []
    for _ in range(2):
        if _ <= 0:
            determinstic = "Clean"
        else:
            determinstic = "Noise"
        polygons, groups, selected_rules = grouping_creator.create()
        rules, deleted_rules = prompt_generator.deleted_rules(groups, determinstic=determinstic)
        few_shot_polygons.append(polygons)
        few_shot_groups.append(groups)
        few_shot_deleted_groups.append(deleted_rules)
        few_shot_selected_rules.append(selected_rules)

    validation_count = 0
    explanation_count = 0
    full_correct_count = 0
    total_explanation_count = 0
    total_explanation_example = 0
    num_example = args.num_examples
    all_prompt = prompt_generator.grouping_rules_incorporating(few_shot_polygons, few_shot_groups, few_shot_deleted_groups, few_shot_selected_rules, chain_of_thought=args.cot,
                                                         few_shot=args.few_shot)
    chat_prompt = ChatPromptTemplate.from_messages(all_prompt)
    if "gpt" in args.model_name or "davinci" in args.model_name:
        chain = LLMChain(llm=llm, prompt=chat_prompt)
    else:
        system = ""
        sides_text = str(sides_options).rstrip("]").lstrip("[")
        materials_text = str(materials_options).rstrip("]").lstrip("[")
        colors_text = str(colors_options).rstrip("]").lstrip("[")
        system += chat_prompt.messages[0].format(Colors=colors_text, Materials=materials_text,
                                                 SidesNumber=sides_text).content
        instruction = ""
        example_idx = 0
        if len(chat_prompt.messages) > 2:
            for message in chat_prompt.messages[1:-1]:
                if message.additional_kwargs["name"] == "example_user":
                    if example_idx == 0:
                        instruction += message.format().content + " " + E_INST + " "
                    else:
                        instruction += "<s>" + B_INST + " " +message.format().content + " " +E_INST + " "
                    example_idx += 1
                elif message.additional_kwargs["name"] == "example_assistant":
                    instruction += message.format().content + " " + "</s>\\"+ "\n"
        system += "Additionally, please just output the answer with provided format and don't add any other explanation."
        instruction += chat_prompt.messages[-1].format(Polygons="{Polygons}", Rules="{Rules}",
                                                       GroupingResult="{GroupingResult}"
                                                       ).content
        template = get_prompt(instruction, system)
        prompt = PromptTemplate(template=template, input_variables=["Polygons", "Rules", "GroupingResult"])
        chain = LLMChain(prompt=prompt, llm=llm)
    for _ in tqdm(range(num_example)):  # Adjust the range for your needs
        polygons, groups, selected_rules = grouping_creator.create()
        rules, deleted_rules = prompt_generator.deleted_rules(groups)
        deleted_rules_text = prompt_generator.generating_rules(deleted_rules)
        polygons_text, sides, materials, colors, deleted_results_text, deleted_rules_prompt = prompt_generator.generate_grouping_results(polygons, sides_options,
                                                                                                           colors_options, materials_options, deleted_rules)
        polygons_text, sides, materials, colors, results_text, rules_prompt = prompt_generator.generate_grouping_results(polygons,
                                                                                                           sides_options,
                                                                                                           colors_options,
                                                                                                           materials_options,
                                                                                                           groups)
        rules_text = prompt_generator.generating_rules(groups)
        if "gpt" in args.model_name or "davinci" in args.model_name:
            output = chain.run(Polygons=polygons_text, SidesNumber=sides, Colors=colors, Materials=materials, GroupingResult=results_text,
                           Rules=deleted_rules_prompt)
        else:
            output = chain.run(Polygons=polygons_text,
                               GroupingResult=results_text,
                               Rules=deleted_rules_prompt)
        print(output)
        predict, added_rules = output_parser.parse_rule_incorporation(output)
        if deleted_rules != rules:
            differ = set(deleted_rules.keys()) ^ set(rules.keys())
            total_explanation_count += len(differ)
            total_explanation_example += 1
        if predict == "No" and deleted_rules == rules:
            validation_count += 1
        elif predict == "Yes" and deleted_rules != rules:
            validation_count += 1
            local_explanation_count = 0
            for rule in differ:
                if rule in added_rules:
                    explanation_count += 1
                    local_explanation_count += 1
            if local_explanation_count == len(differ):
                full_correct_count += 1
    print(f"The Validation Accuracy: {validation_count/num_example}")
    print(f"The Explanation Accuracy: {explanation_count/total_explanation_count}")
    print(f"The Full Explanation Accuracy: {full_correct_count/total_explanation_example}")
    print(f"---------------")
    meta_validation_acc.append(validation_count/num_example)
    meta_average_acc.append(explanation_count/total_explanation_count)
    meta_full_acc.append(full_correct_count/total_explanation_example)
for idx, validation_acc, average_acc, full_acc in zip(seed_list, meta_validation_acc, meta_average_acc, meta_full_acc):
    print(f"Validation Accuracy: {validation_acc}")
    print(f"Explanation Accuracy: {average_acc}")
    print(f"Full Explanation Accuracy: {full_acc}")
    print(f"------Seed {idx}------")
print(f"The Meta Validation Accuracy: {np.mean(meta_validation_acc)}")
print(f"STD of Validation Accuracy: {np.std(meta_validation_acc)}")
print(f"The Meta Explanation Accuracy: {np.mean(meta_average_acc)}")
print(f"STD of Explanation Accuracy: {np.std(meta_average_acc)}")
print(f"The Meta Full Explanation Accuracy: {np.mean(meta_full_acc)}")
print(f"STD of Full Explanation Accuracy: {np.std(meta_full_acc)}")
