#! bin/bash
set -e

task_name=mnli_mm # (sst2, rte, qqp, qnli, mnli, mnli_mm))
method=vanilla # for file name
local_rank=0 #cuda_num
ver=1 # as a random seed for data sampling in low resorce scenarios
samples=1000 # (number of sample in low resources)
train_batch_size=16
eval_batch_size=4
num_train_epochs=100
patience=5 #patience for early stopping
lr=2e-5

mkdir -p results/${task_name}/${method}/version_${ver}

result_name=results/${task_name}/${method}/version_${ver}/test1.txt
train_dir=data/clean/bert-base-uncased/${task_name}_train
eval_dir=data/clean/bert-base-uncased/${task_name}_test
attacked_dir=data/attacked/bert-base-uncased/${task_name}
bert_model=bert-base-uncased
output_dir=results/${task_name}/${method}/version_${ver}


python3 -u run_bert.py >$result_name\
    --train_dir $train_dir \
    --eval_dir $eval_dir \
    --train_batch_size $train_batch_size \
    --eval_batch_size $eval_batch_size \
    --attacked_dir $attacked_dir \
    --bert_model $bert_model \
    --task_name $task_name \
    --output_dir $output_dir \
    --num_train_epochs $num_train_epochs\
    --learning_rate $lr\
    --max_seq_length $max_seq_length \
    --local_rank $local_rank  \
    --early_stop $patience\
    --print_params \
    --do_eval \
    --do_train \
    --num_samples $samples\  # If you want to run with full data, erase it
    --sample_seed $ver\
