client_type_dict = {
    "azure": [
        "text-davinci-003",
        "Llama-3-70B-Instruct",
        "Llama2-70B",
        "Llama2-70B-chat",
    ],
    "vllm": [
        "NousResearch/Meta-Llama-3-70B",
        "NousResearch/Meta-Llama-3-70B-Instruct",
        "NousResearch/Meta-Llama-3-8B",
        "NousResearch/Meta-Llama-3-8B-Instruct",
        "NousResearch/Llama-2-70b-hf",
        "NousResearch/Llama-2-70B-chat-hf",
        "NousResearch/Llama-2-13b-hf",
        "NousResearch/Llama-2-7b-chat-hf",
        "NousResearch/Llama-2-7b-hf",
        "NousResearch/Llama-2-7b-chat-hf",
        "NousResearch/CodeLlama-34b-hf",
        "NousResearch/CodeLlama-13b-hf",
        "NousResearch/CodeLlama-7b-hf",
        "huggyllama/llama-65b",
        "huggyllama/llama-30b",
        "huggyllama/llama-13b",
        "huggyllama/llama-7b",
    ],
    "openai": [
        "gpt-4-turbo",
        "gpt-4-turbo-2024-04-09",
        "gpt-3.5-turbo-0125",
    ],
}

max_concurrency_dict = {
    "azure": 10,
    "vllm": 2,
    "openai": 10,
}


def get_client_type(model_name):
    for client_type, models in client_type_dict.items():
        if model_name in models:
            return client_type
    raise ValueError(f"Model {model_name} not found in any of the supported clients")
