import requests
import json
import time

def get_oai_completion(
    INSTRUCTION="hello",
    max_tokens=2048,
    temperature=0.0,
    api_key=None,
    sys_prompt="You are a helpful assistant.",
):
    headers = {
        "Content-Type": "application/json",
        "Authorization": f"Bearer {api_key}"
    }

    payload = {
        "model": "gpt-3.5-turbo-1106",
        "messages": [
            {
                "role": "system",
                "content": [
                    {
                        "type": "text",
                        "text": sys_prompt,
                    },
                ]
            },
            {
                "role": "user",
                "content": [
                    {
                        "type": "text",
                        "text": INSTRUCTION,
                    },
                ]
            }
        ],
        "max_tokens": max_tokens,
        "temperature": temperature,
    }
    response = requests.post("https://api.openai.org/v1/chat/completions", headers=headers, json=payload).json()
    return response["choices"][0]['message']['content']


def call_chatgpt(
    ins,
    temp,
    max_tokens,
    api_key,
    sys_prompt,
):
    success = False
    re_try_count = 8
    ans = ''
    while not success and re_try_count >= 0:
        re_try_count -= 1
        try:
            ans = get_oai_completion(ins, max_tokens, temp, api_key, sys_prompt)
            success = True
        except:
            time.sleep(5)
            print('retry for sample:', ins)
    return ans