/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.ie.crf;

import edu.stanford.nlp.ie.crf.CliquePotentialFunction;

public class LinearCliquePotentialFunction
implements CliquePotentialFunction {
    double[][] weights;

    LinearCliquePotentialFunction(double[][] weights) {
        this.weights = weights;
    }

    @Override
    public double computeCliquePotential(int cliqueSize, int labelIndex, int[] cliqueFeatures, double[] featureVal, int posInSent) {
        double output = 0.0;
        double dotProd = 0.0;
        for (int m = 0; m < cliqueFeatures.length; ++m) {
            dotProd = this.weights[cliqueFeatures[m]][labelIndex];
            if (featureVal != null) {
                dotProd *= featureVal[m];
            }
            output += dotProd;
        }
        return output;
    }
}

