import os
import json

def all_words_in_string(word_list, target_string):
    return all(word in target_string for word in word_list)

def remove_word(word_list):
    word_to_remove = [
    "a", "an", "the",
    "and", "or", "but", "because", "so", "for", "yet",
    "in", "on", "at", "by", "with", "about", "into", "through", "between", "under", "over", "before", "after",
    "of", "to", "from", "off", "about",
    "is", "am", "are", "was", "were", "be", "being", "been",
    "have", "has", "had", "do", "does", "did", "doing",
    "will", "would", "shall", "should", "can", "could", "may", "might", "must",
    "this", "that", "these", "those",
    "who", "whom", "whose", "which", "what", "when", "where", "why", "how",
    "him", "her", "his", "hers", "it", "its", "they", "them", "their",
    "my", "mine", "your", "yours", "our", "ours", "its", "their", "theirs",
    "all", "some", "few", "many", "much", "each", "every", "other", "another",
    "such", "no", "not",
    "he", "she", "it", "we", "they",
    "me", "us", "you",
    "then", "than"
]
    return [word for word in word_list if word not in word_to_remove] 

task = "predictions"
predictions = []
with open(os.path.join("results/hotpotQA/chatgpt4_chat/test", "{}.jsonl".format(task))) as fin:
# with open(os.path.join("results/hotpotQA/ours4_v11/test", "{}.jsonl".format(task))) as fin:
    for line in fin:
        example = json.loads(line)
        predictions.append({
            "story": example['story'],
            "question": example["question"],
            "answer": example["answer"].strip(),
            # "prediction": example["model_output"].strip().split("\n\n")[-1].strip()
            "prediction": example["model_output"]
        })
# with open(os.path.join("results/clutrr/story/ours4_v4_2/1.3", "{}.jsonl".format(task))) as fin:
#     for line in fin:
#         example = json.loads(line)
#         predictions.append({
#             "story": example['story'],
#             "question": example["question"],
#             "answer": example["answer"].strip(),
#             "prediction": example["prediction"].strip()
#         })

ACC = 0
cnt = 0
for item in predictions:
    print ("cnt", cnt)
    ans = item["answer"].lower().replace(".", "")
    word_list = ans.split(" ")
    word_list = remove_word(word_list)
    if all_words_in_string(word_list, item["prediction"].lower()):
        ACC+=1
        # print ("match")
    else:
        print ("unmatch")
        print ("question", item["question"] )
        print ("target", ans)
        print ("prediction", item["prediction"])

    cnt+=1

    
em_score = ACC/len(predictions)
print(f"Exact match : {em_score}")

