export CUDA_VISIBLE_DEVICES=0

# SNR -10 -5 0 5 10
# Noise type
# 1:AirConditioner_6        2:Babble_4       3:Munching_3  4:ShuttingDoor_6  5:VacuumCleaner_1
# 6:AirportAnnouncements_2  7:CopyMachine_2  8:Typing_2     Neighbor_6

dataset_dir=/path/to/LibriSpeech
model_dir=facebook/wav2vec2-base-960h
task=librispeech
type=AirportAnnouncements_2

for snr in 10 5 0 -5 -10; do  
    python main_tent.py --asr $model_dir \
                --steps 10 \
                --dataset_name $task \
                --dataset_dir $dataset_dir \
                --temp 2.5 \
                --episodic \
                --non_blank \
                --em_coef 1.0 \
                --reweight \
                --log_dir exps_tent_$type \
                --lr 2e-4 \
                --extra_noise 0 \
                --noise_type $type \
                --noise_snr $snr


    python main_sar.py --asr $model_dir \
                --steps 10 \
                --dataset_name $task \
                --dataset_dir $dataset_dir \
                --temp 2.5 \
                --episodic \
                --non_blank \
                --em_coef 1.0 \
                --reweight \
                --log_dir exps_sar_$type \
                --lr 2e-4 \
                --extra_noise 0 \
                --noise_type $type \
                --noise_snr $snr 


    python main_teco.py --asr $model_dir \
                --steps 10 \
                --dataset_name $task \
                --dataset_dir $dataset_dir \
                --temp 2.5 \
                --episodic \
                --non_blank \
                --em_coef 1.0 \
                --reweight \
                --log_dir exps_teco_$type \
                --lr 2e-4 \
                --extra_noise 0  


    python main_suta.py --asr $model_dir \
                --steps 10 \
                --dataset_name $task \
                --dataset_dir $dataset_dir \
                --temp 2.5 \
                --episodic \
                --non_blank \
                --em_coef 0.3 \
                --reweight \
                --log_dir exps_suta_$type \
                --lr 2e-4 \
                --extra_noise 0 \
                --noise_type $type \
                --noise_snr $snr 


    python main_cea.py --asr $model_dir \
            --steps 20 \
            --dataset_name $task \
            --dataset_dir $dataset_dir \
            --temp 2.5 \
            --episodic \
            --em_coef 0.3 \
            --reweight \
            --log_dir exps_cea_$type \
            --lr 2e-5 \
            --lr2 2e-4 \
            --non_blank \
            --train_feature \
            --extra_noise 0 \
            --noise_type $type \
            --noise_snr $snr
            
done
