theory question_87_0

imports Main

begin

typedecl entity
typedecl event

consts
  Tunicates :: "entity ⇒ bool"
  SexualReproduction :: "entity ⇒ bool"
  Reproduce :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  Patient :: "event ⇒ entity ⇒ bool"
  Bulbs :: "entity ⇒ bool"
  NonTunicates :: "entity ⇒ bool"

(* Explanation 1: Tunicates reproduce sexually. *)
axiomatization where
  explanation_1: "∀x. Tunicates x ⟶ (∃y e. SexualReproduction y ∧ Reproduce e ∧ Agent e x ∧ Patient e y)"

(* Explanation 2: Bulbs are classifies as tunicate or non-tunicate. *)
axiomatization where
  explanation_2: "∀x. Bulbs x ⟶ (Tunicates x ∨ NonTunicates x)"

theorem hypothesis:
  assumes asm: "Bulbs x"
  (* Hypothesis: Bulbs reproduce sexually. *)
  shows "∃y e. SexualReproduction y ∧ Reproduce e ∧ Agent e x ∧ Patient e y"
proof -
  from asm have "Bulbs x" by simp
  then obtain y where y: "Tunicates y ∨ NonTunicates y" using explanation_2 by blast
  then show ?thesis if "Tunicates y" using y explanation_1 asm by blast
qed

end
