theory question_57_2
imports Main

begin

typedecl entity
typedecl event

consts
  Cancer :: "entity ⇒ bool"
  CellCycleRegulation :: "entity ⇒ bool"
  Disease :: "entity ⇒ bool"
  Metastatic :: "entity ⇒ bool"

axiomatization where
  explanation_1: "∀x. Disease x ∧ ¬ CellCycleRegulation x ⟶ Cancer x"
  explanation_2: "∀x. Cancer x ⟶ Metastatic x"

theorem hypothesis:
  assumes asm: "Disease x ∧ ¬ CellCycleRegulation x"
  (* Hypothesis: A disease that can be metastatic occurs when the cell cycle is regulated no longer. *)
  shows "Metastatic x"
proof -
  from asm have "Disease x ⟶ Cancer x" using explanation_1 by blast
  with asm have "Cancer x" by simp
  then show "Metastatic x" using explanation_2 by blast
qed

end
